/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.CheckoutOrderResponse;
import com.adyen.model.checkout.FraudResult;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.PaymentResponseAction;
import com.adyen.model.checkout.PaymentValidationsResponse;
import com.adyen.model.checkout.ResponsePaymentMethod;
import com.adyen.model.checkout.ThreeDS2ResponseData;
import com.adyen.model.checkout.ThreeDS2Result;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"action", "additionalData", "amount", "donationToken", "fraudResult", "merchantReference", "order", "paymentMethod", "paymentValidations", "pspReference", "refusalReason", "refusalReasonCode", "resultCode", "threeDS2ResponseData", "threeDS2Result", "threeDSPaymentData"})
public class PaymentResponse {
    public static final String JSON_PROPERTY_ACTION = "action";
    private PaymentResponseAction action;
    private boolean isSetAction = false;
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData;
    private boolean isSetAdditionalData = false;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    private boolean isSetAmount = false;
    public static final String JSON_PROPERTY_DONATION_TOKEN = "donationToken";
    private String donationToken;
    private boolean isSetDonationToken = false;
    public static final String JSON_PROPERTY_FRAUD_RESULT = "fraudResult";
    private FraudResult fraudResult;
    private boolean isSetFraudResult = false;
    public static final String JSON_PROPERTY_MERCHANT_REFERENCE = "merchantReference";
    private String merchantReference;
    private boolean isSetMerchantReference = false;
    public static final String JSON_PROPERTY_ORDER = "order";
    private CheckoutOrderResponse order;
    private boolean isSetOrder = false;
    public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
    private ResponsePaymentMethod paymentMethod;
    private boolean isSetPaymentMethod = false;
    public static final String JSON_PROPERTY_PAYMENT_VALIDATIONS = "paymentValidations";
    private PaymentValidationsResponse paymentValidations;
    private boolean isSetPaymentValidations = false;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    private boolean isSetPspReference = false;
    public static final String JSON_PROPERTY_REFUSAL_REASON = "refusalReason";
    private String refusalReason;
    private boolean isSetRefusalReason = false;
    public static final String JSON_PROPERTY_REFUSAL_REASON_CODE = "refusalReasonCode";
    private String refusalReasonCode;
    private boolean isSetRefusalReasonCode = false;
    public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
    private ResultCodeEnum resultCode;
    private boolean isSetResultCode = false;
    public static final String JSON_PROPERTY_THREE_D_S2_RESPONSE_DATA = "threeDS2ResponseData";
    private ThreeDS2ResponseData threeDS2ResponseData;
    private boolean isSetThreeDS2ResponseData = false;
    public static final String JSON_PROPERTY_THREE_D_S2_RESULT = "threeDS2Result";
    private ThreeDS2Result threeDS2Result;
    private boolean isSetThreeDS2Result = false;
    public static final String JSON_PROPERTY_THREE_D_S_PAYMENT_DATA = "threeDSPaymentData";
    private String threeDSPaymentData;
    private boolean isSetThreeDSPaymentData = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public PaymentResponse action(PaymentResponseAction action) {
        this.action = action;
        this.isSetAction = true;
        return this;
    }

    @JsonProperty(value="action")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentResponseAction getAction() {
        return this.action;
    }

    @JsonProperty(value="action")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAction(PaymentResponseAction action) {
        this.action = action;
        this.isSetAction = true;
    }

    public PaymentResponse additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        this.isSetAdditionalData = true;
        return this;
    }

    public PaymentResponse putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        this.isSetAdditionalData = true;
    }

    public PaymentResponse amount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
    }

    public PaymentResponse donationToken(String donationToken) {
        this.donationToken = donationToken;
        this.isSetDonationToken = true;
        return this;
    }

    @JsonProperty(value="donationToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDonationToken() {
        return this.donationToken;
    }

    @JsonProperty(value="donationToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDonationToken(String donationToken) {
        this.donationToken = donationToken;
        this.isSetDonationToken = true;
    }

    public PaymentResponse fraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
        this.isSetFraudResult = true;
        return this;
    }

    @JsonProperty(value="fraudResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FraudResult getFraudResult() {
        return this.fraudResult;
    }

    @JsonProperty(value="fraudResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
        this.isSetFraudResult = true;
    }

    public PaymentResponse merchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
        this.isSetMerchantReference = true;
        return this;
    }

    @JsonProperty(value="merchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantReference() {
        return this.merchantReference;
    }

    @JsonProperty(value="merchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
        this.isSetMerchantReference = true;
    }

    public PaymentResponse order(CheckoutOrderResponse order) {
        this.order = order;
        this.isSetOrder = true;
        return this;
    }

    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CheckoutOrderResponse getOrder() {
        return this.order;
    }

    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrder(CheckoutOrderResponse order) {
        this.order = order;
        this.isSetOrder = true;
    }

    public PaymentResponse paymentMethod(ResponsePaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
        this.isSetPaymentMethod = true;
        return this;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResponsePaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethod(ResponsePaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
        this.isSetPaymentMethod = true;
    }

    public PaymentResponse paymentValidations(PaymentValidationsResponse paymentValidations) {
        this.paymentValidations = paymentValidations;
        this.isSetPaymentValidations = true;
        return this;
    }

    @JsonProperty(value="paymentValidations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentValidationsResponse getPaymentValidations() {
        return this.paymentValidations;
    }

    @JsonProperty(value="paymentValidations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentValidations(PaymentValidationsResponse paymentValidations) {
        this.paymentValidations = paymentValidations;
        this.isSetPaymentValidations = true;
    }

    public PaymentResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        this.isSetPspReference = true;
        return this;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
        this.isSetPspReference = true;
    }

    public PaymentResponse refusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        this.isSetRefusalReason = true;
        return this;
    }

    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefusalReason() {
        return this.refusalReason;
    }

    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        this.isSetRefusalReason = true;
    }

    public PaymentResponse refusalReasonCode(String refusalReasonCode) {
        this.refusalReasonCode = refusalReasonCode;
        this.isSetRefusalReasonCode = true;
        return this;
    }

    @JsonProperty(value="refusalReasonCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefusalReasonCode() {
        return this.refusalReasonCode;
    }

    @JsonProperty(value="refusalReasonCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefusalReasonCode(String refusalReasonCode) {
        this.refusalReasonCode = refusalReasonCode;
        this.isSetRefusalReasonCode = true;
    }

    public PaymentResponse resultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        this.isSetResultCode = true;
        return this;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        this.isSetResultCode = true;
    }

    public PaymentResponse threeDS2ResponseData(ThreeDS2ResponseData threeDS2ResponseData) {
        this.threeDS2ResponseData = threeDS2ResponseData;
        this.isSetThreeDS2ResponseData = true;
        return this;
    }

    @JsonProperty(value="threeDS2ResponseData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThreeDS2ResponseData getThreeDS2ResponseData() {
        return this.threeDS2ResponseData;
    }

    @JsonProperty(value="threeDS2ResponseData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDS2ResponseData(ThreeDS2ResponseData threeDS2ResponseData) {
        this.threeDS2ResponseData = threeDS2ResponseData;
        this.isSetThreeDS2ResponseData = true;
    }

    public PaymentResponse threeDS2Result(ThreeDS2Result threeDS2Result) {
        this.threeDS2Result = threeDS2Result;
        this.isSetThreeDS2Result = true;
        return this;
    }

    @JsonProperty(value="threeDS2Result")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThreeDS2Result getThreeDS2Result() {
        return this.threeDS2Result;
    }

    @JsonProperty(value="threeDS2Result")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDS2Result(ThreeDS2Result threeDS2Result) {
        this.threeDS2Result = threeDS2Result;
        this.isSetThreeDS2Result = true;
    }

    public PaymentResponse threeDSPaymentData(String threeDSPaymentData) {
        this.threeDSPaymentData = threeDSPaymentData;
        this.isSetThreeDSPaymentData = true;
        return this;
    }

    @JsonProperty(value="threeDSPaymentData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDSPaymentData() {
        return this.threeDSPaymentData;
    }

    @JsonProperty(value="threeDSPaymentData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSPaymentData(String threeDSPaymentData) {
        this.threeDSPaymentData = threeDSPaymentData;
        this.isSetThreeDSPaymentData = true;
    }

    public PaymentResponse includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentResponse paymentResponse = (PaymentResponse)o;
        return Objects.equals(this.action, paymentResponse.action) && Objects.equals(this.isSetAction, paymentResponse.isSetAction) && Objects.equals(this.additionalData, paymentResponse.additionalData) && Objects.equals(this.isSetAdditionalData, paymentResponse.isSetAdditionalData) && Objects.equals(this.amount, paymentResponse.amount) && Objects.equals(this.isSetAmount, paymentResponse.isSetAmount) && Objects.equals(this.donationToken, paymentResponse.donationToken) && Objects.equals(this.isSetDonationToken, paymentResponse.isSetDonationToken) && Objects.equals(this.fraudResult, paymentResponse.fraudResult) && Objects.equals(this.isSetFraudResult, paymentResponse.isSetFraudResult) && Objects.equals(this.merchantReference, paymentResponse.merchantReference) && Objects.equals(this.isSetMerchantReference, paymentResponse.isSetMerchantReference) && Objects.equals(this.order, paymentResponse.order) && Objects.equals(this.isSetOrder, paymentResponse.isSetOrder) && Objects.equals(this.paymentMethod, paymentResponse.paymentMethod) && Objects.equals(this.isSetPaymentMethod, paymentResponse.isSetPaymentMethod) && Objects.equals(this.paymentValidations, paymentResponse.paymentValidations) && Objects.equals(this.isSetPaymentValidations, paymentResponse.isSetPaymentValidations) && Objects.equals(this.pspReference, paymentResponse.pspReference) && Objects.equals(this.isSetPspReference, paymentResponse.isSetPspReference) && Objects.equals(this.refusalReason, paymentResponse.refusalReason) && Objects.equals(this.isSetRefusalReason, paymentResponse.isSetRefusalReason) && Objects.equals(this.refusalReasonCode, paymentResponse.refusalReasonCode) && Objects.equals(this.isSetRefusalReasonCode, paymentResponse.isSetRefusalReasonCode) && Objects.equals((Object)this.resultCode, (Object)paymentResponse.resultCode) && Objects.equals(this.isSetResultCode, paymentResponse.isSetResultCode) && Objects.equals(this.threeDS2ResponseData, paymentResponse.threeDS2ResponseData) && Objects.equals(this.isSetThreeDS2ResponseData, paymentResponse.isSetThreeDS2ResponseData) && Objects.equals(this.threeDS2Result, paymentResponse.threeDS2Result) && Objects.equals(this.isSetThreeDS2Result, paymentResponse.isSetThreeDS2Result) && Objects.equals(this.threeDSPaymentData, paymentResponse.threeDSPaymentData) && Objects.equals(this.isSetThreeDSPaymentData, paymentResponse.isSetThreeDSPaymentData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.isSetAction, this.additionalData, this.isSetAdditionalData, this.amount, this.isSetAmount, this.donationToken, this.isSetDonationToken, this.fraudResult, this.isSetFraudResult, this.merchantReference, this.isSetMerchantReference, this.order, this.isSetOrder, this.paymentMethod, this.isSetPaymentMethod, this.paymentValidations, this.isSetPaymentValidations, this.pspReference, this.isSetPspReference, this.refusalReason, this.isSetRefusalReason, this.refusalReasonCode, this.isSetRefusalReasonCode, this.resultCode, this.isSetResultCode, this.threeDS2ResponseData, this.isSetThreeDS2ResponseData, this.threeDS2Result, this.isSetThreeDS2Result, this.threeDSPaymentData, this.isSetThreeDSPaymentData});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentResponse {\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    donationToken: ").append(this.toIndentedString(this.donationToken)).append("\n");
        sb.append("    fraudResult: ").append(this.toIndentedString(this.fraudResult)).append("\n");
        sb.append("    merchantReference: ").append(this.toIndentedString(this.merchantReference)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    paymentValidations: ").append(this.toIndentedString(this.paymentValidations)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    refusalReason: ").append(this.toIndentedString(this.refusalReason)).append("\n");
        sb.append("    refusalReasonCode: ").append(this.toIndentedString(this.refusalReasonCode)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString((Object)this.resultCode)).append("\n");
        sb.append("    threeDS2ResponseData: ").append(this.toIndentedString(this.threeDS2ResponseData)).append("\n");
        sb.append("    threeDS2Result: ").append(this.toIndentedString(this.threeDS2Result)).append("\n");
        sb.append("    threeDSPaymentData: ").append(this.toIndentedString(this.threeDSPaymentData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAction) {
            this.addIfNull(nulls, JSON_PROPERTY_ACTION, this.action);
        }
        if (this.isSetAdditionalData) {
            this.addIfNull(nulls, JSON_PROPERTY_ADDITIONAL_DATA, this.additionalData);
        }
        if (this.isSetAmount) {
            this.addIfNull(nulls, JSON_PROPERTY_AMOUNT, this.amount);
        }
        if (this.isSetDonationToken) {
            this.addIfNull(nulls, JSON_PROPERTY_DONATION_TOKEN, this.donationToken);
        }
        if (this.isSetFraudResult) {
            this.addIfNull(nulls, JSON_PROPERTY_FRAUD_RESULT, this.fraudResult);
        }
        if (this.isSetMerchantReference) {
            this.addIfNull(nulls, JSON_PROPERTY_MERCHANT_REFERENCE, this.merchantReference);
        }
        if (this.isSetOrder) {
            this.addIfNull(nulls, JSON_PROPERTY_ORDER, this.order);
        }
        if (this.isSetPaymentMethod) {
            this.addIfNull(nulls, JSON_PROPERTY_PAYMENT_METHOD, this.paymentMethod);
        }
        if (this.isSetPaymentValidations) {
            this.addIfNull(nulls, JSON_PROPERTY_PAYMENT_VALIDATIONS, this.paymentValidations);
        }
        if (this.isSetPspReference) {
            this.addIfNull(nulls, JSON_PROPERTY_PSP_REFERENCE, this.pspReference);
        }
        if (this.isSetRefusalReason) {
            this.addIfNull(nulls, JSON_PROPERTY_REFUSAL_REASON, this.refusalReason);
        }
        if (this.isSetRefusalReasonCode) {
            this.addIfNull(nulls, JSON_PROPERTY_REFUSAL_REASON_CODE, this.refusalReasonCode);
        }
        if (this.isSetResultCode) {
            this.addIfNull(nulls, JSON_PROPERTY_RESULT_CODE, (Object)this.resultCode);
        }
        if (this.isSetThreeDS2ResponseData) {
            this.addIfNull(nulls, JSON_PROPERTY_THREE_D_S2_RESPONSE_DATA, this.threeDS2ResponseData);
        }
        if (this.isSetThreeDS2Result) {
            this.addIfNull(nulls, JSON_PROPERTY_THREE_D_S2_RESULT, this.threeDS2Result);
        }
        if (this.isSetThreeDSPaymentData) {
            this.addIfNull(nulls, JSON_PROPERTY_THREE_D_S_PAYMENT_DATA, this.threeDSPaymentData);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static PaymentResponse fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentResponse)JSON.getMapper().readValue(jsonString, PaymentResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ResultCodeEnum {
        AUTHENTICATIONFINISHED(String.valueOf("AuthenticationFinished")),
        AUTHENTICATIONNOTREQUIRED(String.valueOf("AuthenticationNotRequired")),
        AUTHORISED(String.valueOf("Authorised")),
        CANCELLED(String.valueOf("Cancelled")),
        CHALLENGESHOPPER(String.valueOf("ChallengeShopper")),
        ERROR(String.valueOf("Error")),
        IDENTIFYSHOPPER(String.valueOf("IdentifyShopper")),
        PARTIALLYAUTHORISED(String.valueOf("PartiallyAuthorised")),
        PENDING(String.valueOf("Pending")),
        PRESENTTOSHOPPER(String.valueOf("PresentToShopper")),
        RECEIVED(String.valueOf("Received")),
        REDIRECTSHOPPER(String.valueOf("RedirectShopper")),
        REFUSED(String.valueOf("Refused")),
        SUCCESS(String.valueOf("Success"));

        private static final Logger LOG;
        private String value;

        private ResultCodeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResultCodeEnum fromValue(String value) {
            for (ResultCodeEnum b : ResultCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("ResultCodeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])ResultCodeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(ResultCodeEnum.class.getName());
        }
    }
}

