/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.FraudResult;
import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"additionalData", "amount", "expiresAt", "fraudResult", "orderData", "pspReference", "reference", "refusalReason", "remainingAmount", "resultCode"})
public class CreateOrderResponse {
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData;
    private boolean isSetAdditionalData = false;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    private boolean isSetAmount = false;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private String expiresAt;
    private boolean isSetExpiresAt = false;
    public static final String JSON_PROPERTY_FRAUD_RESULT = "fraudResult";
    private FraudResult fraudResult;
    private boolean isSetFraudResult = false;
    public static final String JSON_PROPERTY_ORDER_DATA = "orderData";
    private String orderData;
    private boolean isSetOrderData = false;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    private boolean isSetPspReference = false;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    private boolean isSetReference = false;
    public static final String JSON_PROPERTY_REFUSAL_REASON = "refusalReason";
    private String refusalReason;
    private boolean isSetRefusalReason = false;
    public static final String JSON_PROPERTY_REMAINING_AMOUNT = "remainingAmount";
    private Amount remainingAmount;
    private boolean isSetRemainingAmount = false;
    public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
    private ResultCodeEnum resultCode;
    private boolean isSetResultCode = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public CreateOrderResponse additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        this.isSetAdditionalData = true;
        return this;
    }

    public CreateOrderResponse putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        this.isSetAdditionalData = true;
    }

    public CreateOrderResponse amount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
    }

    public CreateOrderResponse expiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
        this.isSetExpiresAt = true;
        return this;
    }

    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
        this.isSetExpiresAt = true;
    }

    public CreateOrderResponse fraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
        this.isSetFraudResult = true;
        return this;
    }

    @JsonProperty(value="fraudResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FraudResult getFraudResult() {
        return this.fraudResult;
    }

    @JsonProperty(value="fraudResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
        this.isSetFraudResult = true;
    }

    public CreateOrderResponse orderData(String orderData) {
        this.orderData = orderData;
        this.isSetOrderData = true;
        return this;
    }

    @JsonProperty(value="orderData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrderData() {
        return this.orderData;
    }

    @JsonProperty(value="orderData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrderData(String orderData) {
        this.orderData = orderData;
        this.isSetOrderData = true;
    }

    public CreateOrderResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        this.isSetPspReference = true;
        return this;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
        this.isSetPspReference = true;
    }

    public CreateOrderResponse reference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
    }

    public CreateOrderResponse refusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        this.isSetRefusalReason = true;
        return this;
    }

    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefusalReason() {
        return this.refusalReason;
    }

    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        this.isSetRefusalReason = true;
    }

    public CreateOrderResponse remainingAmount(Amount remainingAmount) {
        this.remainingAmount = remainingAmount;
        this.isSetRemainingAmount = true;
        return this;
    }

    @JsonProperty(value="remainingAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getRemainingAmount() {
        return this.remainingAmount;
    }

    @JsonProperty(value="remainingAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRemainingAmount(Amount remainingAmount) {
        this.remainingAmount = remainingAmount;
        this.isSetRemainingAmount = true;
    }

    public CreateOrderResponse resultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        this.isSetResultCode = true;
        return this;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        this.isSetResultCode = true;
    }

    public CreateOrderResponse includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateOrderResponse createOrderResponse = (CreateOrderResponse)o;
        return Objects.equals(this.additionalData, createOrderResponse.additionalData) && Objects.equals(this.isSetAdditionalData, createOrderResponse.isSetAdditionalData) && Objects.equals(this.amount, createOrderResponse.amount) && Objects.equals(this.isSetAmount, createOrderResponse.isSetAmount) && Objects.equals(this.expiresAt, createOrderResponse.expiresAt) && Objects.equals(this.isSetExpiresAt, createOrderResponse.isSetExpiresAt) && Objects.equals(this.fraudResult, createOrderResponse.fraudResult) && Objects.equals(this.isSetFraudResult, createOrderResponse.isSetFraudResult) && Objects.equals(this.orderData, createOrderResponse.orderData) && Objects.equals(this.isSetOrderData, createOrderResponse.isSetOrderData) && Objects.equals(this.pspReference, createOrderResponse.pspReference) && Objects.equals(this.isSetPspReference, createOrderResponse.isSetPspReference) && Objects.equals(this.reference, createOrderResponse.reference) && Objects.equals(this.isSetReference, createOrderResponse.isSetReference) && Objects.equals(this.refusalReason, createOrderResponse.refusalReason) && Objects.equals(this.isSetRefusalReason, createOrderResponse.isSetRefusalReason) && Objects.equals(this.remainingAmount, createOrderResponse.remainingAmount) && Objects.equals(this.isSetRemainingAmount, createOrderResponse.isSetRemainingAmount) && Objects.equals((Object)this.resultCode, (Object)createOrderResponse.resultCode) && Objects.equals(this.isSetResultCode, createOrderResponse.isSetResultCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalData, this.isSetAdditionalData, this.amount, this.isSetAmount, this.expiresAt, this.isSetExpiresAt, this.fraudResult, this.isSetFraudResult, this.orderData, this.isSetOrderData, this.pspReference, this.isSetPspReference, this.reference, this.isSetReference, this.refusalReason, this.isSetRefusalReason, this.remainingAmount, this.isSetRemainingAmount, this.resultCode, this.isSetResultCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateOrderResponse {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    fraudResult: ").append(this.toIndentedString(this.fraudResult)).append("\n");
        sb.append("    orderData: ").append(this.toIndentedString(this.orderData)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    refusalReason: ").append(this.toIndentedString(this.refusalReason)).append("\n");
        sb.append("    remainingAmount: ").append(this.toIndentedString(this.remainingAmount)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString((Object)this.resultCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAdditionalData) {
            this.addIfNull(nulls, JSON_PROPERTY_ADDITIONAL_DATA, this.additionalData);
        }
        if (this.isSetAmount) {
            this.addIfNull(nulls, JSON_PROPERTY_AMOUNT, this.amount);
        }
        if (this.isSetExpiresAt) {
            this.addIfNull(nulls, JSON_PROPERTY_EXPIRES_AT, this.expiresAt);
        }
        if (this.isSetFraudResult) {
            this.addIfNull(nulls, JSON_PROPERTY_FRAUD_RESULT, this.fraudResult);
        }
        if (this.isSetOrderData) {
            this.addIfNull(nulls, JSON_PROPERTY_ORDER_DATA, this.orderData);
        }
        if (this.isSetPspReference) {
            this.addIfNull(nulls, JSON_PROPERTY_PSP_REFERENCE, this.pspReference);
        }
        if (this.isSetReference) {
            this.addIfNull(nulls, JSON_PROPERTY_REFERENCE, this.reference);
        }
        if (this.isSetRefusalReason) {
            this.addIfNull(nulls, JSON_PROPERTY_REFUSAL_REASON, this.refusalReason);
        }
        if (this.isSetRemainingAmount) {
            this.addIfNull(nulls, JSON_PROPERTY_REMAINING_AMOUNT, this.remainingAmount);
        }
        if (this.isSetResultCode) {
            this.addIfNull(nulls, JSON_PROPERTY_RESULT_CODE, (Object)this.resultCode);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static CreateOrderResponse fromJson(String jsonString) throws JsonProcessingException {
        return (CreateOrderResponse)JSON.getMapper().readValue(jsonString, CreateOrderResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ResultCodeEnum {
        SUCCESS(String.valueOf("Success"));

        private static final Logger LOG;
        private String value;

        private ResultCodeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResultCodeEnum fromValue(String value) {
            for (ResultCodeEnum b : ResultCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("ResultCodeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])ResultCodeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(ResultCodeEnum.class.getName());
        }
    }
}

