/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.binlookup;

import com.adyen.model.binlookup.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"countryCode", "enrolledIn3DSecure", "mcc"})
public class MerchantDetails {
    public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
    private String countryCode;
    private boolean isSetCountryCode = false;
    public static final String JSON_PROPERTY_ENROLLED_IN3_D_SECURE = "enrolledIn3DSecure";
    private Boolean enrolledIn3DSecure;
    private boolean isSetEnrolledIn3DSecure = false;
    public static final String JSON_PROPERTY_MCC = "mcc";
    private String mcc;
    private boolean isSetMcc = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public MerchantDetails countryCode(String countryCode) {
        this.countryCode = countryCode;
        this.isSetCountryCode = true;
        return this;
    }

    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
        this.isSetCountryCode = true;
    }

    public MerchantDetails enrolledIn3DSecure(Boolean enrolledIn3DSecure) {
        this.enrolledIn3DSecure = enrolledIn3DSecure;
        this.isSetEnrolledIn3DSecure = true;
        return this;
    }

    @JsonProperty(value="enrolledIn3DSecure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnrolledIn3DSecure() {
        return this.enrolledIn3DSecure;
    }

    @JsonProperty(value="enrolledIn3DSecure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnrolledIn3DSecure(Boolean enrolledIn3DSecure) {
        this.enrolledIn3DSecure = enrolledIn3DSecure;
        this.isSetEnrolledIn3DSecure = true;
    }

    public MerchantDetails mcc(String mcc) {
        this.mcc = mcc;
        this.isSetMcc = true;
        return this;
    }

    @JsonProperty(value="mcc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMcc() {
        return this.mcc;
    }

    @JsonProperty(value="mcc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMcc(String mcc) {
        this.mcc = mcc;
        this.isSetMcc = true;
    }

    public MerchantDetails includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MerchantDetails merchantDetails = (MerchantDetails)o;
        return Objects.equals(this.countryCode, merchantDetails.countryCode) && Objects.equals(this.isSetCountryCode, merchantDetails.isSetCountryCode) && Objects.equals(this.enrolledIn3DSecure, merchantDetails.enrolledIn3DSecure) && Objects.equals(this.isSetEnrolledIn3DSecure, merchantDetails.isSetEnrolledIn3DSecure) && Objects.equals(this.mcc, merchantDetails.mcc) && Objects.equals(this.isSetMcc, merchantDetails.isSetMcc);
    }

    public int hashCode() {
        return Objects.hash(this.countryCode, this.isSetCountryCode, this.enrolledIn3DSecure, this.isSetEnrolledIn3DSecure, this.mcc, this.isSetMcc);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MerchantDetails {\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    enrolledIn3DSecure: ").append(this.toIndentedString(this.enrolledIn3DSecure)).append("\n");
        sb.append("    mcc: ").append(this.toIndentedString(this.mcc)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetCountryCode) {
            this.addIfNull(nulls, JSON_PROPERTY_COUNTRY_CODE, this.countryCode);
        }
        if (this.isSetEnrolledIn3DSecure) {
            this.addIfNull(nulls, JSON_PROPERTY_ENROLLED_IN3_D_SECURE, this.enrolledIn3DSecure);
        }
        if (this.isSetMcc) {
            this.addIfNull(nulls, JSON_PROPERTY_MCC, this.mcc);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static MerchantDetails fromJson(String jsonString) throws JsonProcessingException {
        return (MerchantDetails)JSON.getMapper().readValue(jsonString, MerchantDetails.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

