/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"balanceType", "conditionType", "value"})
public class Condition {
    public static final String JSON_PROPERTY_BALANCE_TYPE = "balanceType";
    private BalanceTypeEnum balanceType;
    private boolean isSetBalanceType = false;
    public static final String JSON_PROPERTY_CONDITION_TYPE = "conditionType";
    private ConditionTypeEnum conditionType;
    private boolean isSetConditionType = false;
    public static final String JSON_PROPERTY_VALUE = "value";
    private Long value;
    private boolean isSetValue = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public Condition balanceType(BalanceTypeEnum balanceType) {
        this.balanceType = balanceType;
        this.isSetBalanceType = true;
        return this;
    }

    @JsonProperty(value="balanceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BalanceTypeEnum getBalanceType() {
        return this.balanceType;
    }

    @JsonProperty(value="balanceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalanceType(BalanceTypeEnum balanceType) {
        this.balanceType = balanceType;
        this.isSetBalanceType = true;
    }

    public Condition conditionType(ConditionTypeEnum conditionType) {
        this.conditionType = conditionType;
        this.isSetConditionType = true;
        return this;
    }

    @JsonProperty(value="conditionType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConditionTypeEnum getConditionType() {
        return this.conditionType;
    }

    @JsonProperty(value="conditionType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConditionType(ConditionTypeEnum conditionType) {
        this.conditionType = conditionType;
        this.isSetConditionType = true;
    }

    public Condition value(Long value) {
        this.value = value;
        this.isSetValue = true;
        return this;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(Long value) {
        this.value = value;
        this.isSetValue = true;
    }

    public Condition includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Condition condition = (Condition)o;
        return Objects.equals((Object)this.balanceType, (Object)condition.balanceType) && Objects.equals(this.isSetBalanceType, condition.isSetBalanceType) && Objects.equals((Object)this.conditionType, (Object)condition.conditionType) && Objects.equals(this.isSetConditionType, condition.isSetConditionType) && Objects.equals(this.value, condition.value) && Objects.equals(this.isSetValue, condition.isSetValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.balanceType, this.isSetBalanceType, this.conditionType, this.isSetConditionType, this.value, this.isSetValue});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Condition {\n");
        sb.append("    balanceType: ").append(this.toIndentedString((Object)this.balanceType)).append("\n");
        sb.append("    conditionType: ").append(this.toIndentedString((Object)this.conditionType)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetBalanceType) {
            this.addIfNull(nulls, JSON_PROPERTY_BALANCE_TYPE, (Object)this.balanceType);
        }
        if (this.isSetConditionType) {
            this.addIfNull(nulls, JSON_PROPERTY_CONDITION_TYPE, (Object)this.conditionType);
        }
        if (this.isSetValue) {
            this.addIfNull(nulls, JSON_PROPERTY_VALUE, this.value);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static Condition fromJson(String jsonString) throws JsonProcessingException {
        return (Condition)JSON.getMapper().readValue(jsonString, Condition.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ConditionTypeEnum {
        GREATERTHAN(String.valueOf("greaterThan")),
        GREATERTHANOREQUAL(String.valueOf("greaterThanOrEqual")),
        LESSTHAN(String.valueOf("lessThan")),
        LESSTHANOREQUAL(String.valueOf("lessThanOrEqual"));

        private static final Logger LOG;
        private String value;

        private ConditionTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ConditionTypeEnum fromValue(String value) {
            for (ConditionTypeEnum b : ConditionTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("ConditionTypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])ConditionTypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(ConditionTypeEnum.class.getName());
        }
    }

    public static enum BalanceTypeEnum {
        BALANCE(String.valueOf("balance")),
        AVAILABLE(String.valueOf("available")),
        PENDING(String.valueOf("pending")),
        RESERVED(String.valueOf("reserved"));

        private static final Logger LOG;
        private String value;

        private BalanceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BalanceTypeEnum fromValue(String value) {
            for (BalanceTypeEnum b : BalanceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("BalanceTypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])BalanceTypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(BalanceTypeEnum.class.getName());
        }
    }
}

