/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balancecontrol;

import com.adyen.model.balancecontrol.Amount;
import com.adyen.model.balancecontrol.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"amount", "createdAt", "description", "fromMerchant", "pspReference", "reference", "status", "toMerchant", "type"})
public class BalanceTransferResponse {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    private boolean isSetAmount = false;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    private boolean isSetCreatedAt = false;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    private boolean isSetDescription = false;
    public static final String JSON_PROPERTY_FROM_MERCHANT = "fromMerchant";
    private String fromMerchant;
    private boolean isSetFromMerchant = false;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    private boolean isSetPspReference = false;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    private boolean isSetReference = false;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    private boolean isSetStatus = false;
    public static final String JSON_PROPERTY_TO_MERCHANT = "toMerchant";
    private String toMerchant;
    private boolean isSetToMerchant = false;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    private boolean isSetType = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public BalanceTransferResponse amount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
    }

    public BalanceTransferResponse createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        this.isSetCreatedAt = true;
        return this;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        this.isSetCreatedAt = true;
    }

    public BalanceTransferResponse description(String description) {
        this.description = description;
        this.isSetDescription = true;
        return this;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
        this.isSetDescription = true;
    }

    public BalanceTransferResponse fromMerchant(String fromMerchant) {
        this.fromMerchant = fromMerchant;
        this.isSetFromMerchant = true;
        return this;
    }

    @JsonProperty(value="fromMerchant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFromMerchant() {
        return this.fromMerchant;
    }

    @JsonProperty(value="fromMerchant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFromMerchant(String fromMerchant) {
        this.fromMerchant = fromMerchant;
        this.isSetFromMerchant = true;
    }

    public BalanceTransferResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        this.isSetPspReference = true;
        return this;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
        this.isSetPspReference = true;
    }

    public BalanceTransferResponse reference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
    }

    public BalanceTransferResponse status(StatusEnum status) {
        this.status = status;
        this.isSetStatus = true;
        return this;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
        this.isSetStatus = true;
    }

    public BalanceTransferResponse toMerchant(String toMerchant) {
        this.toMerchant = toMerchant;
        this.isSetToMerchant = true;
        return this;
    }

    @JsonProperty(value="toMerchant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getToMerchant() {
        return this.toMerchant;
    }

    @JsonProperty(value="toMerchant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setToMerchant(String toMerchant) {
        this.toMerchant = toMerchant;
        this.isSetToMerchant = true;
    }

    public BalanceTransferResponse type(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
    }

    public BalanceTransferResponse includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalanceTransferResponse balanceTransferResponse = (BalanceTransferResponse)o;
        return Objects.equals(this.amount, balanceTransferResponse.amount) && Objects.equals(this.isSetAmount, balanceTransferResponse.isSetAmount) && Objects.equals(this.createdAt, balanceTransferResponse.createdAt) && Objects.equals(this.isSetCreatedAt, balanceTransferResponse.isSetCreatedAt) && Objects.equals(this.description, balanceTransferResponse.description) && Objects.equals(this.isSetDescription, balanceTransferResponse.isSetDescription) && Objects.equals(this.fromMerchant, balanceTransferResponse.fromMerchant) && Objects.equals(this.isSetFromMerchant, balanceTransferResponse.isSetFromMerchant) && Objects.equals(this.pspReference, balanceTransferResponse.pspReference) && Objects.equals(this.isSetPspReference, balanceTransferResponse.isSetPspReference) && Objects.equals(this.reference, balanceTransferResponse.reference) && Objects.equals(this.isSetReference, balanceTransferResponse.isSetReference) && Objects.equals((Object)this.status, (Object)balanceTransferResponse.status) && Objects.equals(this.isSetStatus, balanceTransferResponse.isSetStatus) && Objects.equals(this.toMerchant, balanceTransferResponse.toMerchant) && Objects.equals(this.isSetToMerchant, balanceTransferResponse.isSetToMerchant) && Objects.equals((Object)this.type, (Object)balanceTransferResponse.type) && Objects.equals(this.isSetType, balanceTransferResponse.isSetType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.isSetAmount, this.createdAt, this.isSetCreatedAt, this.description, this.isSetDescription, this.fromMerchant, this.isSetFromMerchant, this.pspReference, this.isSetPspReference, this.reference, this.isSetReference, this.status, this.isSetStatus, this.toMerchant, this.isSetToMerchant, this.type, this.isSetType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BalanceTransferResponse {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    fromMerchant: ").append(this.toIndentedString(this.fromMerchant)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    toMerchant: ").append(this.toIndentedString(this.toMerchant)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAmount) {
            this.addIfNull(nulls, JSON_PROPERTY_AMOUNT, this.amount);
        }
        if (this.isSetCreatedAt) {
            this.addIfNull(nulls, JSON_PROPERTY_CREATED_AT, this.createdAt);
        }
        if (this.isSetDescription) {
            this.addIfNull(nulls, JSON_PROPERTY_DESCRIPTION, this.description);
        }
        if (this.isSetFromMerchant) {
            this.addIfNull(nulls, JSON_PROPERTY_FROM_MERCHANT, this.fromMerchant);
        }
        if (this.isSetPspReference) {
            this.addIfNull(nulls, JSON_PROPERTY_PSP_REFERENCE, this.pspReference);
        }
        if (this.isSetReference) {
            this.addIfNull(nulls, JSON_PROPERTY_REFERENCE, this.reference);
        }
        if (this.isSetStatus) {
            this.addIfNull(nulls, JSON_PROPERTY_STATUS, (Object)this.status);
        }
        if (this.isSetToMerchant) {
            this.addIfNull(nulls, JSON_PROPERTY_TO_MERCHANT, this.toMerchant);
        }
        if (this.isSetType) {
            this.addIfNull(nulls, JSON_PROPERTY_TYPE, (Object)this.type);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static BalanceTransferResponse fromJson(String jsonString) throws JsonProcessingException {
        return (BalanceTransferResponse)JSON.getMapper().readValue(jsonString, BalanceTransferResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        TAX(String.valueOf("tax")),
        FEE(String.valueOf("fee")),
        TERMINALSALE(String.valueOf("terminalSale")),
        CREDIT(String.valueOf("credit")),
        DEBIT(String.valueOf("debit")),
        ADJUSTMENT(String.valueOf("adjustment"));

        private static final Logger LOG;
        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("TypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])TypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(TypeEnum.class.getName());
        }
    }

    public static enum StatusEnum {
        ERROR(String.valueOf("error")),
        FAILED(String.valueOf("failed")),
        NOTENOUGHBALANCE(String.valueOf("notEnoughBalance")),
        TRANSFERRED(String.valueOf("transferred"));

        private static final Logger LOG;
        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("StatusEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])StatusEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(StatusEnum.class.getName());
        }
    }
}

