/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.CapabilitySettings;
import com.adyen.model.legalentitymanagement.JSON;
import com.adyen.model.legalentitymanagement.SupportingEntityCapability;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"allowed", "allowedLevel", "allowedSettings", "requested", "requestedLevel", "requestedSettings", "transferInstruments", "verificationStatus"})
public class LegalEntityCapability {
    public static final String JSON_PROPERTY_ALLOWED = "allowed";
    private Boolean allowed;
    private boolean isSetAllowed = false;
    public static final String JSON_PROPERTY_ALLOWED_LEVEL = "allowedLevel";
    private AllowedLevelEnum allowedLevel;
    private boolean isSetAllowedLevel = false;
    public static final String JSON_PROPERTY_ALLOWED_SETTINGS = "allowedSettings";
    private CapabilitySettings allowedSettings;
    private boolean isSetAllowedSettings = false;
    public static final String JSON_PROPERTY_REQUESTED = "requested";
    private Boolean requested;
    private boolean isSetRequested = false;
    public static final String JSON_PROPERTY_REQUESTED_LEVEL = "requestedLevel";
    private RequestedLevelEnum requestedLevel;
    private boolean isSetRequestedLevel = false;
    public static final String JSON_PROPERTY_REQUESTED_SETTINGS = "requestedSettings";
    private CapabilitySettings requestedSettings;
    private boolean isSetRequestedSettings = false;
    public static final String JSON_PROPERTY_TRANSFER_INSTRUMENTS = "transferInstruments";
    private List<SupportingEntityCapability> transferInstruments;
    private boolean isSetTransferInstruments = false;
    public static final String JSON_PROPERTY_VERIFICATION_STATUS = "verificationStatus";
    private String verificationStatus;
    private boolean isSetVerificationStatus = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public LegalEntityCapability() {
    }

    @JsonCreator
    public LegalEntityCapability(@JsonProperty(value="allowed") Boolean allowed, @JsonProperty(value="allowedLevel") AllowedLevelEnum allowedLevel, @JsonProperty(value="requested") Boolean requested, @JsonProperty(value="requestedLevel") RequestedLevelEnum requestedLevel, @JsonProperty(value="transferInstruments") List<SupportingEntityCapability> transferInstruments, @JsonProperty(value="verificationStatus") String verificationStatus) {
        this();
        this.allowed = allowed;
        this.allowedLevel = allowedLevel;
        this.requested = requested;
        this.requestedLevel = requestedLevel;
        this.transferInstruments = transferInstruments;
        this.verificationStatus = verificationStatus;
    }

    @JsonProperty(value="allowed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowed() {
        return this.allowed;
    }

    @JsonProperty(value="allowedLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AllowedLevelEnum getAllowedLevel() {
        return this.allowedLevel;
    }

    public LegalEntityCapability allowedSettings(CapabilitySettings allowedSettings) {
        this.allowedSettings = allowedSettings;
        this.isSetAllowedSettings = true;
        return this;
    }

    @JsonProperty(value="allowedSettings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CapabilitySettings getAllowedSettings() {
        return this.allowedSettings;
    }

    @JsonProperty(value="allowedSettings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowedSettings(CapabilitySettings allowedSettings) {
        this.allowedSettings = allowedSettings;
        this.isSetAllowedSettings = true;
    }

    @JsonProperty(value="requested")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRequested() {
        return this.requested;
    }

    @JsonProperty(value="requestedLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RequestedLevelEnum getRequestedLevel() {
        return this.requestedLevel;
    }

    public LegalEntityCapability requestedSettings(CapabilitySettings requestedSettings) {
        this.requestedSettings = requestedSettings;
        this.isSetRequestedSettings = true;
        return this;
    }

    @JsonProperty(value="requestedSettings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CapabilitySettings getRequestedSettings() {
        return this.requestedSettings;
    }

    @JsonProperty(value="requestedSettings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestedSettings(CapabilitySettings requestedSettings) {
        this.requestedSettings = requestedSettings;
        this.isSetRequestedSettings = true;
    }

    @JsonProperty(value="transferInstruments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SupportingEntityCapability> getTransferInstruments() {
        return this.transferInstruments;
    }

    @JsonProperty(value="verificationStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVerificationStatus() {
        return this.verificationStatus;
    }

    public LegalEntityCapability includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegalEntityCapability legalEntityCapability = (LegalEntityCapability)o;
        return Objects.equals(this.allowed, legalEntityCapability.allowed) && Objects.equals(this.isSetAllowed, legalEntityCapability.isSetAllowed) && Objects.equals((Object)this.allowedLevel, (Object)legalEntityCapability.allowedLevel) && Objects.equals(this.isSetAllowedLevel, legalEntityCapability.isSetAllowedLevel) && Objects.equals(this.allowedSettings, legalEntityCapability.allowedSettings) && Objects.equals(this.isSetAllowedSettings, legalEntityCapability.isSetAllowedSettings) && Objects.equals(this.requested, legalEntityCapability.requested) && Objects.equals(this.isSetRequested, legalEntityCapability.isSetRequested) && Objects.equals((Object)this.requestedLevel, (Object)legalEntityCapability.requestedLevel) && Objects.equals(this.isSetRequestedLevel, legalEntityCapability.isSetRequestedLevel) && Objects.equals(this.requestedSettings, legalEntityCapability.requestedSettings) && Objects.equals(this.isSetRequestedSettings, legalEntityCapability.isSetRequestedSettings) && Objects.equals(this.transferInstruments, legalEntityCapability.transferInstruments) && Objects.equals(this.isSetTransferInstruments, legalEntityCapability.isSetTransferInstruments) && Objects.equals(this.verificationStatus, legalEntityCapability.verificationStatus) && Objects.equals(this.isSetVerificationStatus, legalEntityCapability.isSetVerificationStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowed, this.isSetAllowed, this.allowedLevel, this.isSetAllowedLevel, this.allowedSettings, this.isSetAllowedSettings, this.requested, this.isSetRequested, this.requestedLevel, this.isSetRequestedLevel, this.requestedSettings, this.isSetRequestedSettings, this.transferInstruments, this.isSetTransferInstruments, this.verificationStatus, this.isSetVerificationStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LegalEntityCapability {\n");
        sb.append("    allowed: ").append(this.toIndentedString(this.allowed)).append("\n");
        sb.append("    allowedLevel: ").append(this.toIndentedString((Object)this.allowedLevel)).append("\n");
        sb.append("    allowedSettings: ").append(this.toIndentedString(this.allowedSettings)).append("\n");
        sb.append("    requested: ").append(this.toIndentedString(this.requested)).append("\n");
        sb.append("    requestedLevel: ").append(this.toIndentedString((Object)this.requestedLevel)).append("\n");
        sb.append("    requestedSettings: ").append(this.toIndentedString(this.requestedSettings)).append("\n");
        sb.append("    transferInstruments: ").append(this.toIndentedString(this.transferInstruments)).append("\n");
        sb.append("    verificationStatus: ").append(this.toIndentedString(this.verificationStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAllowed) {
            this.addIfNull(nulls, JSON_PROPERTY_ALLOWED, this.allowed);
        }
        if (this.isSetAllowedLevel) {
            this.addIfNull(nulls, JSON_PROPERTY_ALLOWED_LEVEL, (Object)this.allowedLevel);
        }
        if (this.isSetAllowedSettings) {
            this.addIfNull(nulls, JSON_PROPERTY_ALLOWED_SETTINGS, this.allowedSettings);
        }
        if (this.isSetRequested) {
            this.addIfNull(nulls, JSON_PROPERTY_REQUESTED, this.requested);
        }
        if (this.isSetRequestedLevel) {
            this.addIfNull(nulls, JSON_PROPERTY_REQUESTED_LEVEL, (Object)this.requestedLevel);
        }
        if (this.isSetRequestedSettings) {
            this.addIfNull(nulls, JSON_PROPERTY_REQUESTED_SETTINGS, this.requestedSettings);
        }
        if (this.isSetTransferInstruments) {
            this.addIfNull(nulls, JSON_PROPERTY_TRANSFER_INSTRUMENTS, this.transferInstruments);
        }
        if (this.isSetVerificationStatus) {
            this.addIfNull(nulls, JSON_PROPERTY_VERIFICATION_STATUS, this.verificationStatus);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static LegalEntityCapability fromJson(String jsonString) throws JsonProcessingException {
        return (LegalEntityCapability)JSON.getMapper().readValue(jsonString, LegalEntityCapability.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum RequestedLevelEnum {
        HIGH(String.valueOf("high")),
        LOW(String.valueOf("low")),
        MEDIUM(String.valueOf("medium")),
        NOTAPPLICABLE(String.valueOf("notApplicable"));

        private static final Logger LOG;
        private String value;

        private RequestedLevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RequestedLevelEnum fromValue(String value) {
            for (RequestedLevelEnum b : RequestedLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("RequestedLevelEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])RequestedLevelEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(RequestedLevelEnum.class.getName());
        }
    }

    public static enum AllowedLevelEnum {
        HIGH(String.valueOf("high")),
        LOW(String.valueOf("low")),
        MEDIUM(String.valueOf("medium")),
        NOTAPPLICABLE(String.valueOf("notApplicable"));

        private static final Logger LOG;
        private String value;

        private AllowedLevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AllowedLevelEnum fromValue(String value) {
            for (AllowedLevelEnum b : AllowedLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("AllowedLevelEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])AllowedLevelEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(AllowedLevelEnum.class.getName());
        }
    }
}

