/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.CapabilityProblem;
import com.adyen.model.legalentitymanagement.DocumentReference;
import com.adyen.model.legalentitymanagement.EntityReference;
import com.adyen.model.legalentitymanagement.Individual;
import com.adyen.model.legalentitymanagement.JSON;
import com.adyen.model.legalentitymanagement.LegalEntityAssociation;
import com.adyen.model.legalentitymanagement.LegalEntityCapability;
import com.adyen.model.legalentitymanagement.Organization;
import com.adyen.model.legalentitymanagement.SoleProprietorship;
import com.adyen.model.legalentitymanagement.TransferInstrumentReference;
import com.adyen.model.legalentitymanagement.Trust;
import com.adyen.model.legalentitymanagement.UnincorporatedPartnership;
import com.adyen.model.legalentitymanagement.VerificationDeadline;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"capabilities", "documentDetails", "documents", "entityAssociations", "id", "individual", "organization", "problems", "reference", "soleProprietorship", "transferInstruments", "trust", "type", "unincorporatedPartnership", "verificationDeadlines", "verificationPlan"})
public class LegalEntity {
    public static final String JSON_PROPERTY_CAPABILITIES = "capabilities";
    private Map<String, LegalEntityCapability> capabilities;
    private boolean isSetCapabilities = false;
    public static final String JSON_PROPERTY_DOCUMENT_DETAILS = "documentDetails";
    private List<DocumentReference> documentDetails;
    private boolean isSetDocumentDetails = false;
    public static final String JSON_PROPERTY_DOCUMENTS = "documents";
    @Deprecated
    private List<EntityReference> documents;
    private boolean isSetDocuments = false;
    public static final String JSON_PROPERTY_ENTITY_ASSOCIATIONS = "entityAssociations";
    private List<LegalEntityAssociation> entityAssociations;
    private boolean isSetEntityAssociations = false;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    private boolean isSetId = false;
    public static final String JSON_PROPERTY_INDIVIDUAL = "individual";
    private Individual individual;
    private boolean isSetIndividual = false;
    public static final String JSON_PROPERTY_ORGANIZATION = "organization";
    private Organization organization;
    private boolean isSetOrganization = false;
    public static final String JSON_PROPERTY_PROBLEMS = "problems";
    private List<CapabilityProblem> problems;
    private boolean isSetProblems = false;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    private boolean isSetReference = false;
    public static final String JSON_PROPERTY_SOLE_PROPRIETORSHIP = "soleProprietorship";
    private SoleProprietorship soleProprietorship;
    private boolean isSetSoleProprietorship = false;
    public static final String JSON_PROPERTY_TRANSFER_INSTRUMENTS = "transferInstruments";
    private List<TransferInstrumentReference> transferInstruments;
    private boolean isSetTransferInstruments = false;
    public static final String JSON_PROPERTY_TRUST = "trust";
    private Trust trust;
    private boolean isSetTrust = false;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    private boolean isSetType = false;
    public static final String JSON_PROPERTY_UNINCORPORATED_PARTNERSHIP = "unincorporatedPartnership";
    private UnincorporatedPartnership unincorporatedPartnership;
    private boolean isSetUnincorporatedPartnership = false;
    public static final String JSON_PROPERTY_VERIFICATION_DEADLINES = "verificationDeadlines";
    private List<VerificationDeadline> verificationDeadlines;
    private boolean isSetVerificationDeadlines = false;
    public static final String JSON_PROPERTY_VERIFICATION_PLAN = "verificationPlan";
    private String verificationPlan;
    private boolean isSetVerificationPlan = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public LegalEntity() {
    }

    @JsonCreator
    public LegalEntity(@JsonProperty(value="id") String id, @JsonProperty(value="transferInstruments") List<TransferInstrumentReference> transferInstruments, @JsonProperty(value="verificationDeadlines") List<VerificationDeadline> verificationDeadlines) {
        this();
        this.id = id;
        this.transferInstruments = transferInstruments;
        this.verificationDeadlines = verificationDeadlines;
    }

    public LegalEntity capabilities(Map<String, LegalEntityCapability> capabilities) {
        this.capabilities = capabilities;
        this.isSetCapabilities = true;
        return this;
    }

    public LegalEntity putCapabilitiesItem(String key, LegalEntityCapability capabilitiesItem) {
        if (this.capabilities == null) {
            this.capabilities = new HashMap<String, LegalEntityCapability>();
        }
        this.capabilities.put(key, capabilitiesItem);
        return this;
    }

    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, LegalEntityCapability> getCapabilities() {
        return this.capabilities;
    }

    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCapabilities(Map<String, LegalEntityCapability> capabilities) {
        this.capabilities = capabilities;
        this.isSetCapabilities = true;
    }

    public LegalEntity documentDetails(List<DocumentReference> documentDetails) {
        this.documentDetails = documentDetails;
        this.isSetDocumentDetails = true;
        return this;
    }

    public LegalEntity addDocumentDetailsItem(DocumentReference documentDetailsItem) {
        if (this.documentDetails == null) {
            this.documentDetails = new ArrayList<DocumentReference>();
        }
        this.documentDetails.add(documentDetailsItem);
        return this;
    }

    @JsonProperty(value="documentDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DocumentReference> getDocumentDetails() {
        return this.documentDetails;
    }

    @JsonProperty(value="documentDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocumentDetails(List<DocumentReference> documentDetails) {
        this.documentDetails = documentDetails;
        this.isSetDocumentDetails = true;
    }

    @Deprecated
    public LegalEntity documents(List<EntityReference> documents) {
        this.documents = documents;
        this.isSetDocuments = true;
        return this;
    }

    public LegalEntity addDocumentsItem(EntityReference documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList<EntityReference>();
        }
        this.documents.add(documentsItem);
        return this;
    }

    @Deprecated
    @JsonProperty(value="documents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getDocuments() {
        return this.documents;
    }

    @Deprecated
    @JsonProperty(value="documents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocuments(List<EntityReference> documents) {
        this.documents = documents;
        this.isSetDocuments = true;
    }

    public LegalEntity entityAssociations(List<LegalEntityAssociation> entityAssociations) {
        this.entityAssociations = entityAssociations;
        this.isSetEntityAssociations = true;
        return this;
    }

    public LegalEntity addEntityAssociationsItem(LegalEntityAssociation entityAssociationsItem) {
        if (this.entityAssociations == null) {
            this.entityAssociations = new ArrayList<LegalEntityAssociation>();
        }
        this.entityAssociations.add(entityAssociationsItem);
        return this;
    }

    @JsonProperty(value="entityAssociations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LegalEntityAssociation> getEntityAssociations() {
        return this.entityAssociations;
    }

    @JsonProperty(value="entityAssociations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntityAssociations(List<LegalEntityAssociation> entityAssociations) {
        this.entityAssociations = entityAssociations;
        this.isSetEntityAssociations = true;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public LegalEntity individual(Individual individual) {
        this.individual = individual;
        this.isSetIndividual = true;
        return this;
    }

    @JsonProperty(value="individual")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Individual getIndividual() {
        return this.individual;
    }

    @JsonProperty(value="individual")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIndividual(Individual individual) {
        this.individual = individual;
        this.isSetIndividual = true;
    }

    public LegalEntity organization(Organization organization) {
        this.organization = organization;
        this.isSetOrganization = true;
        return this;
    }

    @JsonProperty(value="organization")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Organization getOrganization() {
        return this.organization;
    }

    @JsonProperty(value="organization")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrganization(Organization organization) {
        this.organization = organization;
        this.isSetOrganization = true;
    }

    public LegalEntity problems(List<CapabilityProblem> problems) {
        this.problems = problems;
        this.isSetProblems = true;
        return this;
    }

    public LegalEntity addProblemsItem(CapabilityProblem problemsItem) {
        if (this.problems == null) {
            this.problems = new ArrayList<CapabilityProblem>();
        }
        this.problems.add(problemsItem);
        return this;
    }

    @JsonProperty(value="problems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CapabilityProblem> getProblems() {
        return this.problems;
    }

    @JsonProperty(value="problems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProblems(List<CapabilityProblem> problems) {
        this.problems = problems;
        this.isSetProblems = true;
    }

    public LegalEntity reference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
    }

    public LegalEntity soleProprietorship(SoleProprietorship soleProprietorship) {
        this.soleProprietorship = soleProprietorship;
        this.isSetSoleProprietorship = true;
        return this;
    }

    @JsonProperty(value="soleProprietorship")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SoleProprietorship getSoleProprietorship() {
        return this.soleProprietorship;
    }

    @JsonProperty(value="soleProprietorship")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSoleProprietorship(SoleProprietorship soleProprietorship) {
        this.soleProprietorship = soleProprietorship;
        this.isSetSoleProprietorship = true;
    }

    @JsonProperty(value="transferInstruments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TransferInstrumentReference> getTransferInstruments() {
        return this.transferInstruments;
    }

    public LegalEntity trust(Trust trust) {
        this.trust = trust;
        this.isSetTrust = true;
        return this;
    }

    @JsonProperty(value="trust")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Trust getTrust() {
        return this.trust;
    }

    @JsonProperty(value="trust")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTrust(Trust trust) {
        this.trust = trust;
        this.isSetTrust = true;
    }

    public LegalEntity type(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
    }

    public LegalEntity unincorporatedPartnership(UnincorporatedPartnership unincorporatedPartnership) {
        this.unincorporatedPartnership = unincorporatedPartnership;
        this.isSetUnincorporatedPartnership = true;
        return this;
    }

    @JsonProperty(value="unincorporatedPartnership")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UnincorporatedPartnership getUnincorporatedPartnership() {
        return this.unincorporatedPartnership;
    }

    @JsonProperty(value="unincorporatedPartnership")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUnincorporatedPartnership(UnincorporatedPartnership unincorporatedPartnership) {
        this.unincorporatedPartnership = unincorporatedPartnership;
        this.isSetUnincorporatedPartnership = true;
    }

    @JsonProperty(value="verificationDeadlines")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<VerificationDeadline> getVerificationDeadlines() {
        return this.verificationDeadlines;
    }

    public LegalEntity verificationPlan(String verificationPlan) {
        this.verificationPlan = verificationPlan;
        this.isSetVerificationPlan = true;
        return this;
    }

    @JsonProperty(value="verificationPlan")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVerificationPlan() {
        return this.verificationPlan;
    }

    @JsonProperty(value="verificationPlan")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVerificationPlan(String verificationPlan) {
        this.verificationPlan = verificationPlan;
        this.isSetVerificationPlan = true;
    }

    public LegalEntity includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegalEntity legalEntity = (LegalEntity)o;
        return Objects.equals(this.capabilities, legalEntity.capabilities) && Objects.equals(this.isSetCapabilities, legalEntity.isSetCapabilities) && Objects.equals(this.documentDetails, legalEntity.documentDetails) && Objects.equals(this.isSetDocumentDetails, legalEntity.isSetDocumentDetails) && Objects.equals(this.documents, legalEntity.documents) && Objects.equals(this.isSetDocuments, legalEntity.isSetDocuments) && Objects.equals(this.entityAssociations, legalEntity.entityAssociations) && Objects.equals(this.isSetEntityAssociations, legalEntity.isSetEntityAssociations) && Objects.equals(this.id, legalEntity.id) && Objects.equals(this.isSetId, legalEntity.isSetId) && Objects.equals(this.individual, legalEntity.individual) && Objects.equals(this.isSetIndividual, legalEntity.isSetIndividual) && Objects.equals(this.organization, legalEntity.organization) && Objects.equals(this.isSetOrganization, legalEntity.isSetOrganization) && Objects.equals(this.problems, legalEntity.problems) && Objects.equals(this.isSetProblems, legalEntity.isSetProblems) && Objects.equals(this.reference, legalEntity.reference) && Objects.equals(this.isSetReference, legalEntity.isSetReference) && Objects.equals(this.soleProprietorship, legalEntity.soleProprietorship) && Objects.equals(this.isSetSoleProprietorship, legalEntity.isSetSoleProprietorship) && Objects.equals(this.transferInstruments, legalEntity.transferInstruments) && Objects.equals(this.isSetTransferInstruments, legalEntity.isSetTransferInstruments) && Objects.equals(this.trust, legalEntity.trust) && Objects.equals(this.isSetTrust, legalEntity.isSetTrust) && Objects.equals((Object)this.type, (Object)legalEntity.type) && Objects.equals(this.isSetType, legalEntity.isSetType) && Objects.equals(this.unincorporatedPartnership, legalEntity.unincorporatedPartnership) && Objects.equals(this.isSetUnincorporatedPartnership, legalEntity.isSetUnincorporatedPartnership) && Objects.equals(this.verificationDeadlines, legalEntity.verificationDeadlines) && Objects.equals(this.isSetVerificationDeadlines, legalEntity.isSetVerificationDeadlines) && Objects.equals(this.verificationPlan, legalEntity.verificationPlan) && Objects.equals(this.isSetVerificationPlan, legalEntity.isSetVerificationPlan);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.capabilities, this.isSetCapabilities, this.documentDetails, this.isSetDocumentDetails, this.documents, this.isSetDocuments, this.entityAssociations, this.isSetEntityAssociations, this.id, this.isSetId, this.individual, this.isSetIndividual, this.organization, this.isSetOrganization, this.problems, this.isSetProblems, this.reference, this.isSetReference, this.soleProprietorship, this.isSetSoleProprietorship, this.transferInstruments, this.isSetTransferInstruments, this.trust, this.isSetTrust, this.type, this.isSetType, this.unincorporatedPartnership, this.isSetUnincorporatedPartnership, this.verificationDeadlines, this.isSetVerificationDeadlines, this.verificationPlan, this.isSetVerificationPlan});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LegalEntity {\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    documentDetails: ").append(this.toIndentedString(this.documentDetails)).append("\n");
        sb.append("    documents: ").append(this.toIndentedString(this.documents)).append("\n");
        sb.append("    entityAssociations: ").append(this.toIndentedString(this.entityAssociations)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    individual: ").append(this.toIndentedString(this.individual)).append("\n");
        sb.append("    organization: ").append(this.toIndentedString(this.organization)).append("\n");
        sb.append("    problems: ").append(this.toIndentedString(this.problems)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    soleProprietorship: ").append(this.toIndentedString(this.soleProprietorship)).append("\n");
        sb.append("    transferInstruments: ").append(this.toIndentedString(this.transferInstruments)).append("\n");
        sb.append("    trust: ").append(this.toIndentedString(this.trust)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    unincorporatedPartnership: ").append(this.toIndentedString(this.unincorporatedPartnership)).append("\n");
        sb.append("    verificationDeadlines: ").append(this.toIndentedString(this.verificationDeadlines)).append("\n");
        sb.append("    verificationPlan: ").append(this.toIndentedString(this.verificationPlan)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetCapabilities) {
            this.addIfNull(nulls, JSON_PROPERTY_CAPABILITIES, this.capabilities);
        }
        if (this.isSetDocumentDetails) {
            this.addIfNull(nulls, JSON_PROPERTY_DOCUMENT_DETAILS, this.documentDetails);
        }
        if (this.isSetDocuments) {
            this.addIfNull(nulls, JSON_PROPERTY_DOCUMENTS, this.documents);
        }
        if (this.isSetEntityAssociations) {
            this.addIfNull(nulls, JSON_PROPERTY_ENTITY_ASSOCIATIONS, this.entityAssociations);
        }
        if (this.isSetId) {
            this.addIfNull(nulls, JSON_PROPERTY_ID, this.id);
        }
        if (this.isSetIndividual) {
            this.addIfNull(nulls, JSON_PROPERTY_INDIVIDUAL, this.individual);
        }
        if (this.isSetOrganization) {
            this.addIfNull(nulls, JSON_PROPERTY_ORGANIZATION, this.organization);
        }
        if (this.isSetProblems) {
            this.addIfNull(nulls, JSON_PROPERTY_PROBLEMS, this.problems);
        }
        if (this.isSetReference) {
            this.addIfNull(nulls, JSON_PROPERTY_REFERENCE, this.reference);
        }
        if (this.isSetSoleProprietorship) {
            this.addIfNull(nulls, JSON_PROPERTY_SOLE_PROPRIETORSHIP, this.soleProprietorship);
        }
        if (this.isSetTransferInstruments) {
            this.addIfNull(nulls, JSON_PROPERTY_TRANSFER_INSTRUMENTS, this.transferInstruments);
        }
        if (this.isSetTrust) {
            this.addIfNull(nulls, JSON_PROPERTY_TRUST, this.trust);
        }
        if (this.isSetType) {
            this.addIfNull(nulls, JSON_PROPERTY_TYPE, (Object)this.type);
        }
        if (this.isSetUnincorporatedPartnership) {
            this.addIfNull(nulls, JSON_PROPERTY_UNINCORPORATED_PARTNERSHIP, this.unincorporatedPartnership);
        }
        if (this.isSetVerificationDeadlines) {
            this.addIfNull(nulls, JSON_PROPERTY_VERIFICATION_DEADLINES, this.verificationDeadlines);
        }
        if (this.isSetVerificationPlan) {
            this.addIfNull(nulls, JSON_PROPERTY_VERIFICATION_PLAN, this.verificationPlan);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static LegalEntity fromJson(String jsonString) throws JsonProcessingException {
        return (LegalEntity)JSON.getMapper().readValue(jsonString, LegalEntity.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        INDIVIDUAL(String.valueOf("individual")),
        ORGANIZATION(String.valueOf("organization")),
        SOLEPROPRIETORSHIP(String.valueOf("soleProprietorship")),
        TRUST(String.valueOf("trust")),
        UNINCORPORATEDPARTNERSHIP(String.valueOf("unincorporatedPartnership"));

        private static final Logger LOG;
        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("TypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])TypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(TypeEnum.class.getName());
        }
    }
}

