/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.PaymentMethodToStore;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"merchantAccount", "paymentMethod", "recurringProcessingModel", "shopperEmail", "shopperIP", "shopperReference"})
public class StoredPaymentMethodRequest {
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    private boolean isSetMerchantAccount = false;
    public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
    private PaymentMethodToStore paymentMethod;
    private boolean isSetPaymentMethod = false;
    public static final String JSON_PROPERTY_RECURRING_PROCESSING_MODEL = "recurringProcessingModel";
    private RecurringProcessingModelEnum recurringProcessingModel;
    private boolean isSetRecurringProcessingModel = false;
    public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
    private String shopperEmail;
    private boolean isSetShopperEmail = false;
    public static final String JSON_PROPERTY_SHOPPER_I_P = "shopperIP";
    private String shopperIP;
    private boolean isSetShopperIP = false;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;
    private boolean isSetShopperReference = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public StoredPaymentMethodRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        this.isSetMerchantAccount = true;
        return this;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        this.isSetMerchantAccount = true;
    }

    public StoredPaymentMethodRequest paymentMethod(PaymentMethodToStore paymentMethod) {
        this.paymentMethod = paymentMethod;
        this.isSetPaymentMethod = true;
        return this;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentMethodToStore getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethod(PaymentMethodToStore paymentMethod) {
        this.paymentMethod = paymentMethod;
        this.isSetPaymentMethod = true;
    }

    public StoredPaymentMethodRequest recurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
        this.isSetRecurringProcessingModel = true;
        return this;
    }

    @JsonProperty(value="recurringProcessingModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RecurringProcessingModelEnum getRecurringProcessingModel() {
        return this.recurringProcessingModel;
    }

    @JsonProperty(value="recurringProcessingModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
        this.isSetRecurringProcessingModel = true;
    }

    public StoredPaymentMethodRequest shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        this.isSetShopperEmail = true;
        return this;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        this.isSetShopperEmail = true;
    }

    public StoredPaymentMethodRequest shopperIP(String shopperIP) {
        this.shopperIP = shopperIP;
        this.isSetShopperIP = true;
        return this;
    }

    @JsonProperty(value="shopperIP")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperIP() {
        return this.shopperIP;
    }

    @JsonProperty(value="shopperIP")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperIP(String shopperIP) {
        this.shopperIP = shopperIP;
        this.isSetShopperIP = true;
    }

    public StoredPaymentMethodRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        this.isSetShopperReference = true;
        return this;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        this.isSetShopperReference = true;
    }

    public StoredPaymentMethodRequest includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredPaymentMethodRequest storedPaymentMethodRequest = (StoredPaymentMethodRequest)o;
        return Objects.equals(this.merchantAccount, storedPaymentMethodRequest.merchantAccount) && Objects.equals(this.isSetMerchantAccount, storedPaymentMethodRequest.isSetMerchantAccount) && Objects.equals(this.paymentMethod, storedPaymentMethodRequest.paymentMethod) && Objects.equals(this.isSetPaymentMethod, storedPaymentMethodRequest.isSetPaymentMethod) && Objects.equals((Object)this.recurringProcessingModel, (Object)storedPaymentMethodRequest.recurringProcessingModel) && Objects.equals(this.isSetRecurringProcessingModel, storedPaymentMethodRequest.isSetRecurringProcessingModel) && Objects.equals(this.shopperEmail, storedPaymentMethodRequest.shopperEmail) && Objects.equals(this.isSetShopperEmail, storedPaymentMethodRequest.isSetShopperEmail) && Objects.equals(this.shopperIP, storedPaymentMethodRequest.shopperIP) && Objects.equals(this.isSetShopperIP, storedPaymentMethodRequest.isSetShopperIP) && Objects.equals(this.shopperReference, storedPaymentMethodRequest.shopperReference) && Objects.equals(this.isSetShopperReference, storedPaymentMethodRequest.isSetShopperReference);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.merchantAccount, this.isSetMerchantAccount, this.paymentMethod, this.isSetPaymentMethod, this.recurringProcessingModel, this.isSetRecurringProcessingModel, this.shopperEmail, this.isSetShopperEmail, this.shopperIP, this.isSetShopperIP, this.shopperReference, this.isSetShopperReference});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StoredPaymentMethodRequest {\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    recurringProcessingModel: ").append(this.toIndentedString((Object)this.recurringProcessingModel)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperIP: ").append(this.toIndentedString(this.shopperIP)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetMerchantAccount) {
            this.addIfNull(nulls, JSON_PROPERTY_MERCHANT_ACCOUNT, this.merchantAccount);
        }
        if (this.isSetPaymentMethod) {
            this.addIfNull(nulls, JSON_PROPERTY_PAYMENT_METHOD, this.paymentMethod);
        }
        if (this.isSetRecurringProcessingModel) {
            this.addIfNull(nulls, JSON_PROPERTY_RECURRING_PROCESSING_MODEL, (Object)this.recurringProcessingModel);
        }
        if (this.isSetShopperEmail) {
            this.addIfNull(nulls, JSON_PROPERTY_SHOPPER_EMAIL, this.shopperEmail);
        }
        if (this.isSetShopperIP) {
            this.addIfNull(nulls, JSON_PROPERTY_SHOPPER_I_P, this.shopperIP);
        }
        if (this.isSetShopperReference) {
            this.addIfNull(nulls, JSON_PROPERTY_SHOPPER_REFERENCE, this.shopperReference);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static StoredPaymentMethodRequest fromJson(String jsonString) throws JsonProcessingException {
        return (StoredPaymentMethodRequest)JSON.getMapper().readValue(jsonString, StoredPaymentMethodRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum RecurringProcessingModelEnum {
        CARDONFILE(String.valueOf("CardOnFile")),
        SUBSCRIPTION(String.valueOf("Subscription")),
        UNSCHEDULEDCARDONFILE(String.valueOf("UnscheduledCardOnFile"));

        private static final Logger LOG;
        private String value;

        private RecurringProcessingModelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RecurringProcessingModelEnum fromValue(String value) {
            for (RecurringProcessingModelEnum b : RecurringProcessingModelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("RecurringProcessingModelEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])RecurringProcessingModelEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(RecurringProcessingModelEnum.class.getName());
        }
    }
}

