/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.Amount;
import com.adyen.model.balanceplatform.Fee;
import com.adyen.model.balanceplatform.JSON;
import com.adyen.model.balanceplatform.Repayment;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"accountHolderId", "amount", "contractType", "expiresAt", "fee", "id", "repayment", "startsAt"})
public class GrantOffer {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_ID = "accountHolderId";
    private String accountHolderId;
    private boolean isSetAccountHolderId = false;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    private boolean isSetAmount = false;
    public static final String JSON_PROPERTY_CONTRACT_TYPE = "contractType";
    private ContractTypeEnum contractType;
    private boolean isSetContractType = false;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private OffsetDateTime expiresAt;
    private boolean isSetExpiresAt = false;
    public static final String JSON_PROPERTY_FEE = "fee";
    private Fee fee;
    private boolean isSetFee = false;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    private boolean isSetId = false;
    public static final String JSON_PROPERTY_REPAYMENT = "repayment";
    private Repayment repayment;
    private boolean isSetRepayment = false;
    public static final String JSON_PROPERTY_STARTS_AT = "startsAt";
    private OffsetDateTime startsAt;
    private boolean isSetStartsAt = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public GrantOffer accountHolderId(String accountHolderId) {
        this.accountHolderId = accountHolderId;
        this.isSetAccountHolderId = true;
        return this;
    }

    @JsonProperty(value="accountHolderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderId() {
        return this.accountHolderId;
    }

    @JsonProperty(value="accountHolderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderId(String accountHolderId) {
        this.accountHolderId = accountHolderId;
        this.isSetAccountHolderId = true;
    }

    public GrantOffer amount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
    }

    public GrantOffer contractType(ContractTypeEnum contractType) {
        this.contractType = contractType;
        this.isSetContractType = true;
        return this;
    }

    @JsonProperty(value="contractType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContractTypeEnum getContractType() {
        return this.contractType;
    }

    @JsonProperty(value="contractType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContractType(ContractTypeEnum contractType) {
        this.contractType = contractType;
        this.isSetContractType = true;
    }

    public GrantOffer expiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
        this.isSetExpiresAt = true;
        return this;
    }

    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
        this.isSetExpiresAt = true;
    }

    public GrantOffer fee(Fee fee) {
        this.fee = fee;
        this.isSetFee = true;
        return this;
    }

    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Fee getFee() {
        return this.fee;
    }

    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFee(Fee fee) {
        this.fee = fee;
        this.isSetFee = true;
    }

    public GrantOffer id(String id) {
        this.id = id;
        this.isSetId = true;
        return this;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
        this.isSetId = true;
    }

    public GrantOffer repayment(Repayment repayment) {
        this.repayment = repayment;
        this.isSetRepayment = true;
        return this;
    }

    @JsonProperty(value="repayment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Repayment getRepayment() {
        return this.repayment;
    }

    @JsonProperty(value="repayment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRepayment(Repayment repayment) {
        this.repayment = repayment;
        this.isSetRepayment = true;
    }

    public GrantOffer startsAt(OffsetDateTime startsAt) {
        this.startsAt = startsAt;
        this.isSetStartsAt = true;
        return this;
    }

    @JsonProperty(value="startsAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getStartsAt() {
        return this.startsAt;
    }

    @JsonProperty(value="startsAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartsAt(OffsetDateTime startsAt) {
        this.startsAt = startsAt;
        this.isSetStartsAt = true;
    }

    public GrantOffer includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrantOffer grantOffer = (GrantOffer)o;
        return Objects.equals(this.accountHolderId, grantOffer.accountHolderId) && Objects.equals(this.isSetAccountHolderId, grantOffer.isSetAccountHolderId) && Objects.equals(this.amount, grantOffer.amount) && Objects.equals(this.isSetAmount, grantOffer.isSetAmount) && Objects.equals((Object)this.contractType, (Object)grantOffer.contractType) && Objects.equals(this.isSetContractType, grantOffer.isSetContractType) && Objects.equals(this.expiresAt, grantOffer.expiresAt) && Objects.equals(this.isSetExpiresAt, grantOffer.isSetExpiresAt) && Objects.equals(this.fee, grantOffer.fee) && Objects.equals(this.isSetFee, grantOffer.isSetFee) && Objects.equals(this.id, grantOffer.id) && Objects.equals(this.isSetId, grantOffer.isSetId) && Objects.equals(this.repayment, grantOffer.repayment) && Objects.equals(this.isSetRepayment, grantOffer.isSetRepayment) && Objects.equals(this.startsAt, grantOffer.startsAt) && Objects.equals(this.isSetStartsAt, grantOffer.isSetStartsAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountHolderId, this.isSetAccountHolderId, this.amount, this.isSetAmount, this.contractType, this.isSetContractType, this.expiresAt, this.isSetExpiresAt, this.fee, this.isSetFee, this.id, this.isSetId, this.repayment, this.isSetRepayment, this.startsAt, this.isSetStartsAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GrantOffer {\n");
        sb.append("    accountHolderId: ").append(this.toIndentedString(this.accountHolderId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    contractType: ").append(this.toIndentedString((Object)this.contractType)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    repayment: ").append(this.toIndentedString(this.repayment)).append("\n");
        sb.append("    startsAt: ").append(this.toIndentedString(this.startsAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAccountHolderId) {
            this.addIfNull(nulls, JSON_PROPERTY_ACCOUNT_HOLDER_ID, this.accountHolderId);
        }
        if (this.isSetAmount) {
            this.addIfNull(nulls, JSON_PROPERTY_AMOUNT, this.amount);
        }
        if (this.isSetContractType) {
            this.addIfNull(nulls, JSON_PROPERTY_CONTRACT_TYPE, (Object)this.contractType);
        }
        if (this.isSetExpiresAt) {
            this.addIfNull(nulls, JSON_PROPERTY_EXPIRES_AT, this.expiresAt);
        }
        if (this.isSetFee) {
            this.addIfNull(nulls, JSON_PROPERTY_FEE, this.fee);
        }
        if (this.isSetId) {
            this.addIfNull(nulls, JSON_PROPERTY_ID, this.id);
        }
        if (this.isSetRepayment) {
            this.addIfNull(nulls, JSON_PROPERTY_REPAYMENT, this.repayment);
        }
        if (this.isSetStartsAt) {
            this.addIfNull(nulls, JSON_PROPERTY_STARTS_AT, this.startsAt);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static GrantOffer fromJson(String jsonString) throws JsonProcessingException {
        return (GrantOffer)JSON.getMapper().readValue(jsonString, GrantOffer.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ContractTypeEnum {
        CASHADVANCE(String.valueOf("cashAdvance")),
        LOAN(String.valueOf("loan"));

        private static final Logger LOG;
        private String value;

        private ContractTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ContractTypeEnum fromValue(String value) {
            for (ContractTypeEnum b : ContractTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("ContractTypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])ContractTypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(ContractTypeEnum.class.getName());
        }
    }
}

