/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.FraudResult;
import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"additionalData", "balance", "fraudResult", "pspReference", "refusalReason", "resultCode", "transactionLimit"})
public class BalanceCheckResponse {
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData;
    public static final String JSON_PROPERTY_BALANCE = "balance";
    private Amount balance;
    public static final String JSON_PROPERTY_FRAUD_RESULT = "fraudResult";
    private FraudResult fraudResult;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    public static final String JSON_PROPERTY_REFUSAL_REASON = "refusalReason";
    private String refusalReason;
    public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
    private ResultCodeEnum resultCode;
    public static final String JSON_PROPERTY_TRANSACTION_LIMIT = "transactionLimit";
    private Amount transactionLimit;

    public BalanceCheckResponse additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public BalanceCheckResponse putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public BalanceCheckResponse balance(Amount balance) {
        this.balance = balance;
        return this;
    }

    @JsonProperty(value="balance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getBalance() {
        return this.balance;
    }

    @JsonProperty(value="balance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalance(Amount balance) {
        this.balance = balance;
    }

    public BalanceCheckResponse fraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
        return this;
    }

    @JsonProperty(value="fraudResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FraudResult getFraudResult() {
        return this.fraudResult;
    }

    @JsonProperty(value="fraudResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
    }

    public BalanceCheckResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public BalanceCheckResponse refusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        return this;
    }

    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefusalReason() {
        return this.refusalReason;
    }

    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
    }

    public BalanceCheckResponse resultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
    }

    public BalanceCheckResponse transactionLimit(Amount transactionLimit) {
        this.transactionLimit = transactionLimit;
        return this;
    }

    @JsonProperty(value="transactionLimit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getTransactionLimit() {
        return this.transactionLimit;
    }

    @JsonProperty(value="transactionLimit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransactionLimit(Amount transactionLimit) {
        this.transactionLimit = transactionLimit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalanceCheckResponse balanceCheckResponse = (BalanceCheckResponse)o;
        return Objects.equals(this.additionalData, balanceCheckResponse.additionalData) && Objects.equals(this.balance, balanceCheckResponse.balance) && Objects.equals(this.fraudResult, balanceCheckResponse.fraudResult) && Objects.equals(this.pspReference, balanceCheckResponse.pspReference) && Objects.equals(this.refusalReason, balanceCheckResponse.refusalReason) && Objects.equals((Object)this.resultCode, (Object)balanceCheckResponse.resultCode) && Objects.equals(this.transactionLimit, balanceCheckResponse.transactionLimit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalData, this.balance, this.fraudResult, this.pspReference, this.refusalReason, this.resultCode, this.transactionLimit});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BalanceCheckResponse {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    fraudResult: ").append(this.toIndentedString(this.fraudResult)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    refusalReason: ").append(this.toIndentedString(this.refusalReason)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString((Object)this.resultCode)).append("\n");
        sb.append("    transactionLimit: ").append(this.toIndentedString(this.transactionLimit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static BalanceCheckResponse fromJson(String jsonString) throws JsonProcessingException {
        return (BalanceCheckResponse)JSON.getMapper().readValue(jsonString, BalanceCheckResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ResultCodeEnum {
        SUCCESS(String.valueOf("Success")),
        NOTENOUGHBALANCE(String.valueOf("NotEnoughBalance")),
        FAILED(String.valueOf("Failed"));

        private static final Logger LOG;
        private String value;

        private ResultCodeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResultCodeEnum fromValue(String value) {
            for (ResultCodeEnum b : ResultCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("ResultCodeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])ResultCodeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(ResultCodeEnum.class.getName());
        }
    }
}

