/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.AccountInfo;
import com.adyen.model.checkout.Address;
import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.ApplicationInfo;
import com.adyen.model.checkout.BrowserInfo;
import com.adyen.model.checkout.ForexQuote;
import com.adyen.model.checkout.Installments;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.MerchantRiskIndicator;
import com.adyen.model.checkout.Name;
import com.adyen.model.checkout.Recurring;
import com.adyen.model.checkout.Split;
import com.adyen.model.checkout.ThreeDS2RequestData;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"accountInfo", "additionalAmount", "additionalData", "amount", "applicationInfo", "billingAddress", "browserInfo", "captureDelayHours", "dateOfBirth", "dccQuote", "deliveryAddress", "deliveryDate", "deviceFingerprint", "fraudOffset", "installments", "localizedShopperStatement", "mcc", "merchantAccount", "merchantOrderReference", "merchantRiskIndicator", "metadata", "orderReference", "paymentMethod", "recurring", "recurringProcessingModel", "reference", "selectedBrand", "selectedRecurringDetailReference", "sessionId", "shopperEmail", "shopperIP", "shopperInteraction", "shopperLocale", "shopperName", "shopperReference", "shopperStatement", "socialSecurityNumber", "splits", "store", "telephoneNumber", "threeDS2RequestData", "threeDSAuthenticationOnly", "totalsGroup", "trustedShopper"})
public class BalanceCheckRequest {
    public static final String JSON_PROPERTY_ACCOUNT_INFO = "accountInfo";
    private AccountInfo accountInfo;
    public static final String JSON_PROPERTY_ADDITIONAL_AMOUNT = "additionalAmount";
    private Amount additionalAmount;
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_APPLICATION_INFO = "applicationInfo";
    private ApplicationInfo applicationInfo;
    public static final String JSON_PROPERTY_BILLING_ADDRESS = "billingAddress";
    private Address billingAddress;
    public static final String JSON_PROPERTY_BROWSER_INFO = "browserInfo";
    private BrowserInfo browserInfo;
    public static final String JSON_PROPERTY_CAPTURE_DELAY_HOURS = "captureDelayHours";
    private Integer captureDelayHours;
    public static final String JSON_PROPERTY_DATE_OF_BIRTH = "dateOfBirth";
    private LocalDate dateOfBirth;
    public static final String JSON_PROPERTY_DCC_QUOTE = "dccQuote";
    private ForexQuote dccQuote;
    public static final String JSON_PROPERTY_DELIVERY_ADDRESS = "deliveryAddress";
    private Address deliveryAddress;
    public static final String JSON_PROPERTY_DELIVERY_DATE = "deliveryDate";
    private OffsetDateTime deliveryDate;
    public static final String JSON_PROPERTY_DEVICE_FINGERPRINT = "deviceFingerprint";
    private String deviceFingerprint;
    public static final String JSON_PROPERTY_FRAUD_OFFSET = "fraudOffset";
    private Integer fraudOffset;
    public static final String JSON_PROPERTY_INSTALLMENTS = "installments";
    private Installments installments;
    public static final String JSON_PROPERTY_LOCALIZED_SHOPPER_STATEMENT = "localizedShopperStatement";
    private Map<String, String> localizedShopperStatement;
    public static final String JSON_PROPERTY_MCC = "mcc";
    private String mcc;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_MERCHANT_ORDER_REFERENCE = "merchantOrderReference";
    private String merchantOrderReference;
    public static final String JSON_PROPERTY_MERCHANT_RISK_INDICATOR = "merchantRiskIndicator";
    private MerchantRiskIndicator merchantRiskIndicator;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, String> metadata;
    public static final String JSON_PROPERTY_ORDER_REFERENCE = "orderReference";
    private String orderReference;
    public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
    private Map<String, String> paymentMethod;
    public static final String JSON_PROPERTY_RECURRING = "recurring";
    private Recurring recurring;
    public static final String JSON_PROPERTY_RECURRING_PROCESSING_MODEL = "recurringProcessingModel";
    private RecurringProcessingModelEnum recurringProcessingModel;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_SELECTED_BRAND = "selectedBrand";
    private String selectedBrand;
    public static final String JSON_PROPERTY_SELECTED_RECURRING_DETAIL_REFERENCE = "selectedRecurringDetailReference";
    private String selectedRecurringDetailReference;
    public static final String JSON_PROPERTY_SESSION_ID = "sessionId";
    private String sessionId;
    public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
    private String shopperEmail;
    public static final String JSON_PROPERTY_SHOPPER_I_P = "shopperIP";
    private String shopperIP;
    public static final String JSON_PROPERTY_SHOPPER_INTERACTION = "shopperInteraction";
    private ShopperInteractionEnum shopperInteraction;
    public static final String JSON_PROPERTY_SHOPPER_LOCALE = "shopperLocale";
    private String shopperLocale;
    public static final String JSON_PROPERTY_SHOPPER_NAME = "shopperName";
    private Name shopperName;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;
    public static final String JSON_PROPERTY_SHOPPER_STATEMENT = "shopperStatement";
    private String shopperStatement;
    public static final String JSON_PROPERTY_SOCIAL_SECURITY_NUMBER = "socialSecurityNumber";
    private String socialSecurityNumber;
    public static final String JSON_PROPERTY_SPLITS = "splits";
    private List<Split> splits;
    public static final String JSON_PROPERTY_STORE = "store";
    private String store;
    public static final String JSON_PROPERTY_TELEPHONE_NUMBER = "telephoneNumber";
    private String telephoneNumber;
    public static final String JSON_PROPERTY_THREE_D_S2_REQUEST_DATA = "threeDS2RequestData";
    private ThreeDS2RequestData threeDS2RequestData;
    public static final String JSON_PROPERTY_THREE_D_S_AUTHENTICATION_ONLY = "threeDSAuthenticationOnly";
    @Deprecated
    private Boolean threeDSAuthenticationOnly;
    public static final String JSON_PROPERTY_TOTALS_GROUP = "totalsGroup";
    private String totalsGroup;
    public static final String JSON_PROPERTY_TRUSTED_SHOPPER = "trustedShopper";
    private Boolean trustedShopper;

    public BalanceCheckRequest accountInfo(AccountInfo accountInfo) {
        this.accountInfo = accountInfo;
        return this;
    }

    @JsonProperty(value="accountInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccountInfo getAccountInfo() {
        return this.accountInfo;
    }

    @JsonProperty(value="accountInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountInfo(AccountInfo accountInfo) {
        this.accountInfo = accountInfo;
    }

    public BalanceCheckRequest additionalAmount(Amount additionalAmount) {
        this.additionalAmount = additionalAmount;
        return this;
    }

    @JsonProperty(value="additionalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAdditionalAmount() {
        return this.additionalAmount;
    }

    @JsonProperty(value="additionalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalAmount(Amount additionalAmount) {
        this.additionalAmount = additionalAmount;
    }

    public BalanceCheckRequest additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public BalanceCheckRequest putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public BalanceCheckRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public BalanceCheckRequest applicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
        return this;
    }

    @JsonProperty(value="applicationInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    @JsonProperty(value="applicationInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
    }

    public BalanceCheckRequest billingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @JsonProperty(value="billingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    @JsonProperty(value="billingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public BalanceCheckRequest browserInfo(BrowserInfo browserInfo) {
        this.browserInfo = browserInfo;
        return this;
    }

    @JsonProperty(value="browserInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BrowserInfo getBrowserInfo() {
        return this.browserInfo;
    }

    @JsonProperty(value="browserInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrowserInfo(BrowserInfo browserInfo) {
        this.browserInfo = browserInfo;
    }

    public BalanceCheckRequest captureDelayHours(Integer captureDelayHours) {
        this.captureDelayHours = captureDelayHours;
        return this;
    }

    @JsonProperty(value="captureDelayHours")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getCaptureDelayHours() {
        return this.captureDelayHours;
    }

    @JsonProperty(value="captureDelayHours")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCaptureDelayHours(Integer captureDelayHours) {
        this.captureDelayHours = captureDelayHours;
    }

    public BalanceCheckRequest dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public BalanceCheckRequest dccQuote(ForexQuote dccQuote) {
        this.dccQuote = dccQuote;
        return this;
    }

    @JsonProperty(value="dccQuote")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ForexQuote getDccQuote() {
        return this.dccQuote;
    }

    @JsonProperty(value="dccQuote")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDccQuote(ForexQuote dccQuote) {
        this.dccQuote = dccQuote;
    }

    public BalanceCheckRequest deliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
        return this;
    }

    @JsonProperty(value="deliveryAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getDeliveryAddress() {
        return this.deliveryAddress;
    }

    @JsonProperty(value="deliveryAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public BalanceCheckRequest deliveryDate(OffsetDateTime deliveryDate) {
        this.deliveryDate = deliveryDate;
        return this;
    }

    @JsonProperty(value="deliveryDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getDeliveryDate() {
        return this.deliveryDate;
    }

    @JsonProperty(value="deliveryDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryDate(OffsetDateTime deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public BalanceCheckRequest deviceFingerprint(String deviceFingerprint) {
        this.deviceFingerprint = deviceFingerprint;
        return this;
    }

    @JsonProperty(value="deviceFingerprint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeviceFingerprint() {
        return this.deviceFingerprint;
    }

    @JsonProperty(value="deviceFingerprint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceFingerprint(String deviceFingerprint) {
        this.deviceFingerprint = deviceFingerprint;
    }

    public BalanceCheckRequest fraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
        return this;
    }

    @JsonProperty(value="fraudOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFraudOffset() {
        return this.fraudOffset;
    }

    @JsonProperty(value="fraudOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
    }

    public BalanceCheckRequest installments(Installments installments) {
        this.installments = installments;
        return this;
    }

    @JsonProperty(value="installments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Installments getInstallments() {
        return this.installments;
    }

    @JsonProperty(value="installments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInstallments(Installments installments) {
        this.installments = installments;
    }

    public BalanceCheckRequest localizedShopperStatement(Map<String, String> localizedShopperStatement) {
        this.localizedShopperStatement = localizedShopperStatement;
        return this;
    }

    public BalanceCheckRequest putLocalizedShopperStatementItem(String key, String localizedShopperStatementItem) {
        if (this.localizedShopperStatement == null) {
            this.localizedShopperStatement = new HashMap<String, String>();
        }
        this.localizedShopperStatement.put(key, localizedShopperStatementItem);
        return this;
    }

    @JsonProperty(value="localizedShopperStatement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getLocalizedShopperStatement() {
        return this.localizedShopperStatement;
    }

    @JsonProperty(value="localizedShopperStatement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocalizedShopperStatement(Map<String, String> localizedShopperStatement) {
        this.localizedShopperStatement = localizedShopperStatement;
    }

    public BalanceCheckRequest mcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    @JsonProperty(value="mcc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMcc() {
        return this.mcc;
    }

    @JsonProperty(value="mcc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    public BalanceCheckRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public BalanceCheckRequest merchantOrderReference(String merchantOrderReference) {
        this.merchantOrderReference = merchantOrderReference;
        return this;
    }

    @JsonProperty(value="merchantOrderReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantOrderReference() {
        return this.merchantOrderReference;
    }

    @JsonProperty(value="merchantOrderReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantOrderReference(String merchantOrderReference) {
        this.merchantOrderReference = merchantOrderReference;
    }

    public BalanceCheckRequest merchantRiskIndicator(MerchantRiskIndicator merchantRiskIndicator) {
        this.merchantRiskIndicator = merchantRiskIndicator;
        return this;
    }

    @JsonProperty(value="merchantRiskIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MerchantRiskIndicator getMerchantRiskIndicator() {
        return this.merchantRiskIndicator;
    }

    @JsonProperty(value="merchantRiskIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantRiskIndicator(MerchantRiskIndicator merchantRiskIndicator) {
        this.merchantRiskIndicator = merchantRiskIndicator;
    }

    public BalanceCheckRequest metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public BalanceCheckRequest putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public BalanceCheckRequest orderReference(String orderReference) {
        this.orderReference = orderReference;
        return this;
    }

    @JsonProperty(value="orderReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrderReference() {
        return this.orderReference;
    }

    @JsonProperty(value="orderReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrderReference(String orderReference) {
        this.orderReference = orderReference;
    }

    public BalanceCheckRequest paymentMethod(Map<String, String> paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    public BalanceCheckRequest putPaymentMethodItem(String key, String paymentMethodItem) {
        if (this.paymentMethod == null) {
            this.paymentMethod = new HashMap<String, String>();
        }
        this.paymentMethod.put(key, paymentMethodItem);
        return this;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethod(Map<String, String> paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public BalanceCheckRequest recurring(Recurring recurring) {
        this.recurring = recurring;
        return this;
    }

    @JsonProperty(value="recurring")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Recurring getRecurring() {
        return this.recurring;
    }

    @JsonProperty(value="recurring")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurring(Recurring recurring) {
        this.recurring = recurring;
    }

    public BalanceCheckRequest recurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
        return this;
    }

    @JsonProperty(value="recurringProcessingModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RecurringProcessingModelEnum getRecurringProcessingModel() {
        return this.recurringProcessingModel;
    }

    @JsonProperty(value="recurringProcessingModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
    }

    public BalanceCheckRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public BalanceCheckRequest selectedBrand(String selectedBrand) {
        this.selectedBrand = selectedBrand;
        return this;
    }

    @JsonProperty(value="selectedBrand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSelectedBrand() {
        return this.selectedBrand;
    }

    @JsonProperty(value="selectedBrand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelectedBrand(String selectedBrand) {
        this.selectedBrand = selectedBrand;
    }

    public BalanceCheckRequest selectedRecurringDetailReference(String selectedRecurringDetailReference) {
        this.selectedRecurringDetailReference = selectedRecurringDetailReference;
        return this;
    }

    @JsonProperty(value="selectedRecurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSelectedRecurringDetailReference() {
        return this.selectedRecurringDetailReference;
    }

    @JsonProperty(value="selectedRecurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelectedRecurringDetailReference(String selectedRecurringDetailReference) {
        this.selectedRecurringDetailReference = selectedRecurringDetailReference;
    }

    public BalanceCheckRequest sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @JsonProperty(value="sessionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSessionId() {
        return this.sessionId;
    }

    @JsonProperty(value="sessionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public BalanceCheckRequest shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public BalanceCheckRequest shopperIP(String shopperIP) {
        this.shopperIP = shopperIP;
        return this;
    }

    @JsonProperty(value="shopperIP")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperIP() {
        return this.shopperIP;
    }

    @JsonProperty(value="shopperIP")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperIP(String shopperIP) {
        this.shopperIP = shopperIP;
    }

    public BalanceCheckRequest shopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
        return this;
    }

    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ShopperInteractionEnum getShopperInteraction() {
        return this.shopperInteraction;
    }

    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
    }

    public BalanceCheckRequest shopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
        return this;
    }

    @JsonProperty(value="shopperLocale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperLocale() {
        return this.shopperLocale;
    }

    @JsonProperty(value="shopperLocale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
    }

    public BalanceCheckRequest shopperName(Name shopperName) {
        this.shopperName = shopperName;
        return this;
    }

    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Name getShopperName() {
        return this.shopperName;
    }

    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperName(Name shopperName) {
        this.shopperName = shopperName;
    }

    public BalanceCheckRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public BalanceCheckRequest shopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
        return this;
    }

    @JsonProperty(value="shopperStatement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperStatement() {
        return this.shopperStatement;
    }

    @JsonProperty(value="shopperStatement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
    }

    public BalanceCheckRequest socialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
        return this;
    }

    @JsonProperty(value="socialSecurityNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    @JsonProperty(value="socialSecurityNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public BalanceCheckRequest splits(List<Split> splits) {
        this.splits = splits;
        return this;
    }

    public BalanceCheckRequest addSplitsItem(Split splitsItem) {
        if (this.splits == null) {
            this.splits = new ArrayList<Split>();
        }
        this.splits.add(splitsItem);
        return this;
    }

    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Split> getSplits() {
        return this.splits;
    }

    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public BalanceCheckRequest store(String store) {
        this.store = store;
        return this;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStore() {
        return this.store;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStore(String store) {
        this.store = store;
    }

    public BalanceCheckRequest telephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
        return this;
    }

    @JsonProperty(value="telephoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    @JsonProperty(value="telephoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    public BalanceCheckRequest threeDS2RequestData(ThreeDS2RequestData threeDS2RequestData) {
        this.threeDS2RequestData = threeDS2RequestData;
        return this;
    }

    @JsonProperty(value="threeDS2RequestData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThreeDS2RequestData getThreeDS2RequestData() {
        return this.threeDS2RequestData;
    }

    @JsonProperty(value="threeDS2RequestData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDS2RequestData(ThreeDS2RequestData threeDS2RequestData) {
        this.threeDS2RequestData = threeDS2RequestData;
    }

    @Deprecated
    public BalanceCheckRequest threeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
        this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
        return this;
    }

    @Deprecated
    @JsonProperty(value="threeDSAuthenticationOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getThreeDSAuthenticationOnly() {
        return this.threeDSAuthenticationOnly;
    }

    @Deprecated
    @JsonProperty(value="threeDSAuthenticationOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
        this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
    }

    public BalanceCheckRequest totalsGroup(String totalsGroup) {
        this.totalsGroup = totalsGroup;
        return this;
    }

    @JsonProperty(value="totalsGroup")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTotalsGroup() {
        return this.totalsGroup;
    }

    @JsonProperty(value="totalsGroup")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalsGroup(String totalsGroup) {
        this.totalsGroup = totalsGroup;
    }

    public BalanceCheckRequest trustedShopper(Boolean trustedShopper) {
        this.trustedShopper = trustedShopper;
        return this;
    }

    @JsonProperty(value="trustedShopper")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getTrustedShopper() {
        return this.trustedShopper;
    }

    @JsonProperty(value="trustedShopper")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTrustedShopper(Boolean trustedShopper) {
        this.trustedShopper = trustedShopper;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalanceCheckRequest balanceCheckRequest = (BalanceCheckRequest)o;
        return Objects.equals(this.accountInfo, balanceCheckRequest.accountInfo) && Objects.equals(this.additionalAmount, balanceCheckRequest.additionalAmount) && Objects.equals(this.additionalData, balanceCheckRequest.additionalData) && Objects.equals(this.amount, balanceCheckRequest.amount) && Objects.equals(this.applicationInfo, balanceCheckRequest.applicationInfo) && Objects.equals(this.billingAddress, balanceCheckRequest.billingAddress) && Objects.equals(this.browserInfo, balanceCheckRequest.browserInfo) && Objects.equals(this.captureDelayHours, balanceCheckRequest.captureDelayHours) && Objects.equals(this.dateOfBirth, balanceCheckRequest.dateOfBirth) && Objects.equals(this.dccQuote, balanceCheckRequest.dccQuote) && Objects.equals(this.deliveryAddress, balanceCheckRequest.deliveryAddress) && Objects.equals(this.deliveryDate, balanceCheckRequest.deliveryDate) && Objects.equals(this.deviceFingerprint, balanceCheckRequest.deviceFingerprint) && Objects.equals(this.fraudOffset, balanceCheckRequest.fraudOffset) && Objects.equals(this.installments, balanceCheckRequest.installments) && Objects.equals(this.localizedShopperStatement, balanceCheckRequest.localizedShopperStatement) && Objects.equals(this.mcc, balanceCheckRequest.mcc) && Objects.equals(this.merchantAccount, balanceCheckRequest.merchantAccount) && Objects.equals(this.merchantOrderReference, balanceCheckRequest.merchantOrderReference) && Objects.equals(this.merchantRiskIndicator, balanceCheckRequest.merchantRiskIndicator) && Objects.equals(this.metadata, balanceCheckRequest.metadata) && Objects.equals(this.orderReference, balanceCheckRequest.orderReference) && Objects.equals(this.paymentMethod, balanceCheckRequest.paymentMethod) && Objects.equals(this.recurring, balanceCheckRequest.recurring) && Objects.equals((Object)this.recurringProcessingModel, (Object)balanceCheckRequest.recurringProcessingModel) && Objects.equals(this.reference, balanceCheckRequest.reference) && Objects.equals(this.selectedBrand, balanceCheckRequest.selectedBrand) && Objects.equals(this.selectedRecurringDetailReference, balanceCheckRequest.selectedRecurringDetailReference) && Objects.equals(this.sessionId, balanceCheckRequest.sessionId) && Objects.equals(this.shopperEmail, balanceCheckRequest.shopperEmail) && Objects.equals(this.shopperIP, balanceCheckRequest.shopperIP) && Objects.equals((Object)this.shopperInteraction, (Object)balanceCheckRequest.shopperInteraction) && Objects.equals(this.shopperLocale, balanceCheckRequest.shopperLocale) && Objects.equals(this.shopperName, balanceCheckRequest.shopperName) && Objects.equals(this.shopperReference, balanceCheckRequest.shopperReference) && Objects.equals(this.shopperStatement, balanceCheckRequest.shopperStatement) && Objects.equals(this.socialSecurityNumber, balanceCheckRequest.socialSecurityNumber) && Objects.equals(this.splits, balanceCheckRequest.splits) && Objects.equals(this.store, balanceCheckRequest.store) && Objects.equals(this.telephoneNumber, balanceCheckRequest.telephoneNumber) && Objects.equals(this.threeDS2RequestData, balanceCheckRequest.threeDS2RequestData) && Objects.equals(this.threeDSAuthenticationOnly, balanceCheckRequest.threeDSAuthenticationOnly) && Objects.equals(this.totalsGroup, balanceCheckRequest.totalsGroup) && Objects.equals(this.trustedShopper, balanceCheckRequest.trustedShopper);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountInfo, this.additionalAmount, this.additionalData, this.amount, this.applicationInfo, this.billingAddress, this.browserInfo, this.captureDelayHours, this.dateOfBirth, this.dccQuote, this.deliveryAddress, this.deliveryDate, this.deviceFingerprint, this.fraudOffset, this.installments, this.localizedShopperStatement, this.mcc, this.merchantAccount, this.merchantOrderReference, this.merchantRiskIndicator, this.metadata, this.orderReference, this.paymentMethod, this.recurring, this.recurringProcessingModel, this.reference, this.selectedBrand, this.selectedRecurringDetailReference, this.sessionId, this.shopperEmail, this.shopperIP, this.shopperInteraction, this.shopperLocale, this.shopperName, this.shopperReference, this.shopperStatement, this.socialSecurityNumber, this.splits, this.store, this.telephoneNumber, this.threeDS2RequestData, this.threeDSAuthenticationOnly, this.totalsGroup, this.trustedShopper});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BalanceCheckRequest {\n");
        sb.append("    accountInfo: ").append(this.toIndentedString(this.accountInfo)).append("\n");
        sb.append("    additionalAmount: ").append(this.toIndentedString(this.additionalAmount)).append("\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    applicationInfo: ").append(this.toIndentedString(this.applicationInfo)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    browserInfo: ").append(this.toIndentedString(this.browserInfo)).append("\n");
        sb.append("    captureDelayHours: ").append(this.toIndentedString(this.captureDelayHours)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    dccQuote: ").append(this.toIndentedString(this.dccQuote)).append("\n");
        sb.append("    deliveryAddress: ").append(this.toIndentedString(this.deliveryAddress)).append("\n");
        sb.append("    deliveryDate: ").append(this.toIndentedString(this.deliveryDate)).append("\n");
        sb.append("    deviceFingerprint: ").append(this.toIndentedString(this.deviceFingerprint)).append("\n");
        sb.append("    fraudOffset: ").append(this.toIndentedString(this.fraudOffset)).append("\n");
        sb.append("    installments: ").append(this.toIndentedString(this.installments)).append("\n");
        sb.append("    localizedShopperStatement: ").append(this.toIndentedString(this.localizedShopperStatement)).append("\n");
        sb.append("    mcc: ").append(this.toIndentedString(this.mcc)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    merchantOrderReference: ").append(this.toIndentedString(this.merchantOrderReference)).append("\n");
        sb.append("    merchantRiskIndicator: ").append(this.toIndentedString(this.merchantRiskIndicator)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    orderReference: ").append(this.toIndentedString(this.orderReference)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    recurring: ").append(this.toIndentedString(this.recurring)).append("\n");
        sb.append("    recurringProcessingModel: ").append(this.toIndentedString((Object)this.recurringProcessingModel)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    selectedBrand: ").append(this.toIndentedString(this.selectedBrand)).append("\n");
        sb.append("    selectedRecurringDetailReference: ").append(this.toIndentedString(this.selectedRecurringDetailReference)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperIP: ").append(this.toIndentedString(this.shopperIP)).append("\n");
        sb.append("    shopperInteraction: ").append(this.toIndentedString((Object)this.shopperInteraction)).append("\n");
        sb.append("    shopperLocale: ").append(this.toIndentedString(this.shopperLocale)).append("\n");
        sb.append("    shopperName: ").append(this.toIndentedString(this.shopperName)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    shopperStatement: ").append(this.toIndentedString(this.shopperStatement)).append("\n");
        sb.append("    socialSecurityNumber: ").append(this.toIndentedString(this.socialSecurityNumber)).append("\n");
        sb.append("    splits: ").append(this.toIndentedString(this.splits)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("    telephoneNumber: ").append(this.toIndentedString(this.telephoneNumber)).append("\n");
        sb.append("    threeDS2RequestData: ").append(this.toIndentedString(this.threeDS2RequestData)).append("\n");
        sb.append("    threeDSAuthenticationOnly: ").append(this.toIndentedString(this.threeDSAuthenticationOnly)).append("\n");
        sb.append("    totalsGroup: ").append(this.toIndentedString(this.totalsGroup)).append("\n");
        sb.append("    trustedShopper: ").append(this.toIndentedString(this.trustedShopper)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static BalanceCheckRequest fromJson(String jsonString) throws JsonProcessingException {
        return (BalanceCheckRequest)JSON.getMapper().readValue(jsonString, BalanceCheckRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ShopperInteractionEnum {
        ECOMMERCE(String.valueOf("Ecommerce")),
        CONTAUTH(String.valueOf("ContAuth")),
        MOTO(String.valueOf("Moto")),
        POS(String.valueOf("POS"));

        private static final Logger LOG;
        private String value;

        private ShopperInteractionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ShopperInteractionEnum fromValue(String value) {
            for (ShopperInteractionEnum b : ShopperInteractionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("ShopperInteractionEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])ShopperInteractionEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(ShopperInteractionEnum.class.getName());
        }
    }

    public static enum RecurringProcessingModelEnum {
        CARDONFILE(String.valueOf("CardOnFile")),
        SUBSCRIPTION(String.valueOf("Subscription")),
        UNSCHEDULEDCARDONFILE(String.valueOf("UnscheduledCardOnFile"));

        private static final Logger LOG;
        private String value;

        private RecurringProcessingModelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RecurringProcessingModelEnum fromValue(String value) {
            for (RecurringProcessingModelEnum b : RecurringProcessingModelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("RecurringProcessingModelEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])RecurringProcessingModelEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(RecurringProcessingModelEnum.class.getName());
        }
    }
}

