/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.adyen.model.balanceplatform.RepaymentTerm;
import com.adyen.model.balanceplatform.ThresholdRepayment;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

@JsonPropertyOrder(value={"basisPoints", "term", "threshold"})
public class Repayment {
    public static final String JSON_PROPERTY_BASIS_POINTS = "basisPoints";
    private Integer basisPoints;
    public static final String JSON_PROPERTY_TERM = "term";
    private RepaymentTerm term;
    public static final String JSON_PROPERTY_THRESHOLD = "threshold";
    private ThresholdRepayment threshold;

    public Repayment basisPoints(Integer basisPoints) {
        this.basisPoints = basisPoints;
        return this;
    }

    @JsonProperty(value="basisPoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getBasisPoints() {
        return this.basisPoints;
    }

    @JsonProperty(value="basisPoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBasisPoints(Integer basisPoints) {
        this.basisPoints = basisPoints;
    }

    public Repayment term(RepaymentTerm term) {
        this.term = term;
        return this;
    }

    @JsonProperty(value="term")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RepaymentTerm getTerm() {
        return this.term;
    }

    @JsonProperty(value="term")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTerm(RepaymentTerm term) {
        this.term = term;
    }

    public Repayment threshold(ThresholdRepayment threshold) {
        this.threshold = threshold;
        return this;
    }

    @JsonProperty(value="threshold")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThresholdRepayment getThreshold() {
        return this.threshold;
    }

    @JsonProperty(value="threshold")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreshold(ThresholdRepayment threshold) {
        this.threshold = threshold;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Repayment repayment = (Repayment)o;
        return Objects.equals(this.basisPoints, repayment.basisPoints) && Objects.equals(this.term, repayment.term) && Objects.equals(this.threshold, repayment.threshold);
    }

    public int hashCode() {
        return Objects.hash(this.basisPoints, this.term, this.threshold);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Repayment {\n");
        sb.append("    basisPoints: ").append(this.toIndentedString(this.basisPoints)).append("\n");
        sb.append("    term: ").append(this.toIndentedString(this.term)).append("\n");
        sb.append("    threshold: ").append(this.toIndentedString(this.threshold)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Repayment fromJson(String jsonString) throws JsonProcessingException {
        return (Repayment)JSON.getMapper().readValue(jsonString, Repayment.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

