/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.posterminalmanagement;

import com.adyen.model.posterminalmanagement.Address;
import com.adyen.model.posterminalmanagement.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"address", "description", "inStoreTerminals", "merchantAccountCode", "status", "store"})
public class Store {
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private Address address;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_IN_STORE_TERMINALS = "inStoreTerminals";
    private List<String> inStoreTerminals = null;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT_CODE = "merchantAccountCode";
    private String merchantAccountCode;
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;
    public static final String JSON_PROPERTY_STORE = "store";
    private String store;

    public Store address(Address address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(Address address) {
        this.address = address;
    }

    public Store description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the store.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public Store inStoreTerminals(List<String> inStoreTerminals) {
        this.inStoreTerminals = inStoreTerminals;
        return this;
    }

    public Store addInStoreTerminalsItem(String inStoreTerminalsItem) {
        if (this.inStoreTerminals == null) {
            this.inStoreTerminals = new ArrayList<String>();
        }
        this.inStoreTerminals.add(inStoreTerminalsItem);
        return this;
    }

    @ApiModelProperty(value="The list of terminals assigned to the store.")
    @JsonProperty(value="inStoreTerminals")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getInStoreTerminals() {
        return this.inStoreTerminals;
    }

    @JsonProperty(value="inStoreTerminals")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInStoreTerminals(List<String> inStoreTerminals) {
        this.inStoreTerminals = inStoreTerminals;
    }

    public Store merchantAccountCode(String merchantAccountCode) {
        this.merchantAccountCode = merchantAccountCode;
        return this;
    }

    @ApiModelProperty(value="The code of the merchant account.")
    @JsonProperty(value="merchantAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccountCode() {
        return this.merchantAccountCode;
    }

    @JsonProperty(value="merchantAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccountCode(String merchantAccountCode) {
        this.merchantAccountCode = merchantAccountCode;
    }

    public Store status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the store:  - `PreActive`: the store has been created, but not yet activated.   - `Active`: the store has been activated. This means you can process payments for this store.   - `Inactive`: the store is currently not active.   - `InactiveWithModifications`: the store is currently not active, but payment modifications such as refunds are possible.   - `Closed`: the store has been closed. ")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(String status) {
        this.status = status;
    }

    public Store store(String store) {
        this.store = store;
        return this;
    }

    @ApiModelProperty(required=true, value="The code of the store.")
    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStore() {
        return this.store;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStore(String store) {
        this.store = store;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Store store = (Store)o;
        return Objects.equals(this.address, store.address) && Objects.equals(this.description, store.description) && Objects.equals(this.inStoreTerminals, store.inStoreTerminals) && Objects.equals(this.merchantAccountCode, store.merchantAccountCode) && Objects.equals(this.status, store.status) && Objects.equals(this.store, store.store);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.description, this.inStoreTerminals, this.merchantAccountCode, this.status, this.store);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Store {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    inStoreTerminals: ").append(this.toIndentedString(this.inStoreTerminals)).append("\n");
        sb.append("    merchantAccountCode: ").append(this.toIndentedString(this.merchantAccountCode)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Store fromJson(String jsonString) throws JsonProcessingException {
        return (Store)JSON.getMapper().readValue(jsonString, Store.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

