/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.CapabilitySettings;
import com.adyen.model.legalentitymanagement.JSON;
import com.adyen.model.legalentitymanagement.SupportingEntityCapability;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"allowed", "allowedLevel", "allowedSettings", "requested", "requestedLevel", "requestedSettings", "transferInstruments", "verificationStatus"})
public class LegalEntityCapability {
    public static final String JSON_PROPERTY_ALLOWED = "allowed";
    private Boolean allowed;
    public static final String JSON_PROPERTY_ALLOWED_LEVEL = "allowedLevel";
    private AllowedLevelEnum allowedLevel;
    public static final String JSON_PROPERTY_ALLOWED_SETTINGS = "allowedSettings";
    private CapabilitySettings allowedSettings;
    public static final String JSON_PROPERTY_REQUESTED = "requested";
    private Boolean requested;
    public static final String JSON_PROPERTY_REQUESTED_LEVEL = "requestedLevel";
    private RequestedLevelEnum requestedLevel;
    public static final String JSON_PROPERTY_REQUESTED_SETTINGS = "requestedSettings";
    private CapabilitySettings requestedSettings;
    public static final String JSON_PROPERTY_TRANSFER_INSTRUMENTS = "transferInstruments";
    private List<SupportingEntityCapability> transferInstruments;
    public static final String JSON_PROPERTY_VERIFICATION_STATUS = "verificationStatus";
    private String verificationStatus;

    public LegalEntityCapability() {
    }

    @JsonCreator
    public LegalEntityCapability(@JsonProperty(value="allowed") Boolean allowed, @JsonProperty(value="allowedLevel") AllowedLevelEnum allowedLevel, @JsonProperty(value="requested") Boolean requested, @JsonProperty(value="requestedLevel") RequestedLevelEnum requestedLevel, @JsonProperty(value="transferInstruments") List<SupportingEntityCapability> transferInstruments, @JsonProperty(value="verificationStatus") String verificationStatus) {
        this();
        this.allowed = allowed;
        this.allowedLevel = allowedLevel;
        this.requested = requested;
        this.requestedLevel = requestedLevel;
        this.transferInstruments = transferInstruments;
        this.verificationStatus = verificationStatus;
    }

    @JsonProperty(value="allowed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowed() {
        return this.allowed;
    }

    @JsonProperty(value="allowedLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AllowedLevelEnum getAllowedLevel() {
        return this.allowedLevel;
    }

    public LegalEntityCapability allowedSettings(CapabilitySettings allowedSettings) {
        this.allowedSettings = allowedSettings;
        return this;
    }

    @JsonProperty(value="allowedSettings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CapabilitySettings getAllowedSettings() {
        return this.allowedSettings;
    }

    @JsonProperty(value="allowedSettings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowedSettings(CapabilitySettings allowedSettings) {
        this.allowedSettings = allowedSettings;
    }

    @JsonProperty(value="requested")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRequested() {
        return this.requested;
    }

    @JsonProperty(value="requestedLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RequestedLevelEnum getRequestedLevel() {
        return this.requestedLevel;
    }

    public LegalEntityCapability requestedSettings(CapabilitySettings requestedSettings) {
        this.requestedSettings = requestedSettings;
        return this;
    }

    @JsonProperty(value="requestedSettings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CapabilitySettings getRequestedSettings() {
        return this.requestedSettings;
    }

    @JsonProperty(value="requestedSettings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestedSettings(CapabilitySettings requestedSettings) {
        this.requestedSettings = requestedSettings;
    }

    @JsonProperty(value="transferInstruments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SupportingEntityCapability> getTransferInstruments() {
        return this.transferInstruments;
    }

    @JsonProperty(value="verificationStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVerificationStatus() {
        return this.verificationStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegalEntityCapability legalEntityCapability = (LegalEntityCapability)o;
        return Objects.equals(this.allowed, legalEntityCapability.allowed) && Objects.equals((Object)this.allowedLevel, (Object)legalEntityCapability.allowedLevel) && Objects.equals(this.allowedSettings, legalEntityCapability.allowedSettings) && Objects.equals(this.requested, legalEntityCapability.requested) && Objects.equals((Object)this.requestedLevel, (Object)legalEntityCapability.requestedLevel) && Objects.equals(this.requestedSettings, legalEntityCapability.requestedSettings) && Objects.equals(this.transferInstruments, legalEntityCapability.transferInstruments) && Objects.equals(this.verificationStatus, legalEntityCapability.verificationStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowed, this.allowedLevel, this.allowedSettings, this.requested, this.requestedLevel, this.requestedSettings, this.transferInstruments, this.verificationStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LegalEntityCapability {\n");
        sb.append("    allowed: ").append(this.toIndentedString(this.allowed)).append("\n");
        sb.append("    allowedLevel: ").append(this.toIndentedString((Object)this.allowedLevel)).append("\n");
        sb.append("    allowedSettings: ").append(this.toIndentedString(this.allowedSettings)).append("\n");
        sb.append("    requested: ").append(this.toIndentedString(this.requested)).append("\n");
        sb.append("    requestedLevel: ").append(this.toIndentedString((Object)this.requestedLevel)).append("\n");
        sb.append("    requestedSettings: ").append(this.toIndentedString(this.requestedSettings)).append("\n");
        sb.append("    transferInstruments: ").append(this.toIndentedString(this.transferInstruments)).append("\n");
        sb.append("    verificationStatus: ").append(this.toIndentedString(this.verificationStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static LegalEntityCapability fromJson(String jsonString) throws JsonProcessingException {
        return (LegalEntityCapability)JSON.getMapper().readValue(jsonString, LegalEntityCapability.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum RequestedLevelEnum {
        HIGH(String.valueOf("high")),
        LOW(String.valueOf("low")),
        MEDIUM(String.valueOf("medium")),
        NOTAPPLICABLE(String.valueOf("notApplicable"));

        private String value;

        private RequestedLevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RequestedLevelEnum fromValue(String value) {
            for (RequestedLevelEnum b : RequestedLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AllowedLevelEnum {
        HIGH(String.valueOf("high")),
        LOW(String.valueOf("low")),
        MEDIUM(String.valueOf("medium")),
        NOTAPPLICABLE(String.valueOf("notApplicable"));

        private String value;

        private AllowedLevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AllowedLevelEnum fromValue(String value) {
            for (AllowedLevelEnum b : AllowedLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

