/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balancecontrol;

import com.adyen.model.balancecontrol.Amount;
import com.adyen.model.balancecontrol.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "description", "fromMerchant", "reference", "toMerchant", "type"})
public class BalanceTransferRequest {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_FROM_MERCHANT = "fromMerchant";
    private String fromMerchant;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_TO_MERCHANT = "toMerchant";
    private String toMerchant;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public BalanceTransferRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public BalanceTransferRequest description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public BalanceTransferRequest fromMerchant(String fromMerchant) {
        this.fromMerchant = fromMerchant;
        return this;
    }

    @JsonProperty(value="fromMerchant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFromMerchant() {
        return this.fromMerchant;
    }

    @JsonProperty(value="fromMerchant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFromMerchant(String fromMerchant) {
        this.fromMerchant = fromMerchant;
    }

    public BalanceTransferRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public BalanceTransferRequest toMerchant(String toMerchant) {
        this.toMerchant = toMerchant;
        return this;
    }

    @JsonProperty(value="toMerchant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getToMerchant() {
        return this.toMerchant;
    }

    @JsonProperty(value="toMerchant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setToMerchant(String toMerchant) {
        this.toMerchant = toMerchant;
    }

    public BalanceTransferRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalanceTransferRequest balanceTransferRequest = (BalanceTransferRequest)o;
        return Objects.equals(this.amount, balanceTransferRequest.amount) && Objects.equals(this.description, balanceTransferRequest.description) && Objects.equals(this.fromMerchant, balanceTransferRequest.fromMerchant) && Objects.equals(this.reference, balanceTransferRequest.reference) && Objects.equals(this.toMerchant, balanceTransferRequest.toMerchant) && Objects.equals((Object)this.type, (Object)balanceTransferRequest.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.description, this.fromMerchant, this.reference, this.toMerchant, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BalanceTransferRequest {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    fromMerchant: ").append(this.toIndentedString(this.fromMerchant)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    toMerchant: ").append(this.toIndentedString(this.toMerchant)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static BalanceTransferRequest fromJson(String jsonString) throws JsonProcessingException {
        return (BalanceTransferRequest)JSON.getMapper().readValue(jsonString, BalanceTransferRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        TAX(String.valueOf("tax")),
        FEE(String.valueOf("fee")),
        TERMINALSALE(String.valueOf("terminalSale")),
        CREDIT(String.valueOf("credit")),
        DEBIT(String.valueOf("debit")),
        ADJUSTMENT(String.valueOf("adjustment"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

