/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.AccountHolderNotificationRequest;
import com.adyen.model.configurationwebhooks.BalanceAccountNotificationRequest;
import com.adyen.model.configurationwebhooks.CardOrderNotificationRequest;
import com.adyen.model.configurationwebhooks.JSON;
import com.adyen.model.configurationwebhooks.PaymentNotificationRequest;
import com.adyen.model.configurationwebhooks.SweepConfigurationNotificationRequest;
import java.util.Optional;
import java.util.logging.Logger;

public class ConfigurationWebhooksHandler {
    private static final Logger LOG = Logger.getLogger(ConfigurationWebhooksHandler.class.getName());
    private final String payload;

    public ConfigurationWebhooksHandler(String payload) {
        this.payload = payload;
    }

    public Optional<AccountHolderNotificationRequest> getAccountHolderNotificationRequest() {
        return this.getOptionalField(AccountHolderNotificationRequest.class);
    }

    public Optional<BalanceAccountNotificationRequest> getBalanceAccountNotificationRequest() {
        return this.getOptionalField(BalanceAccountNotificationRequest.class);
    }

    public Optional<CardOrderNotificationRequest> getCardOrderNotificationRequest() {
        return this.getOptionalField(CardOrderNotificationRequest.class);
    }

    public Optional<PaymentNotificationRequest> getPaymentNotificationRequest() {
        return this.getOptionalField(PaymentNotificationRequest.class);
    }

    public Optional<SweepConfigurationNotificationRequest> getSweepConfigurationNotificationRequest() {
        return this.getOptionalField(SweepConfigurationNotificationRequest.class);
    }

    private <T> Optional<T> getOptionalField(Class<T> clazz) {
        try {
            Object val = JSON.getMapper().readValue(this.payload, clazz);
            return Optional.ofNullable(val);
        }
        catch (Exception e) {
            LOG.warning("Object not found or unexpected error trying to access:  " + clazz.getName());
            LOG.warning("Deserialization error: " + e.getMessage());
            return Optional.empty();
        }
    }
}

