/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.Amount;
import com.adyen.model.transfers.AmountAdjustment;
import com.adyen.model.transfers.BalanceMutation;
import com.adyen.model.transfers.ExternalReason;
import com.adyen.model.transfers.JSON;
import com.adyen.model.transfers.Modification;
import com.adyen.model.transfers.TransferEventEventsDataInner;
import com.adyen.model.transfers.TransferEventTrackingData;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "amountAdjustments", "arn", "bookingDate", "estimatedArrivalTime", "eventsData", "externalReason", "id", "modification", "mutations", "originalAmount", "reason", "status", "trackingData", "transactionId", "type", "updateDate", "valueDate"})
public class TransferEvent {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_AMOUNT_ADJUSTMENTS = "amountAdjustments";
    private List<AmountAdjustment> amountAdjustments = new ArrayList<AmountAdjustment>();
    public static final String JSON_PROPERTY_ARN = "arn";
    private String arn;
    public static final String JSON_PROPERTY_BOOKING_DATE = "bookingDate";
    private OffsetDateTime bookingDate;
    public static final String JSON_PROPERTY_ESTIMATED_ARRIVAL_TIME = "estimatedArrivalTime";
    private OffsetDateTime estimatedArrivalTime;
    public static final String JSON_PROPERTY_EVENTS_DATA = "eventsData";
    private List<TransferEventEventsDataInner> eventsData = new ArrayList<TransferEventEventsDataInner>();
    public static final String JSON_PROPERTY_EXTERNAL_REASON = "externalReason";
    private ExternalReason externalReason;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_MODIFICATION = "modification";
    private Modification modification;
    public static final String JSON_PROPERTY_MUTATIONS = "mutations";
    private List<BalanceMutation> mutations = new ArrayList<BalanceMutation>();
    public static final String JSON_PROPERTY_ORIGINAL_AMOUNT = "originalAmount";
    private Amount originalAmount;
    public static final String JSON_PROPERTY_REASON = "reason";
    private ReasonEnum reason;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_TRACKING_DATA = "trackingData";
    private TransferEventTrackingData trackingData;
    public static final String JSON_PROPERTY_TRANSACTION_ID = "transactionId";
    private String transactionId;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_UPDATE_DATE = "updateDate";
    private OffsetDateTime updateDate;
    public static final String JSON_PROPERTY_VALUE_DATE = "valueDate";
    private OffsetDateTime valueDate;

    public TransferEvent amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public TransferEvent amountAdjustments(List<AmountAdjustment> amountAdjustments) {
        this.amountAdjustments = amountAdjustments;
        return this;
    }

    public TransferEvent addAmountAdjustmentsItem(AmountAdjustment amountAdjustmentsItem) {
        if (this.amountAdjustments == null) {
            this.amountAdjustments = new ArrayList<AmountAdjustment>();
        }
        this.amountAdjustments.add(amountAdjustmentsItem);
        return this;
    }

    @JsonProperty(value="amountAdjustments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AmountAdjustment> getAmountAdjustments() {
        return this.amountAdjustments;
    }

    @JsonProperty(value="amountAdjustments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmountAdjustments(List<AmountAdjustment> amountAdjustments) {
        this.amountAdjustments = amountAdjustments;
    }

    public TransferEvent arn(String arn) {
        this.arn = arn;
        return this;
    }

    @JsonProperty(value="arn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getArn() {
        return this.arn;
    }

    @JsonProperty(value="arn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setArn(String arn) {
        this.arn = arn;
    }

    public TransferEvent bookingDate(OffsetDateTime bookingDate) {
        this.bookingDate = bookingDate;
        return this;
    }

    @JsonProperty(value="bookingDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getBookingDate() {
        return this.bookingDate;
    }

    @JsonProperty(value="bookingDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBookingDate(OffsetDateTime bookingDate) {
        this.bookingDate = bookingDate;
    }

    public TransferEvent estimatedArrivalTime(OffsetDateTime estimatedArrivalTime) {
        this.estimatedArrivalTime = estimatedArrivalTime;
        return this;
    }

    @JsonProperty(value="estimatedArrivalTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getEstimatedArrivalTime() {
        return this.estimatedArrivalTime;
    }

    @JsonProperty(value="estimatedArrivalTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEstimatedArrivalTime(OffsetDateTime estimatedArrivalTime) {
        this.estimatedArrivalTime = estimatedArrivalTime;
    }

    public TransferEvent eventsData(List<TransferEventEventsDataInner> eventsData) {
        this.eventsData = eventsData;
        return this;
    }

    public TransferEvent addEventsDataItem(TransferEventEventsDataInner eventsDataItem) {
        if (this.eventsData == null) {
            this.eventsData = new ArrayList<TransferEventEventsDataInner>();
        }
        this.eventsData.add(eventsDataItem);
        return this;
    }

    @JsonProperty(value="eventsData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TransferEventEventsDataInner> getEventsData() {
        return this.eventsData;
    }

    @JsonProperty(value="eventsData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventsData(List<TransferEventEventsDataInner> eventsData) {
        this.eventsData = eventsData;
    }

    public TransferEvent externalReason(ExternalReason externalReason) {
        this.externalReason = externalReason;
        return this;
    }

    @JsonProperty(value="externalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ExternalReason getExternalReason() {
        return this.externalReason;
    }

    @JsonProperty(value="externalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalReason(ExternalReason externalReason) {
        this.externalReason = externalReason;
    }

    public TransferEvent id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public TransferEvent modification(Modification modification) {
        this.modification = modification;
        return this;
    }

    @JsonProperty(value="modification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Modification getModification() {
        return this.modification;
    }

    @JsonProperty(value="modification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModification(Modification modification) {
        this.modification = modification;
    }

    public TransferEvent mutations(List<BalanceMutation> mutations) {
        this.mutations = mutations;
        return this;
    }

    public TransferEvent addMutationsItem(BalanceMutation mutationsItem) {
        if (this.mutations == null) {
            this.mutations = new ArrayList<BalanceMutation>();
        }
        this.mutations.add(mutationsItem);
        return this;
    }

    @JsonProperty(value="mutations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<BalanceMutation> getMutations() {
        return this.mutations;
    }

    @JsonProperty(value="mutations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMutations(List<BalanceMutation> mutations) {
        this.mutations = mutations;
    }

    public TransferEvent originalAmount(Amount originalAmount) {
        this.originalAmount = originalAmount;
        return this;
    }

    @JsonProperty(value="originalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getOriginalAmount() {
        return this.originalAmount;
    }

    @JsonProperty(value="originalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOriginalAmount(Amount originalAmount) {
        this.originalAmount = originalAmount;
    }

    public TransferEvent reason(ReasonEnum reason) {
        this.reason = reason;
        return this;
    }

    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ReasonEnum getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReason(ReasonEnum reason) {
        this.reason = reason;
    }

    public TransferEvent status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public TransferEvent trackingData(TransferEventTrackingData trackingData) {
        this.trackingData = trackingData;
        return this;
    }

    @JsonProperty(value="trackingData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransferEventTrackingData getTrackingData() {
        return this.trackingData;
    }

    @JsonProperty(value="trackingData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTrackingData(TransferEventTrackingData trackingData) {
        this.trackingData = trackingData;
    }

    public TransferEvent transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @JsonProperty(value="transactionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTransactionId() {
        return this.transactionId;
    }

    @JsonProperty(value="transactionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public TransferEvent type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public TransferEvent updateDate(OffsetDateTime updateDate) {
        this.updateDate = updateDate;
        return this;
    }

    @JsonProperty(value="updateDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdateDate() {
        return this.updateDate;
    }

    @JsonProperty(value="updateDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdateDate(OffsetDateTime updateDate) {
        this.updateDate = updateDate;
    }

    public TransferEvent valueDate(OffsetDateTime valueDate) {
        this.valueDate = valueDate;
        return this;
    }

    @JsonProperty(value="valueDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getValueDate() {
        return this.valueDate;
    }

    @JsonProperty(value="valueDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValueDate(OffsetDateTime valueDate) {
        this.valueDate = valueDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferEvent transferEvent = (TransferEvent)o;
        return Objects.equals(this.amount, transferEvent.amount) && Objects.equals(this.amountAdjustments, transferEvent.amountAdjustments) && Objects.equals(this.arn, transferEvent.arn) && Objects.equals(this.bookingDate, transferEvent.bookingDate) && Objects.equals(this.estimatedArrivalTime, transferEvent.estimatedArrivalTime) && Objects.equals(this.eventsData, transferEvent.eventsData) && Objects.equals(this.externalReason, transferEvent.externalReason) && Objects.equals(this.id, transferEvent.id) && Objects.equals(this.modification, transferEvent.modification) && Objects.equals(this.mutations, transferEvent.mutations) && Objects.equals(this.originalAmount, transferEvent.originalAmount) && Objects.equals((Object)this.reason, (Object)transferEvent.reason) && Objects.equals((Object)this.status, (Object)transferEvent.status) && Objects.equals(this.trackingData, transferEvent.trackingData) && Objects.equals(this.transactionId, transferEvent.transactionId) && Objects.equals((Object)this.type, (Object)transferEvent.type) && Objects.equals(this.updateDate, transferEvent.updateDate) && Objects.equals(this.valueDate, transferEvent.valueDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.amountAdjustments, this.arn, this.bookingDate, this.estimatedArrivalTime, this.eventsData, this.externalReason, this.id, this.modification, this.mutations, this.originalAmount, this.reason, this.status, this.trackingData, this.transactionId, this.type, this.updateDate, this.valueDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferEvent {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    amountAdjustments: ").append(this.toIndentedString(this.amountAdjustments)).append("\n");
        sb.append("    arn: ").append(this.toIndentedString(this.arn)).append("\n");
        sb.append("    bookingDate: ").append(this.toIndentedString(this.bookingDate)).append("\n");
        sb.append("    estimatedArrivalTime: ").append(this.toIndentedString(this.estimatedArrivalTime)).append("\n");
        sb.append("    eventsData: ").append(this.toIndentedString(this.eventsData)).append("\n");
        sb.append("    externalReason: ").append(this.toIndentedString(this.externalReason)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    modification: ").append(this.toIndentedString(this.modification)).append("\n");
        sb.append("    mutations: ").append(this.toIndentedString(this.mutations)).append("\n");
        sb.append("    originalAmount: ").append(this.toIndentedString(this.originalAmount)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    trackingData: ").append(this.toIndentedString(this.trackingData)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    updateDate: ").append(this.toIndentedString(this.updateDate)).append("\n");
        sb.append("    valueDate: ").append(this.toIndentedString(this.valueDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TransferEvent fromJson(String jsonString) throws JsonProcessingException {
        return (TransferEvent)JSON.getMapper().readValue(jsonString, TransferEvent.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        ACCOUNTING(String.valueOf("accounting")),
        TRACKING(String.valueOf("tracking"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        APPROVALPENDING(String.valueOf("approvalPending")),
        ATMWITHDRAWAL(String.valueOf("atmWithdrawal")),
        ATMWITHDRAWALREVERSALPENDING(String.valueOf("atmWithdrawalReversalPending")),
        ATMWITHDRAWALREVERSED(String.valueOf("atmWithdrawalReversed")),
        AUTHADJUSTMENTAUTHORISED(String.valueOf("authAdjustmentAuthorised")),
        AUTHADJUSTMENTERROR(String.valueOf("authAdjustmentError")),
        AUTHADJUSTMENTREFUSED(String.valueOf("authAdjustmentRefused")),
        AUTHORISED(String.valueOf("authorised")),
        BANKTRANSFER(String.valueOf("bankTransfer")),
        BANKTRANSFERPENDING(String.valueOf("bankTransferPending")),
        BOOKED(String.valueOf("booked")),
        BOOKINGPENDING(String.valueOf("bookingPending")),
        CANCELLED(String.valueOf("cancelled")),
        CAPTUREPENDING(String.valueOf("capturePending")),
        CAPTUREREVERSALPENDING(String.valueOf("captureReversalPending")),
        CAPTUREREVERSED(String.valueOf("captureReversed")),
        CAPTURED(String.valueOf("captured")),
        CAPTUREDEXTERNALLY(String.valueOf("capturedExternally")),
        CHARGEBACK(String.valueOf("chargeback")),
        CHARGEBACKEXTERNALLY(String.valueOf("chargebackExternally")),
        CHARGEBACKPENDING(String.valueOf("chargebackPending")),
        CHARGEBACKREVERSALPENDING(String.valueOf("chargebackReversalPending")),
        CHARGEBACKREVERSED(String.valueOf("chargebackReversed")),
        CREDITED(String.valueOf("credited")),
        DEPOSITCORRECTION(String.valueOf("depositCorrection")),
        DEPOSITCORRECTIONPENDING(String.valueOf("depositCorrectionPending")),
        DISPUTE(String.valueOf("dispute")),
        DISPUTECLOSED(String.valueOf("disputeClosed")),
        DISPUTEEXPIRED(String.valueOf("disputeExpired")),
        DISPUTENEEDSREVIEW(String.valueOf("disputeNeedsReview")),
        ERROR(String.valueOf("error")),
        EXPIRED(String.valueOf("expired")),
        FAILED(String.valueOf("failed")),
        FEE(String.valueOf("fee")),
        FEEPENDING(String.valueOf("feePending")),
        INTERNALTRANSFER(String.valueOf("internalTransfer")),
        INTERNALTRANSFERPENDING(String.valueOf("internalTransferPending")),
        INVOICEDEDUCTION(String.valueOf("invoiceDeduction")),
        INVOICEDEDUCTIONPENDING(String.valueOf("invoiceDeductionPending")),
        MANUALCORRECTIONPENDING(String.valueOf("manualCorrectionPending")),
        MANUALLYCORRECTED(String.valueOf("manuallyCorrected")),
        MATCHEDSTATEMENT(String.valueOf("matchedStatement")),
        MATCHEDSTATEMENTPENDING(String.valueOf("matchedStatementPending")),
        MERCHANTPAYIN(String.valueOf("merchantPayin")),
        MERCHANTPAYINPENDING(String.valueOf("merchantPayinPending")),
        MERCHANTPAYINREVERSED(String.valueOf("merchantPayinReversed")),
        MERCHANTPAYINREVERSEDPENDING(String.valueOf("merchantPayinReversedPending")),
        MISCCOST(String.valueOf("miscCost")),
        MISCCOSTPENDING(String.valueOf("miscCostPending")),
        PAYMENTCOST(String.valueOf("paymentCost")),
        PAYMENTCOSTPENDING(String.valueOf("paymentCostPending")),
        PENDINGAPPROVAL(String.valueOf("pendingApproval")),
        PENDINGEXECUTION(String.valueOf("pendingExecution")),
        RECEIVED(String.valueOf("received")),
        REFUNDPENDING(String.valueOf("refundPending")),
        REFUNDREVERSALPENDING(String.valueOf("refundReversalPending")),
        REFUNDREVERSED(String.valueOf("refundReversed")),
        REFUNDED(String.valueOf("refunded")),
        REFUNDEDEXTERNALLY(String.valueOf("refundedExternally")),
        REFUSED(String.valueOf("refused")),
        REJECTED(String.valueOf("rejected")),
        RESERVEADJUSTMENT(String.valueOf("reserveAdjustment")),
        RESERVEADJUSTMENTPENDING(String.valueOf("reserveAdjustmentPending")),
        RETURNED(String.valueOf("returned")),
        SECONDCHARGEBACK(String.valueOf("secondChargeback")),
        SECONDCHARGEBACKPENDING(String.valueOf("secondChargebackPending")),
        UNDEFINED(String.valueOf("undefined"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ReasonEnum {
        ACCOUNTHIERARCHYNOTACTIVE(String.valueOf("accountHierarchyNotActive")),
        AMOUNTLIMITEXCEEDED(String.valueOf("amountLimitExceeded")),
        APPROVED(String.valueOf("approved")),
        BALANCEACCOUNTTEMPORARILYBLOCKEDBYTRANSACTIONRULE(String.valueOf("balanceAccountTemporarilyBlockedByTransactionRule")),
        COUNTERPARTYACCOUNTBLOCKED(String.valueOf("counterpartyAccountBlocked")),
        COUNTERPARTYACCOUNTCLOSED(String.valueOf("counterpartyAccountClosed")),
        COUNTERPARTYACCOUNTNOTFOUND(String.valueOf("counterpartyAccountNotFound")),
        COUNTERPARTYADDRESSREQUIRED(String.valueOf("counterpartyAddressRequired")),
        COUNTERPARTYBANKTIMEDOUT(String.valueOf("counterpartyBankTimedOut")),
        COUNTERPARTYBANKUNAVAILABLE(String.valueOf("counterpartyBankUnavailable")),
        DECLINED(String.valueOf("declined")),
        DECLINEDBYTRANSACTIONRULE(String.valueOf("declinedByTransactionRule")),
        DIRECTDEBITNOTSUPPORTED(String.valueOf("directDebitNotSupported")),
        ERROR(String.valueOf("error")),
        NOTENOUGHBALANCE(String.valueOf("notEnoughBalance")),
        PENDING(String.valueOf("pending")),
        PENDINGAPPROVAL(String.valueOf("pendingApproval")),
        PENDINGEXECUTION(String.valueOf("pendingExecution")),
        REFUSEDBYCOUNTERPARTYBANK(String.valueOf("refusedByCounterpartyBank")),
        REFUSEDBYCUSTOMER(String.valueOf("refusedByCustomer")),
        ROUTENOTFOUND(String.valueOf("routeNotFound")),
        SCAFAILED(String.valueOf("scaFailed")),
        TRANSFERINSTRUMENTDOESNOTEXIST(String.valueOf("transferInstrumentDoesNotExist")),
        UNKNOWN(String.valueOf("unknown"));

        private String value;

        private ReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReasonEnum fromValue(String value) {
            for (ReasonEnum b : ReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

