/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpaywebhooks;

import com.adyen.model.marketpaywebhooks.JSON;
import com.adyen.model.marketpaywebhooks.ViasAddress;
import com.adyen.model.marketpaywebhooks.ViasName;
import com.adyen.model.marketpaywebhooks.ViasPersonalData;
import com.adyen.model.marketpaywebhooks.ViasPhoneNumber;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"address", "email", "fullPhoneNumber", "jobTitle", "name", "personalData", "phoneNumber", "shareholderCode", "shareholderReference", "shareholderType", "webAddress"})
public class ShareholderContact {
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private ViasAddress address;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_FULL_PHONE_NUMBER = "fullPhoneNumber";
    private String fullPhoneNumber;
    public static final String JSON_PROPERTY_JOB_TITLE = "jobTitle";
    private String jobTitle;
    public static final String JSON_PROPERTY_NAME = "name";
    private ViasName name;
    public static final String JSON_PROPERTY_PERSONAL_DATA = "personalData";
    private ViasPersonalData personalData;
    public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
    private ViasPhoneNumber phoneNumber;
    public static final String JSON_PROPERTY_SHAREHOLDER_CODE = "shareholderCode";
    private String shareholderCode;
    public static final String JSON_PROPERTY_SHAREHOLDER_REFERENCE = "shareholderReference";
    private String shareholderReference;
    public static final String JSON_PROPERTY_SHAREHOLDER_TYPE = "shareholderType";
    private ShareholderTypeEnum shareholderType;
    public static final String JSON_PROPERTY_WEB_ADDRESS = "webAddress";
    private String webAddress;

    public ShareholderContact address(ViasAddress address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ViasAddress getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(ViasAddress address) {
        this.address = address;
    }

    public ShareholderContact email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="The e-mail address of the person.")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(String email) {
        this.email = email;
    }

    public ShareholderContact fullPhoneNumber(String fullPhoneNumber) {
        this.fullPhoneNumber = fullPhoneNumber;
        return this;
    }

    @ApiModelProperty(value="The phone number of the person provided as a single string.  It will be handled as a landline phone. Examples: \"0031 6 11 22 33 44\", \"+316/1122-3344\", \"(0031) 611223344\"")
    @JsonProperty(value="fullPhoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullPhoneNumber() {
        return this.fullPhoneNumber;
    }

    @JsonProperty(value="fullPhoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullPhoneNumber(String fullPhoneNumber) {
        this.fullPhoneNumber = fullPhoneNumber;
    }

    public ShareholderContact jobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
        return this;
    }

    @ApiModelProperty(value="Job title of the person. Required when the `shareholderType` is **Controller**.  Example values: **Chief Executive Officer**, **Chief Financial Officer**, **Chief Operating Officer**, **President**, **Vice President**, **Executive President**, **Managing Member**, **Partner**, **Treasurer**, **Director**, or **Other**.")
    @JsonProperty(value="jobTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getJobTitle() {
        return this.jobTitle;
    }

    @JsonProperty(value="jobTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public ShareholderContact name(ViasName name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ViasName getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(ViasName name) {
        this.name = name;
    }

    public ShareholderContact personalData(ViasPersonalData personalData) {
        this.personalData = personalData;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="personalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ViasPersonalData getPersonalData() {
        return this.personalData;
    }

    @JsonProperty(value="personalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPersonalData(ViasPersonalData personalData) {
        this.personalData = personalData;
    }

    public ShareholderContact phoneNumber(ViasPhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ViasPhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhoneNumber(ViasPhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public ShareholderContact shareholderCode(String shareholderCode) {
        this.shareholderCode = shareholderCode;
        return this;
    }

    @ApiModelProperty(value="The unique identifier (UUID) of the shareholder entry. >**If, during an Account Holder create or update request, this field is left blank (but other fields provided), a new Shareholder will be created with a procedurally-generated UUID.**  >**If, during an Account Holder create request, a UUID is provided, the creation of Account Holder will fail with a validation Error..**  >**If, during an Account Holder update request, a UUID that is not correlated with an existing Shareholder is provided, the update of the Shareholder will fail.**  >**If, during an Account Holder update request, a UUID that is correlated with an existing Shareholder is provided, the existing Shareholder will be updated.** ")
    @JsonProperty(value="shareholderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShareholderCode() {
        return this.shareholderCode;
    }

    @JsonProperty(value="shareholderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShareholderCode(String shareholderCode) {
        this.shareholderCode = shareholderCode;
    }

    public ShareholderContact shareholderReference(String shareholderReference) {
        this.shareholderReference = shareholderReference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the shareholder entry.")
    @JsonProperty(value="shareholderReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShareholderReference() {
        return this.shareholderReference;
    }

    @JsonProperty(value="shareholderReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShareholderReference(String shareholderReference) {
        this.shareholderReference = shareholderReference;
    }

    public ShareholderContact shareholderType(ShareholderTypeEnum shareholderType) {
        this.shareholderType = shareholderType;
        return this;
    }

    @ApiModelProperty(value="Specifies how the person is associated with the account holder.   Possible values:   * **Owner**: Individuals who directly or indirectly own 25% or more of a company.  * **Controller**: Individuals who are members of senior management staff responsible for managing a company or organization.")
    @JsonProperty(value="shareholderType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ShareholderTypeEnum getShareholderType() {
        return this.shareholderType;
    }

    @JsonProperty(value="shareholderType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShareholderType(ShareholderTypeEnum shareholderType) {
        this.shareholderType = shareholderType;
    }

    public ShareholderContact webAddress(String webAddress) {
        this.webAddress = webAddress;
        return this;
    }

    @ApiModelProperty(value="The URL of the person's website.")
    @JsonProperty(value="webAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWebAddress() {
        return this.webAddress;
    }

    @JsonProperty(value="webAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWebAddress(String webAddress) {
        this.webAddress = webAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShareholderContact shareholderContact = (ShareholderContact)o;
        return Objects.equals(this.address, shareholderContact.address) && Objects.equals(this.email, shareholderContact.email) && Objects.equals(this.fullPhoneNumber, shareholderContact.fullPhoneNumber) && Objects.equals(this.jobTitle, shareholderContact.jobTitle) && Objects.equals(this.name, shareholderContact.name) && Objects.equals(this.personalData, shareholderContact.personalData) && Objects.equals(this.phoneNumber, shareholderContact.phoneNumber) && Objects.equals(this.shareholderCode, shareholderContact.shareholderCode) && Objects.equals(this.shareholderReference, shareholderContact.shareholderReference) && Objects.equals((Object)this.shareholderType, (Object)shareholderContact.shareholderType) && Objects.equals(this.webAddress, shareholderContact.webAddress);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.email, this.fullPhoneNumber, this.jobTitle, this.name, this.personalData, this.phoneNumber, this.shareholderCode, this.shareholderReference, this.shareholderType, this.webAddress});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShareholderContact {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    fullPhoneNumber: ").append(this.toIndentedString(this.fullPhoneNumber)).append("\n");
        sb.append("    jobTitle: ").append(this.toIndentedString(this.jobTitle)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    personalData: ").append(this.toIndentedString(this.personalData)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    shareholderCode: ").append(this.toIndentedString(this.shareholderCode)).append("\n");
        sb.append("    shareholderReference: ").append(this.toIndentedString(this.shareholderReference)).append("\n");
        sb.append("    shareholderType: ").append(this.toIndentedString((Object)this.shareholderType)).append("\n");
        sb.append("    webAddress: ").append(this.toIndentedString(this.webAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ShareholderContact fromJson(String jsonString) throws JsonProcessingException {
        return (ShareholderContact)JSON.getMapper().readValue(jsonString, ShareholderContact.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ShareholderTypeEnum {
        CONTROLLER("Controller"),
        OWNER("Owner"),
        SIGNATORY("Signatory");

        private String value;

        private ShareholderTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ShareholderTypeEnum fromValue(String value) {
            for (ShareholderTypeEnum b : ShareholderTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

