/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.CapabilityProblem;
import com.adyen.model.legalentitymanagement.JSON;
import com.adyen.model.legalentitymanagement.SourceOfFunds;
import com.adyen.model.legalentitymanagement.WebData;
import com.adyen.model.legalentitymanagement.WebDataExemption;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"capability", "id", "industryCode", "legalEntityId", "problems", "salesChannels", "service", "sourceOfFunds", "webData", "webDataExemption"})
public class BusinessLine {
    public static final String JSON_PROPERTY_CAPABILITY = "capability";
    @Deprecated
    private CapabilityEnum capability;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_INDUSTRY_CODE = "industryCode";
    private String industryCode;
    public static final String JSON_PROPERTY_LEGAL_ENTITY_ID = "legalEntityId";
    private String legalEntityId;
    public static final String JSON_PROPERTY_PROBLEMS = "problems";
    private List<CapabilityProblem> problems = new ArrayList<CapabilityProblem>();
    public static final String JSON_PROPERTY_SALES_CHANNELS = "salesChannels";
    private List<String> salesChannels = new ArrayList<String>();
    public static final String JSON_PROPERTY_SERVICE = "service";
    private ServiceEnum service;
    public static final String JSON_PROPERTY_SOURCE_OF_FUNDS = "sourceOfFunds";
    private SourceOfFunds sourceOfFunds;
    public static final String JSON_PROPERTY_WEB_DATA = "webData";
    private List<WebData> webData = new ArrayList<WebData>();
    public static final String JSON_PROPERTY_WEB_DATA_EXEMPTION = "webDataExemption";
    private WebDataExemption webDataExemption;

    public BusinessLine() {
    }

    @JsonCreator
    public BusinessLine(@JsonProperty(value="id") String id) {
        this();
        this.id = id;
    }

    @Deprecated
    public BusinessLine capability(CapabilityEnum capability) {
        this.capability = capability;
        return this;
    }

    @Deprecated
    @JsonProperty(value="capability")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CapabilityEnum getCapability() {
        return this.capability;
    }

    @Deprecated
    @JsonProperty(value="capability")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCapability(CapabilityEnum capability) {
        this.capability = capability;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public BusinessLine industryCode(String industryCode) {
        this.industryCode = industryCode;
        return this;
    }

    @JsonProperty(value="industryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIndustryCode() {
        return this.industryCode;
    }

    @JsonProperty(value="industryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIndustryCode(String industryCode) {
        this.industryCode = industryCode;
    }

    public BusinessLine legalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
        return this;
    }

    @JsonProperty(value="legalEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalEntityId() {
        return this.legalEntityId;
    }

    @JsonProperty(value="legalEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
    }

    public BusinessLine problems(List<CapabilityProblem> problems) {
        this.problems = problems;
        return this;
    }

    public BusinessLine addProblemsItem(CapabilityProblem problemsItem) {
        if (this.problems == null) {
            this.problems = new ArrayList<CapabilityProblem>();
        }
        this.problems.add(problemsItem);
        return this;
    }

    @JsonProperty(value="problems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CapabilityProblem> getProblems() {
        return this.problems;
    }

    @JsonProperty(value="problems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProblems(List<CapabilityProblem> problems) {
        this.problems = problems;
    }

    public BusinessLine salesChannels(List<String> salesChannels) {
        this.salesChannels = salesChannels;
        return this;
    }

    public BusinessLine addSalesChannelsItem(String salesChannelsItem) {
        if (this.salesChannels == null) {
            this.salesChannels = new ArrayList<String>();
        }
        this.salesChannels.add(salesChannelsItem);
        return this;
    }

    @JsonProperty(value="salesChannels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSalesChannels() {
        return this.salesChannels;
    }

    @JsonProperty(value="salesChannels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSalesChannels(List<String> salesChannels) {
        this.salesChannels = salesChannels;
    }

    public BusinessLine service(ServiceEnum service) {
        this.service = service;
        return this;
    }

    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ServiceEnum getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setService(ServiceEnum service) {
        this.service = service;
    }

    public BusinessLine sourceOfFunds(SourceOfFunds sourceOfFunds) {
        this.sourceOfFunds = sourceOfFunds;
        return this;
    }

    @JsonProperty(value="sourceOfFunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SourceOfFunds getSourceOfFunds() {
        return this.sourceOfFunds;
    }

    @JsonProperty(value="sourceOfFunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceOfFunds(SourceOfFunds sourceOfFunds) {
        this.sourceOfFunds = sourceOfFunds;
    }

    public BusinessLine webData(List<WebData> webData) {
        this.webData = webData;
        return this;
    }

    public BusinessLine addWebDataItem(WebData webDataItem) {
        if (this.webData == null) {
            this.webData = new ArrayList<WebData>();
        }
        this.webData.add(webDataItem);
        return this;
    }

    @JsonProperty(value="webData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WebData> getWebData() {
        return this.webData;
    }

    @JsonProperty(value="webData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWebData(List<WebData> webData) {
        this.webData = webData;
    }

    public BusinessLine webDataExemption(WebDataExemption webDataExemption) {
        this.webDataExemption = webDataExemption;
        return this;
    }

    @JsonProperty(value="webDataExemption")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WebDataExemption getWebDataExemption() {
        return this.webDataExemption;
    }

    @JsonProperty(value="webDataExemption")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWebDataExemption(WebDataExemption webDataExemption) {
        this.webDataExemption = webDataExemption;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BusinessLine businessLine = (BusinessLine)o;
        return Objects.equals((Object)this.capability, (Object)businessLine.capability) && Objects.equals(this.id, businessLine.id) && Objects.equals(this.industryCode, businessLine.industryCode) && Objects.equals(this.legalEntityId, businessLine.legalEntityId) && Objects.equals(this.problems, businessLine.problems) && Objects.equals(this.salesChannels, businessLine.salesChannels) && Objects.equals((Object)this.service, (Object)businessLine.service) && Objects.equals(this.sourceOfFunds, businessLine.sourceOfFunds) && Objects.equals(this.webData, businessLine.webData) && Objects.equals(this.webDataExemption, businessLine.webDataExemption);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.capability, this.id, this.industryCode, this.legalEntityId, this.problems, this.salesChannels, this.service, this.sourceOfFunds, this.webData, this.webDataExemption});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BusinessLine {\n");
        sb.append("    capability: ").append(this.toIndentedString((Object)this.capability)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    industryCode: ").append(this.toIndentedString(this.industryCode)).append("\n");
        sb.append("    legalEntityId: ").append(this.toIndentedString(this.legalEntityId)).append("\n");
        sb.append("    problems: ").append(this.toIndentedString(this.problems)).append("\n");
        sb.append("    salesChannels: ").append(this.toIndentedString(this.salesChannels)).append("\n");
        sb.append("    service: ").append(this.toIndentedString((Object)this.service)).append("\n");
        sb.append("    sourceOfFunds: ").append(this.toIndentedString(this.sourceOfFunds)).append("\n");
        sb.append("    webData: ").append(this.toIndentedString(this.webData)).append("\n");
        sb.append("    webDataExemption: ").append(this.toIndentedString(this.webDataExemption)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static BusinessLine fromJson(String jsonString) throws JsonProcessingException {
        return (BusinessLine)JSON.getMapper().readValue(jsonString, BusinessLine.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ServiceEnum {
        PAYMENTPROCESSING(String.valueOf("paymentProcessing")),
        BANKING(String.valueOf("banking"));

        private String value;

        private ServiceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ServiceEnum fromValue(String value) {
            for (ServiceEnum b : ServiceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CapabilityEnum {
        RECEIVEPAYMENTS(String.valueOf("receivePayments")),
        RECEIVEFROMPLATFORMPAYMENTS(String.valueOf("receiveFromPlatformPayments")),
        ISSUEBANKACCOUNT(String.valueOf("issueBankAccount"));

        private String value;

        private CapabilityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CapabilityEnum fromValue(String value) {
            for (CapabilityEnum b : CapabilityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

