/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"currency", "donationType", "maxRoundupAmount", "values"})
public class Donation {
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency;
    public static final String JSON_PROPERTY_DONATION_TYPE = "donationType";
    private String donationType;
    public static final String JSON_PROPERTY_MAX_ROUNDUP_AMOUNT = "maxRoundupAmount";
    private Long maxRoundupAmount;
    public static final String JSON_PROPERTY_VALUES = "values";
    private List<Long> values;

    public Donation currency(String currency) {
        this.currency = currency;
        return this;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Donation donationType(String donationType) {
        this.donationType = donationType;
        return this;
    }

    @JsonProperty(value="donationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDonationType() {
        return this.donationType;
    }

    @JsonProperty(value="donationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDonationType(String donationType) {
        this.donationType = donationType;
    }

    public Donation maxRoundupAmount(Long maxRoundupAmount) {
        this.maxRoundupAmount = maxRoundupAmount;
        return this;
    }

    @JsonProperty(value="maxRoundupAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMaxRoundupAmount() {
        return this.maxRoundupAmount;
    }

    @JsonProperty(value="maxRoundupAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxRoundupAmount(Long maxRoundupAmount) {
        this.maxRoundupAmount = maxRoundupAmount;
    }

    public Donation values(List<Long> values) {
        this.values = values;
        return this;
    }

    public Donation addValuesItem(Long valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<Long>();
        }
        this.values.add(valuesItem);
        return this;
    }

    @JsonProperty(value="values")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Long> getValues() {
        return this.values;
    }

    @JsonProperty(value="values")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValues(List<Long> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Donation donation = (Donation)o;
        return Objects.equals(this.currency, donation.currency) && Objects.equals(this.donationType, donation.donationType) && Objects.equals(this.maxRoundupAmount, donation.maxRoundupAmount) && Objects.equals(this.values, donation.values);
    }

    public int hashCode() {
        return Objects.hash(this.currency, this.donationType, this.maxRoundupAmount, this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Donation {\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    donationType: ").append(this.toIndentedString(this.donationType)).append("\n");
        sb.append("    maxRoundupAmount: ").append(this.toIndentedString(this.maxRoundupAmount)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Donation fromJson(String jsonString) throws JsonProcessingException {
        return (Donation)JSON.getMapper().readValue(jsonString, Donation.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

