/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.SplitConfigurationLogic;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"currency", "fundingSource", "paymentMethod", "ruleId", "shopperInteraction", "splitLogic"})
public class SplitConfigurationRule {
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency;
    public static final String JSON_PROPERTY_FUNDING_SOURCE = "fundingSource";
    private FundingSourceEnum fundingSource;
    public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
    private String paymentMethod;
    public static final String JSON_PROPERTY_RULE_ID = "ruleId";
    private String ruleId;
    public static final String JSON_PROPERTY_SHOPPER_INTERACTION = "shopperInteraction";
    private ShopperInteractionEnum shopperInteraction;
    public static final String JSON_PROPERTY_SPLIT_LOGIC = "splitLogic";
    private SplitConfigurationLogic splitLogic;

    public SplitConfigurationRule currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="The currency condition that defines whether the split logic applies. Its value must be a three-character [ISO currency code](https://en.wikipedia.org/wiki/ISO_4217).")
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public SplitConfigurationRule fundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
        return this;
    }

    @ApiModelProperty(value="The funding source of the payment method. This only applies to card transactions.  Possible values: * **credit** * **debit** * **prepaid** * **deferred_debit** * **charged** * **ANY**")
    @JsonProperty(value="fundingSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FundingSourceEnum getFundingSource() {
        return this.fundingSource;
    }

    @JsonProperty(value="fundingSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
    }

    public SplitConfigurationRule paymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @ApiModelProperty(required=true, value="The payment method condition that defines whether the split logic applies.  Possible values: * [Payment method variant](https://docs.adyen.com/development-resources/paymentmethodvariant): Apply the split logic for a specific payment method. * **ANY**: Apply the split logic for all available payment methods.")
    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public SplitConfigurationRule ruleId(String ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the split configuration rule.")
    @JsonProperty(value="ruleId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRuleId() {
        return this.ruleId;
    }

    @JsonProperty(value="ruleId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public SplitConfigurationRule shopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
        return this;
    }

    @ApiModelProperty(required=true, value="The sales channel condition that defines whether the split logic applies.  Possible values: * **Ecommerce**: Online transactions where the cardholder is present. * **ContAuth**: Card on file and/or subscription transactions, where the cardholder is known to the merchant (returning customer). * **Moto**: Mail-order and telephone-order transactions where the customer is in contact with the merchant via email or telephone. * **POS**: Point-of-sale transactions where the customer is physically present to make a payment using a secure payment terminal. * **ANY**: All sales channels.")
    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ShopperInteractionEnum getShopperInteraction() {
        return this.shopperInteraction;
    }

    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
    }

    public SplitConfigurationRule splitLogic(SplitConfigurationLogic splitLogic) {
        this.splitLogic = splitLogic;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="splitLogic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SplitConfigurationLogic getSplitLogic() {
        return this.splitLogic;
    }

    @JsonProperty(value="splitLogic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSplitLogic(SplitConfigurationLogic splitLogic) {
        this.splitLogic = splitLogic;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SplitConfigurationRule splitConfigurationRule = (SplitConfigurationRule)o;
        return Objects.equals(this.currency, splitConfigurationRule.currency) && Objects.equals((Object)this.fundingSource, (Object)splitConfigurationRule.fundingSource) && Objects.equals(this.paymentMethod, splitConfigurationRule.paymentMethod) && Objects.equals(this.ruleId, splitConfigurationRule.ruleId) && Objects.equals((Object)this.shopperInteraction, (Object)splitConfigurationRule.shopperInteraction) && Objects.equals(this.splitLogic, splitConfigurationRule.splitLogic);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.currency, this.fundingSource, this.paymentMethod, this.ruleId, this.shopperInteraction, this.splitLogic});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SplitConfigurationRule {\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    fundingSource: ").append(this.toIndentedString((Object)this.fundingSource)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    ruleId: ").append(this.toIndentedString(this.ruleId)).append("\n");
        sb.append("    shopperInteraction: ").append(this.toIndentedString((Object)this.shopperInteraction)).append("\n");
        sb.append("    splitLogic: ").append(this.toIndentedString(this.splitLogic)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static SplitConfigurationRule fromJson(String jsonString) throws JsonProcessingException {
        return (SplitConfigurationRule)JSON.getMapper().readValue(jsonString, SplitConfigurationRule.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ShopperInteractionEnum {
        ECOMMERCE("Ecommerce"),
        CONTAUTH("ContAuth"),
        MOTO("Moto"),
        POS("POS"),
        ANY("ANY");

        private String value;

        private ShopperInteractionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ShopperInteractionEnum fromValue(String value) {
            for (ShopperInteractionEnum b : ShopperInteractionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FundingSourceEnum {
        CREDIT("credit"),
        DEBIT("debit"),
        ANY("ANY");

        private String value;

        private FundingSourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FundingSourceEnum fromValue(String value) {
            for (FundingSourceEnum b : FundingSourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

