/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.InputDetail;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.PaymentMethodGroup;
import com.adyen.model.checkout.PaymentMethodIssuer;
import com.adyen.model.checkout.PaymentMethodUPIApps;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"apps", "brand", "brands", "configuration", "fundingSource", "group", "inputDetails", "issuers", "name", "type"})
public class PaymentMethod {
    public static final String JSON_PROPERTY_APPS = "apps";
    private List<PaymentMethodUPIApps> apps = new ArrayList<PaymentMethodUPIApps>();
    public static final String JSON_PROPERTY_BRAND = "brand";
    private String brand;
    public static final String JSON_PROPERTY_BRANDS = "brands";
    private List<String> brands = new ArrayList<String>();
    public static final String JSON_PROPERTY_CONFIGURATION = "configuration";
    private Map<String, String> configuration = new HashMap<String, String>();
    public static final String JSON_PROPERTY_FUNDING_SOURCE = "fundingSource";
    private FundingSourceEnum fundingSource;
    public static final String JSON_PROPERTY_GROUP = "group";
    private PaymentMethodGroup group;
    public static final String JSON_PROPERTY_INPUT_DETAILS = "inputDetails";
    @Deprecated
    private List<InputDetail> inputDetails = new ArrayList<InputDetail>();
    public static final String JSON_PROPERTY_ISSUERS = "issuers";
    private List<PaymentMethodIssuer> issuers = new ArrayList<PaymentMethodIssuer>();
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public PaymentMethod apps(List<PaymentMethodUPIApps> apps) {
        this.apps = apps;
        return this;
    }

    public PaymentMethod addAppsItem(PaymentMethodUPIApps appsItem) {
        if (this.apps == null) {
            this.apps = new ArrayList<PaymentMethodUPIApps>();
        }
        this.apps.add(appsItem);
        return this;
    }

    @JsonProperty(value="apps")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PaymentMethodUPIApps> getApps() {
        return this.apps;
    }

    @JsonProperty(value="apps")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApps(List<PaymentMethodUPIApps> apps) {
        this.apps = apps;
    }

    public PaymentMethod brand(String brand) {
        this.brand = brand;
        return this;
    }

    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBrand() {
        return this.brand;
    }

    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrand(String brand) {
        this.brand = brand;
    }

    public PaymentMethod brands(List<String> brands) {
        this.brands = brands;
        return this;
    }

    public PaymentMethod addBrandsItem(String brandsItem) {
        if (this.brands == null) {
            this.brands = new ArrayList<String>();
        }
        this.brands.add(brandsItem);
        return this;
    }

    @JsonProperty(value="brands")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getBrands() {
        return this.brands;
    }

    @JsonProperty(value="brands")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrands(List<String> brands) {
        this.brands = brands;
    }

    public PaymentMethod configuration(Map<String, String> configuration) {
        this.configuration = configuration;
        return this;
    }

    public PaymentMethod putConfigurationItem(String key, String configurationItem) {
        if (this.configuration == null) {
            this.configuration = new HashMap<String, String>();
        }
        this.configuration.put(key, configurationItem);
        return this;
    }

    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    public PaymentMethod fundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
        return this;
    }

    @JsonProperty(value="fundingSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FundingSourceEnum getFundingSource() {
        return this.fundingSource;
    }

    @JsonProperty(value="fundingSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
    }

    public PaymentMethod group(PaymentMethodGroup group) {
        this.group = group;
        return this;
    }

    @JsonProperty(value="group")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentMethodGroup getGroup() {
        return this.group;
    }

    @JsonProperty(value="group")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroup(PaymentMethodGroup group) {
        this.group = group;
    }

    @Deprecated
    public PaymentMethod inputDetails(List<InputDetail> inputDetails) {
        this.inputDetails = inputDetails;
        return this;
    }

    public PaymentMethod addInputDetailsItem(InputDetail inputDetailsItem) {
        if (this.inputDetails == null) {
            this.inputDetails = new ArrayList<InputDetail>();
        }
        this.inputDetails.add(inputDetailsItem);
        return this;
    }

    @Deprecated
    @JsonProperty(value="inputDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<InputDetail> getInputDetails() {
        return this.inputDetails;
    }

    @Deprecated
    @JsonProperty(value="inputDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInputDetails(List<InputDetail> inputDetails) {
        this.inputDetails = inputDetails;
    }

    public PaymentMethod issuers(List<PaymentMethodIssuer> issuers) {
        this.issuers = issuers;
        return this;
    }

    public PaymentMethod addIssuersItem(PaymentMethodIssuer issuersItem) {
        if (this.issuers == null) {
            this.issuers = new ArrayList<PaymentMethodIssuer>();
        }
        this.issuers.add(issuersItem);
        return this;
    }

    @JsonProperty(value="issuers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PaymentMethodIssuer> getIssuers() {
        return this.issuers;
    }

    @JsonProperty(value="issuers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuers(List<PaymentMethodIssuer> issuers) {
        this.issuers = issuers;
    }

    public PaymentMethod name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public PaymentMethod type(String type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethod paymentMethod = (PaymentMethod)o;
        return Objects.equals(this.apps, paymentMethod.apps) && Objects.equals(this.brand, paymentMethod.brand) && Objects.equals(this.brands, paymentMethod.brands) && Objects.equals(this.configuration, paymentMethod.configuration) && Objects.equals((Object)this.fundingSource, (Object)paymentMethod.fundingSource) && Objects.equals(this.group, paymentMethod.group) && Objects.equals(this.inputDetails, paymentMethod.inputDetails) && Objects.equals(this.issuers, paymentMethod.issuers) && Objects.equals(this.name, paymentMethod.name) && Objects.equals(this.type, paymentMethod.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apps, this.brand, this.brands, this.configuration, this.fundingSource, this.group, this.inputDetails, this.issuers, this.name, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentMethod {\n");
        sb.append("    apps: ").append(this.toIndentedString(this.apps)).append("\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    brands: ").append(this.toIndentedString(this.brands)).append("\n");
        sb.append("    configuration: ").append(this.toIndentedString(this.configuration)).append("\n");
        sb.append("    fundingSource: ").append(this.toIndentedString((Object)this.fundingSource)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    inputDetails: ").append(this.toIndentedString(this.inputDetails)).append("\n");
        sb.append("    issuers: ").append(this.toIndentedString(this.issuers)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentMethod fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentMethod)JSON.getMapper().readValue(jsonString, PaymentMethod.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum FundingSourceEnum {
        CREDIT(String.valueOf("credit")),
        DEBIT(String.valueOf("debit"));

        private String value;

        private FundingSourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FundingSourceEnum fromValue(String value) {
            for (FundingSourceEnum b : FundingSourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

