/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.adyen.model.marketpayaccount.KYCCheckStatusData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"checks", "legalArrangementCode"})
public class KYCLegalArrangementCheckResult {
    public static final String JSON_PROPERTY_CHECKS = "checks";
    private List<KYCCheckStatusData> checks = null;
    public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_CODE = "legalArrangementCode";
    private String legalArrangementCode;

    public KYCLegalArrangementCheckResult checks(List<KYCCheckStatusData> checks) {
        this.checks = checks;
        return this;
    }

    public KYCLegalArrangementCheckResult addChecksItem(KYCCheckStatusData checksItem) {
        if (this.checks == null) {
            this.checks = new ArrayList<KYCCheckStatusData>();
        }
        this.checks.add(checksItem);
        return this;
    }

    @ApiModelProperty(value="A list of the checks and their statuses.")
    @JsonProperty(value="checks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<KYCCheckStatusData> getChecks() {
        return this.checks;
    }

    @JsonProperty(value="checks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChecks(List<KYCCheckStatusData> checks) {
        this.checks = checks;
    }

    public KYCLegalArrangementCheckResult legalArrangementCode(String legalArrangementCode) {
        this.legalArrangementCode = legalArrangementCode;
        return this;
    }

    @ApiModelProperty(value="The unique ID of the legal arrangement to which the check applies.")
    @JsonProperty(value="legalArrangementCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalArrangementCode() {
        return this.legalArrangementCode;
    }

    @JsonProperty(value="legalArrangementCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalArrangementCode(String legalArrangementCode) {
        this.legalArrangementCode = legalArrangementCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KYCLegalArrangementCheckResult kyCLegalArrangementCheckResult = (KYCLegalArrangementCheckResult)o;
        return Objects.equals(this.checks, kyCLegalArrangementCheckResult.checks) && Objects.equals(this.legalArrangementCode, kyCLegalArrangementCheckResult.legalArrangementCode);
    }

    public int hashCode() {
        return Objects.hash(this.checks, this.legalArrangementCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KYCLegalArrangementCheckResult {\n");
        sb.append("    checks: ").append(this.toIndentedString(this.checks)).append("\n");
        sb.append("    legalArrangementCode: ").append(this.toIndentedString(this.legalArrangementCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static KYCLegalArrangementCheckResult fromJson(String jsonString) throws JsonProcessingException {
        return (KYCLegalArrangementCheckResult)JSON.getMapper().readValue(jsonString, KYCLegalArrangementCheckResult.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

