/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"currency", "fundingSource", "paymentMethod", "shopperInteraction"})
public class UpdateSplitConfigurationRuleRequest {
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency;
    public static final String JSON_PROPERTY_FUNDING_SOURCE = "fundingSource";
    private String fundingSource;
    public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
    private String paymentMethod;
    public static final String JSON_PROPERTY_SHOPPER_INTERACTION = "shopperInteraction";
    private String shopperInteraction;

    public UpdateSplitConfigurationRuleRequest currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="The currency condition that defines whether the split logic applies. Its value must be a three-character [ISO currency code](https://en.wikipedia.org/wiki/ISO_4217).")
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public UpdateSplitConfigurationRuleRequest fundingSource(String fundingSource) {
        this.fundingSource = fundingSource;
        return this;
    }

    @ApiModelProperty(value="The funding source of the payment method. This only applies to card transactions.  Possible values: * **credit** * **debit** * **prepaid** * **deferred_debit** * **charged** * **ANY**")
    @JsonProperty(value="fundingSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFundingSource() {
        return this.fundingSource;
    }

    @JsonProperty(value="fundingSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundingSource(String fundingSource) {
        this.fundingSource = fundingSource;
    }

    public UpdateSplitConfigurationRuleRequest paymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @ApiModelProperty(required=true, value="The payment method condition that defines whether the split logic applies.  Possible values: * [Payment method variant](https://docs.adyen.com/development-resources/paymentmethodvariant): Apply the split logic for a specific payment method. * **ANY**: Apply the split logic for all available payment methods.")
    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public UpdateSplitConfigurationRuleRequest shopperInteraction(String shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
        return this;
    }

    @ApiModelProperty(required=true, value="The sales channel condition that defines whether the split logic applies.  Possible values: * **Ecommerce**: Online transactions where the cardholder is present. * **ContAuth**: Card on file and/or subscription transactions, where the cardholder is known to the merchant (returning customer). * **Moto**: Mail-order and telephone-order transactions where the customer is in contact with the merchant via email or telephone. * **POS**: Point-of-sale transactions where the customer is physically present to make a payment using a secure payment terminal. * **ANY**: All sales channels.")
    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperInteraction() {
        return this.shopperInteraction;
    }

    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperInteraction(String shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateSplitConfigurationRuleRequest updateSplitConfigurationRuleRequest = (UpdateSplitConfigurationRuleRequest)o;
        return Objects.equals(this.currency, updateSplitConfigurationRuleRequest.currency) && Objects.equals(this.fundingSource, updateSplitConfigurationRuleRequest.fundingSource) && Objects.equals(this.paymentMethod, updateSplitConfigurationRuleRequest.paymentMethod) && Objects.equals(this.shopperInteraction, updateSplitConfigurationRuleRequest.shopperInteraction);
    }

    public int hashCode() {
        return Objects.hash(this.currency, this.fundingSource, this.paymentMethod, this.shopperInteraction);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateSplitConfigurationRuleRequest {\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    fundingSource: ").append(this.toIndentedString(this.fundingSource)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    shopperInteraction: ").append(this.toIndentedString(this.shopperInteraction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static UpdateSplitConfigurationRuleRequest fromJson(String jsonString) throws JsonProcessingException {
        return (UpdateSplitConfigurationRuleRequest)JSON.getMapper().readValue(jsonString, UpdateSplitConfigurationRuleRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

