/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.ApplicationInfo;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.LineItem;
import com.adyen.model.checkout.PlatformChargebackLogic;
import com.adyen.model.checkout.Split;
import com.adyen.model.checkout.SubMerchantInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "applicationInfo", "lineItems", "merchantAccount", "platformChargebackLogic", "reference", "splits", "subMerchants"})
public class PaymentCaptureRequest {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_APPLICATION_INFO = "applicationInfo";
    private ApplicationInfo applicationInfo;
    public static final String JSON_PROPERTY_LINE_ITEMS = "lineItems";
    private List<LineItem> lineItems = null;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC = "platformChargebackLogic";
    private PlatformChargebackLogic platformChargebackLogic;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_SPLITS = "splits";
    private List<Split> splits = null;
    public static final String JSON_PROPERTY_SUB_MERCHANTS = "subMerchants";
    private List<SubMerchantInfo> subMerchants = null;

    public PaymentCaptureRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public PaymentCaptureRequest applicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="applicationInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    @JsonProperty(value="applicationInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
    }

    public PaymentCaptureRequest lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public PaymentCaptureRequest addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(value="Price and product information of the refunded items, required for [partial refunds](https://docs.adyen.com/online-payments/refund#refund-a-payment). > This field is required for partial refunds with 3x 4x Oney, Affirm, Afterpay, Atome, Clearpay, Klarna, Ratepay, Walley, and Zip.")
    @JsonProperty(value="lineItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    @JsonProperty(value="lineItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public PaymentCaptureRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account that is used to process the payment.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public PaymentCaptureRequest platformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
        this.platformChargebackLogic = platformChargebackLogic;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="platformChargebackLogic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PlatformChargebackLogic getPlatformChargebackLogic() {
        return this.platformChargebackLogic;
    }

    @JsonProperty(value="platformChargebackLogic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlatformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
        this.platformChargebackLogic = platformChargebackLogic;
    }

    public PaymentCaptureRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the capture request. Maximum length: 80 characters.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public PaymentCaptureRequest splits(List<Split> splits) {
        this.splits = splits;
        return this;
    }

    public PaymentCaptureRequest addSplitsItem(Split splitsItem) {
        if (this.splits == null) {
            this.splits = new ArrayList<Split>();
        }
        this.splits.add(splitsItem);
        return this;
    }

    @ApiModelProperty(value="An array of objects specifying how the amount should be split between accounts when using Adyen for Platforms. For more information, see how to process payments for [marketplaces](https://docs.adyen.com/marketplaces/split-payments) or [platforms](https://docs.adyen.com/platforms/online-payments/split-payments/).")
    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Split> getSplits() {
        return this.splits;
    }

    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public PaymentCaptureRequest subMerchants(List<SubMerchantInfo> subMerchants) {
        this.subMerchants = subMerchants;
        return this;
    }

    public PaymentCaptureRequest addSubMerchantsItem(SubMerchantInfo subMerchantsItem) {
        if (this.subMerchants == null) {
            this.subMerchants = new ArrayList<SubMerchantInfo>();
        }
        this.subMerchants.add(subMerchantsItem);
        return this;
    }

    @ApiModelProperty(value="A List of sub-merchants.")
    @JsonProperty(value="subMerchants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubMerchantInfo> getSubMerchants() {
        return this.subMerchants;
    }

    @JsonProperty(value="subMerchants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubMerchants(List<SubMerchantInfo> subMerchants) {
        this.subMerchants = subMerchants;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentCaptureRequest paymentCaptureRequest = (PaymentCaptureRequest)o;
        return Objects.equals(this.amount, paymentCaptureRequest.amount) && Objects.equals(this.applicationInfo, paymentCaptureRequest.applicationInfo) && Objects.equals(this.lineItems, paymentCaptureRequest.lineItems) && Objects.equals(this.merchantAccount, paymentCaptureRequest.merchantAccount) && Objects.equals(this.platformChargebackLogic, paymentCaptureRequest.platformChargebackLogic) && Objects.equals(this.reference, paymentCaptureRequest.reference) && Objects.equals(this.splits, paymentCaptureRequest.splits) && Objects.equals(this.subMerchants, paymentCaptureRequest.subMerchants);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.applicationInfo, this.lineItems, this.merchantAccount, this.platformChargebackLogic, this.reference, this.splits, this.subMerchants);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentCaptureRequest {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    applicationInfo: ").append(this.toIndentedString(this.applicationInfo)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    platformChargebackLogic: ").append(this.toIndentedString(this.platformChargebackLogic)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    splits: ").append(this.toIndentedString(this.splits)).append("\n");
        sb.append("    subMerchants: ").append(this.toIndentedString(this.subMerchants)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentCaptureRequest fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentCaptureRequest)JSON.getMapper().readValue(jsonString, PaymentCaptureRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

