/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"additionalSalesChannels"})
public class CalculatePciStatusRequest {
    public static final String JSON_PROPERTY_ADDITIONAL_SALES_CHANNELS = "additionalSalesChannels";
    private List<AdditionalSalesChannelsEnum> additionalSalesChannels = null;

    public CalculatePciStatusRequest additionalSalesChannels(List<AdditionalSalesChannelsEnum> additionalSalesChannels) {
        this.additionalSalesChannels = additionalSalesChannels;
        return this;
    }

    public CalculatePciStatusRequest addAdditionalSalesChannelsItem(AdditionalSalesChannelsEnum additionalSalesChannelsItem) {
        if (this.additionalSalesChannels == null) {
            this.additionalSalesChannels = new ArrayList<AdditionalSalesChannelsEnum>();
        }
        this.additionalSalesChannels.add(additionalSalesChannelsItem);
        return this;
    }

    @ApiModelProperty(value="An array of additional sales channels to generate PCI questionnaires. Include the relevant sales channels if you need your user to sign PCI questionnaires. Not required if you [create stores](https://docs.adyen.com/platforms) and [add payment methods](https://docs.adyen.com/adyen-for-platforms-model) before you generate the questionnaires.  Possible values: *  **eCommerce** *  **pos** *  **ecomMoto** *  **posMoto**  ")
    @JsonProperty(value="additionalSalesChannels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AdditionalSalesChannelsEnum> getAdditionalSalesChannels() {
        return this.additionalSalesChannels;
    }

    @JsonProperty(value="additionalSalesChannels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalSalesChannels(List<AdditionalSalesChannelsEnum> additionalSalesChannels) {
        this.additionalSalesChannels = additionalSalesChannels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CalculatePciStatusRequest calculatePciStatusRequest = (CalculatePciStatusRequest)o;
        return Objects.equals(this.additionalSalesChannels, calculatePciStatusRequest.additionalSalesChannels);
    }

    public int hashCode() {
        return Objects.hash(this.additionalSalesChannels);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CalculatePciStatusRequest {\n");
        sb.append("    additionalSalesChannels: ").append(this.toIndentedString(this.additionalSalesChannels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CalculatePciStatusRequest fromJson(String jsonString) throws JsonProcessingException {
        return (CalculatePciStatusRequest)JSON.getMapper().readValue(jsonString, CalculatePciStatusRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum AdditionalSalesChannelsEnum {
        ECOMMERCE("eCommerce"),
        ECOMMOTO("ecomMoto"),
        POS("pos"),
        POSMOTO("posMoto");

        private String value;

        private AdditionalSalesChannelsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AdditionalSalesChannelsEnum fromValue(String value) {
            for (AdditionalSalesChannelsEnum b : AdditionalSalesChannelsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

