/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"identifier", "passphrase", "version"})
public class Key {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_PASSPHRASE = "passphrase";
    private String passphrase;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Integer version;

    public Key identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the shared key.")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Key passphrase(String passphrase) {
        this.passphrase = passphrase;
        return this;
    }

    @ApiModelProperty(value="The secure passphrase to protect the shared key.")
    @JsonProperty(value="passphrase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPassphrase() {
        return this.passphrase;
    }

    @JsonProperty(value="passphrase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public Key version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="The version number of the shared key.")
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(Integer version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key key = (Key)o;
        return Objects.equals(this.identifier, key.identifier) && Objects.equals(this.passphrase, key.passphrase) && Objects.equals(this.version, key.version);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.passphrase, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Key {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    passphrase: ").append(this.toIndentedString(this.passphrase)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Key fromJson(String jsonString) throws JsonProcessingException {
        return (Key)JSON.getMapper().readValue(jsonString, Key.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

