/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.AllowedOrigin;
import com.adyen.model.management.ApiCredentialLinks;
import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"_links", "active", "allowedIpAddresses", "allowedOrigins", "apiKey", "associatedMerchantAccounts", "clientKey", "description", "id", "password", "roles", "username"})
public class CreateCompanyApiCredentialResponse {
    public static final String JSON_PROPERTY_LINKS = "_links";
    private ApiCredentialLinks links;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    private Boolean active;
    public static final String JSON_PROPERTY_ALLOWED_IP_ADDRESSES = "allowedIpAddresses";
    private List<String> allowedIpAddresses = new ArrayList<String>();
    public static final String JSON_PROPERTY_ALLOWED_ORIGINS = "allowedOrigins";
    private List<AllowedOrigin> allowedOrigins = null;
    public static final String JSON_PROPERTY_API_KEY = "apiKey";
    private String apiKey;
    public static final String JSON_PROPERTY_ASSOCIATED_MERCHANT_ACCOUNTS = "associatedMerchantAccounts";
    private List<String> associatedMerchantAccounts = new ArrayList<String>();
    public static final String JSON_PROPERTY_CLIENT_KEY = "clientKey";
    private String clientKey;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password;
    public static final String JSON_PROPERTY_ROLES = "roles";
    private List<String> roles = new ArrayList<String>();
    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;

    public CreateCompanyApiCredentialResponse links(ApiCredentialLinks links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApiCredentialLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(ApiCredentialLinks links) {
        this.links = links;
    }

    public CreateCompanyApiCredentialResponse active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates if the API credential is enabled. Must be set to **true** to use the credential in your integration.")
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActive(Boolean active) {
        this.active = active;
    }

    public CreateCompanyApiCredentialResponse allowedIpAddresses(List<String> allowedIpAddresses) {
        this.allowedIpAddresses = allowedIpAddresses;
        return this;
    }

    public CreateCompanyApiCredentialResponse addAllowedIpAddressesItem(String allowedIpAddressesItem) {
        this.allowedIpAddresses.add(allowedIpAddressesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of IP addresses from which your client can make requests.  If the list is empty, we allow requests from any IP. If the list is not empty and we get a request from an IP which is not on the list, you get a security error.")
    @JsonProperty(value="allowedIpAddresses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAllowedIpAddresses() {
        return this.allowedIpAddresses;
    }

    @JsonProperty(value="allowedIpAddresses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowedIpAddresses(List<String> allowedIpAddresses) {
        this.allowedIpAddresses = allowedIpAddresses;
    }

    public CreateCompanyApiCredentialResponse allowedOrigins(List<AllowedOrigin> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    public CreateCompanyApiCredentialResponse addAllowedOriginsItem(AllowedOrigin allowedOriginsItem) {
        if (this.allowedOrigins == null) {
            this.allowedOrigins = new ArrayList<AllowedOrigin>();
        }
        this.allowedOrigins.add(allowedOriginsItem);
        return this;
    }

    @ApiModelProperty(value="List containing the [allowed origins](https://docs.adyen.com/development-resources/client-side-authentication#allowed-origins) linked to the API credential.")
    @JsonProperty(value="allowedOrigins")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AllowedOrigin> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    @JsonProperty(value="allowedOrigins")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowedOrigins(List<AllowedOrigin> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public CreateCompanyApiCredentialResponse apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @ApiModelProperty(required=true, value="The API key for the API credential that was created.")
    @JsonProperty(value="apiKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getApiKey() {
        return this.apiKey;
    }

    @JsonProperty(value="apiKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public CreateCompanyApiCredentialResponse associatedMerchantAccounts(List<String> associatedMerchantAccounts) {
        this.associatedMerchantAccounts = associatedMerchantAccounts;
        return this;
    }

    public CreateCompanyApiCredentialResponse addAssociatedMerchantAccountsItem(String associatedMerchantAccountsItem) {
        this.associatedMerchantAccounts.add(associatedMerchantAccountsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of merchant accounts that the API credential has access to.")
    @JsonProperty(value="associatedMerchantAccounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAssociatedMerchantAccounts() {
        return this.associatedMerchantAccounts;
    }

    @JsonProperty(value="associatedMerchantAccounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssociatedMerchantAccounts(List<String> associatedMerchantAccounts) {
        this.associatedMerchantAccounts = associatedMerchantAccounts;
    }

    public CreateCompanyApiCredentialResponse clientKey(String clientKey) {
        this.clientKey = clientKey;
        return this;
    }

    @ApiModelProperty(required=true, value="Public key used for [client-side authentication](https://docs.adyen.com/development-resources/client-side-authentication). The client key is required for Drop-in and Components integrations.")
    @JsonProperty(value="clientKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientKey() {
        return this.clientKey;
    }

    @JsonProperty(value="clientKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientKey(String clientKey) {
        this.clientKey = clientKey;
    }

    public CreateCompanyApiCredentialResponse description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of the API credential.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateCompanyApiCredentialResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier of the API credential.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public CreateCompanyApiCredentialResponse password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(required=true, value="The password for the API credential that was created.")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(String password) {
        this.password = password;
    }

    public CreateCompanyApiCredentialResponse roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public CreateCompanyApiCredentialResponse addRolesItem(String rolesItem) {
        this.roles.add(rolesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of [roles](https://docs.adyen.com/development-resources/api-credentials#roles-1) for the API credential.")
    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRoles() {
        return this.roles;
    }

    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public CreateCompanyApiCredentialResponse username(String username) {
        this.username = username;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the [API credential](https://docs.adyen.com/development-resources/api-credentials), for example **ws@Company.TestCompany**.")
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCompanyApiCredentialResponse createCompanyApiCredentialResponse = (CreateCompanyApiCredentialResponse)o;
        return Objects.equals(this.links, createCompanyApiCredentialResponse.links) && Objects.equals(this.active, createCompanyApiCredentialResponse.active) && Objects.equals(this.allowedIpAddresses, createCompanyApiCredentialResponse.allowedIpAddresses) && Objects.equals(this.allowedOrigins, createCompanyApiCredentialResponse.allowedOrigins) && Objects.equals(this.apiKey, createCompanyApiCredentialResponse.apiKey) && Objects.equals(this.associatedMerchantAccounts, createCompanyApiCredentialResponse.associatedMerchantAccounts) && Objects.equals(this.clientKey, createCompanyApiCredentialResponse.clientKey) && Objects.equals(this.description, createCompanyApiCredentialResponse.description) && Objects.equals(this.id, createCompanyApiCredentialResponse.id) && Objects.equals(this.password, createCompanyApiCredentialResponse.password) && Objects.equals(this.roles, createCompanyApiCredentialResponse.roles) && Objects.equals(this.username, createCompanyApiCredentialResponse.username);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.active, this.allowedIpAddresses, this.allowedOrigins, this.apiKey, this.associatedMerchantAccounts, this.clientKey, this.description, this.id, this.password, this.roles, this.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateCompanyApiCredentialResponse {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    allowedIpAddresses: ").append(this.toIndentedString(this.allowedIpAddresses)).append("\n");
        sb.append("    allowedOrigins: ").append(this.toIndentedString(this.allowedOrigins)).append("\n");
        sb.append("    apiKey: ").append(this.toIndentedString(this.apiKey)).append("\n");
        sb.append("    associatedMerchantAccounts: ").append(this.toIndentedString(this.associatedMerchantAccounts)).append("\n");
        sb.append("    clientKey: ").append(this.toIndentedString(this.clientKey)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CreateCompanyApiCredentialResponse fromJson(String jsonString) throws JsonProcessingException {
        return (CreateCompanyApiCredentialResponse)JSON.getMapper().readValue(jsonString, CreateCompanyApiCredentialResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

