/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.binlookup;

import com.adyen.model.binlookup.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"additionalData", "brands", "cardNumber", "merchantAccount", "recurringDetailReference", "shopperReference"})
public class ThreeDSAvailabilityRequest {
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData = null;
    public static final String JSON_PROPERTY_BRANDS = "brands";
    private List<String> brands = null;
    public static final String JSON_PROPERTY_CARD_NUMBER = "cardNumber";
    private String cardNumber;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
    private String recurringDetailReference;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;

    public ThreeDSAvailabilityRequest additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public ThreeDSAvailabilityRequest putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @ApiModelProperty(value="This field contains additional data, which may be required for a particular request.  The `additionalData` object consists of entries, each of which includes the key and value.")
    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public ThreeDSAvailabilityRequest brands(List<String> brands) {
        this.brands = brands;
        return this;
    }

    public ThreeDSAvailabilityRequest addBrandsItem(String brandsItem) {
        if (this.brands == null) {
            this.brands = new ArrayList<String>();
        }
        this.brands.add(brandsItem);
        return this;
    }

    @ApiModelProperty(value="List of brands.")
    @JsonProperty(value="brands")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getBrands() {
        return this.brands;
    }

    @JsonProperty(value="brands")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrands(List<String> brands) {
        this.brands = brands;
    }

    public ThreeDSAvailabilityRequest cardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
        return this;
    }

    @ApiModelProperty(value="Card number or BIN.")
    @JsonProperty(value="cardNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCardNumber() {
        return this.cardNumber;
    }

    @JsonProperty(value="cardNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public ThreeDSAvailabilityRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account identifier.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public ThreeDSAvailabilityRequest recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @ApiModelProperty(value="A recurring detail reference corresponding to a card.")
    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public ThreeDSAvailabilityRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(value="The shopper's reference to uniquely identify this shopper (e.g. user ID or account ID).")
    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreeDSAvailabilityRequest threeDSAvailabilityRequest = (ThreeDSAvailabilityRequest)o;
        return Objects.equals(this.additionalData, threeDSAvailabilityRequest.additionalData) && Objects.equals(this.brands, threeDSAvailabilityRequest.brands) && Objects.equals(this.cardNumber, threeDSAvailabilityRequest.cardNumber) && Objects.equals(this.merchantAccount, threeDSAvailabilityRequest.merchantAccount) && Objects.equals(this.recurringDetailReference, threeDSAvailabilityRequest.recurringDetailReference) && Objects.equals(this.shopperReference, threeDSAvailabilityRequest.shopperReference);
    }

    public int hashCode() {
        return Objects.hash(this.additionalData, this.brands, this.cardNumber, this.merchantAccount, this.recurringDetailReference, this.shopperReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ThreeDSAvailabilityRequest {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    brands: ").append(this.toIndentedString(this.brands)).append("\n");
        sb.append("    cardNumber: ").append(this.toIndentedString(this.cardNumber)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    recurringDetailReference: ").append(this.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ThreeDSAvailabilityRequest fromJson(String jsonString) throws JsonProcessingException {
        return (ThreeDSAvailabilityRequest)JSON.getMapper().readValue(jsonString, ThreeDSAvailabilityRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

