/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.Authentication;
import com.adyen.model.balanceplatform.CardConfiguration;
import com.adyen.model.balanceplatform.DeliveryContact;
import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"authentication", "brand", "brandVariant", "cardholderName", "configuration", "deliveryContact", "formFactor", "threeDSecure"})
public class CardInfo {
    public static final String JSON_PROPERTY_AUTHENTICATION = "authentication";
    private Authentication authentication;
    public static final String JSON_PROPERTY_BRAND = "brand";
    private String brand;
    public static final String JSON_PROPERTY_BRAND_VARIANT = "brandVariant";
    private String brandVariant;
    public static final String JSON_PROPERTY_CARDHOLDER_NAME = "cardholderName";
    private String cardholderName;
    public static final String JSON_PROPERTY_CONFIGURATION = "configuration";
    private CardConfiguration configuration;
    public static final String JSON_PROPERTY_DELIVERY_CONTACT = "deliveryContact";
    private DeliveryContact deliveryContact;
    public static final String JSON_PROPERTY_FORM_FACTOR = "formFactor";
    private FormFactorEnum formFactor;
    public static final String JSON_PROPERTY_THREE_D_SECURE = "threeDSecure";
    private String threeDSecure;

    public CardInfo authentication(Authentication authentication) {
        this.authentication = authentication;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="authentication")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Authentication getAuthentication() {
        return this.authentication;
    }

    @JsonProperty(value="authentication")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public CardInfo brand(String brand) {
        this.brand = brand;
        return this;
    }

    @ApiModelProperty(required=true, value="The brand of the physical or the virtual card. Possible values: **visa**, **mc**.")
    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBrand() {
        return this.brand;
    }

    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrand(String brand) {
        this.brand = brand;
    }

    public CardInfo brandVariant(String brandVariant) {
        this.brandVariant = brandVariant;
        return this;
    }

    @ApiModelProperty(required=true, value="The brand variant of the physical or the virtual card. For example, **visadebit** or **mcprepaid**. >Reach out to your Adyen contact to get the values relevant for your integration.")
    @JsonProperty(value="brandVariant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBrandVariant() {
        return this.brandVariant;
    }

    @JsonProperty(value="brandVariant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrandVariant(String brandVariant) {
        this.brandVariant = brandVariant;
    }

    public CardInfo cardholderName(String cardholderName) {
        this.cardholderName = cardholderName;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the cardholder.  Maximum length: 26 characters.")
    @JsonProperty(value="cardholderName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCardholderName() {
        return this.cardholderName;
    }

    @JsonProperty(value="cardholderName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCardholderName(String cardholderName) {
        this.cardholderName = cardholderName;
    }

    public CardInfo configuration(CardConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CardConfiguration getConfiguration() {
        return this.configuration;
    }

    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfiguration(CardConfiguration configuration) {
        this.configuration = configuration;
    }

    public CardInfo deliveryContact(DeliveryContact deliveryContact) {
        this.deliveryContact = deliveryContact;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="deliveryContact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DeliveryContact getDeliveryContact() {
        return this.deliveryContact;
    }

    @JsonProperty(value="deliveryContact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryContact(DeliveryContact deliveryContact) {
        this.deliveryContact = deliveryContact;
    }

    public CardInfo formFactor(FormFactorEnum formFactor) {
        this.formFactor = formFactor;
        return this;
    }

    @ApiModelProperty(required=true, value="The form factor of the card. Possible values: **virtual**, **physical**.")
    @JsonProperty(value="formFactor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FormFactorEnum getFormFactor() {
        return this.formFactor;
    }

    @JsonProperty(value="formFactor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormFactor(FormFactorEnum formFactor) {
        this.formFactor = formFactor;
    }

    public CardInfo threeDSecure(String threeDSecure) {
        this.threeDSecure = threeDSecure;
        return this;
    }

    @ApiModelProperty(value="Allocates a specific product range for either a physical or a virtual card. Possible values: **fullySupported**, **secureCorporate**. >Reach out to your Adyen contact to get the values relevant for your integration.")
    @JsonProperty(value="threeDSecure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDSecure() {
        return this.threeDSecure;
    }

    @JsonProperty(value="threeDSecure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSecure(String threeDSecure) {
        this.threeDSecure = threeDSecure;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardInfo cardInfo = (CardInfo)o;
        return Objects.equals(this.authentication, cardInfo.authentication) && Objects.equals(this.brand, cardInfo.brand) && Objects.equals(this.brandVariant, cardInfo.brandVariant) && Objects.equals(this.cardholderName, cardInfo.cardholderName) && Objects.equals(this.configuration, cardInfo.configuration) && Objects.equals(this.deliveryContact, cardInfo.deliveryContact) && Objects.equals((Object)this.formFactor, (Object)cardInfo.formFactor) && Objects.equals(this.threeDSecure, cardInfo.threeDSecure);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authentication, this.brand, this.brandVariant, this.cardholderName, this.configuration, this.deliveryContact, this.formFactor, this.threeDSecure});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CardInfo {\n");
        sb.append("    authentication: ").append(this.toIndentedString(this.authentication)).append("\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    brandVariant: ").append(this.toIndentedString(this.brandVariant)).append("\n");
        sb.append("    cardholderName: ").append(this.toIndentedString(this.cardholderName)).append("\n");
        sb.append("    configuration: ").append(this.toIndentedString(this.configuration)).append("\n");
        sb.append("    deliveryContact: ").append(this.toIndentedString(this.deliveryContact)).append("\n");
        sb.append("    formFactor: ").append(this.toIndentedString((Object)this.formFactor)).append("\n");
        sb.append("    threeDSecure: ").append(this.toIndentedString(this.threeDSecure)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CardInfo fromJson(String jsonString) throws JsonProcessingException {
        return (CardInfo)JSON.getMapper().readValue(jsonString, CardInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum FormFactorEnum {
        PHYSICAL("physical"),
        UNKNOWN("unknown"),
        VIRTUAL("virtual");

        private String value;

        private FormFactorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FormFactorEnum fromValue(String value) {
            for (FormFactorEnum b : FormFactorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

