/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"beneficiary", "bic", "downloadUrl", "iban", "paymentMethodType", "reference", "shopperEmail", "totalAmount", "type", "url"})
public class CheckoutBankTransferAction {
    public static final String JSON_PROPERTY_BENEFICIARY = "beneficiary";
    private String beneficiary;
    public static final String JSON_PROPERTY_BIC = "bic";
    private String bic;
    public static final String JSON_PROPERTY_DOWNLOAD_URL = "downloadUrl";
    private String downloadUrl;
    public static final String JSON_PROPERTY_IBAN = "iban";
    private String iban;
    public static final String JSON_PROPERTY_PAYMENT_METHOD_TYPE = "paymentMethodType";
    private String paymentMethodType;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
    private String shopperEmail;
    public static final String JSON_PROPERTY_TOTAL_AMOUNT = "totalAmount";
    private Amount totalAmount;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;

    public CheckoutBankTransferAction beneficiary(String beneficiary) {
        this.beneficiary = beneficiary;
        return this;
    }

    @ApiModelProperty(value="The name of the account holder.")
    @JsonProperty(value="beneficiary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBeneficiary() {
        return this.beneficiary;
    }

    @JsonProperty(value="beneficiary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBeneficiary(String beneficiary) {
        this.beneficiary = beneficiary;
    }

    public CheckoutBankTransferAction bic(String bic) {
        this.bic = bic;
        return this;
    }

    @ApiModelProperty(value="The BIC of the IBAN.")
    @JsonProperty(value="bic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBic() {
        return this.bic;
    }

    @JsonProperty(value="bic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBic(String bic) {
        this.bic = bic;
    }

    public CheckoutBankTransferAction downloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
        return this;
    }

    @ApiModelProperty(value="The url to download payment details with.")
    @JsonProperty(value="downloadUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    @JsonProperty(value="downloadUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public CheckoutBankTransferAction iban(String iban) {
        this.iban = iban;
        return this;
    }

    @ApiModelProperty(value="The IBAN of the bank transfer.")
    @JsonProperty(value="iban")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIban() {
        return this.iban;
    }

    @JsonProperty(value="iban")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIban(String iban) {
        this.iban = iban;
    }

    public CheckoutBankTransferAction paymentMethodType(String paymentMethodType) {
        this.paymentMethodType = paymentMethodType;
        return this;
    }

    @ApiModelProperty(value="Specifies the payment method.")
    @JsonProperty(value="paymentMethodType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentMethodType() {
        return this.paymentMethodType;
    }

    @JsonProperty(value="paymentMethodType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethodType(String paymentMethodType) {
        this.paymentMethodType = paymentMethodType;
    }

    public CheckoutBankTransferAction reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="The transfer reference.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public CheckoutBankTransferAction shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @ApiModelProperty(value="The e-mail of the shopper, included if an e-mail was sent to the shopper.")
    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public CheckoutBankTransferAction totalAmount(Amount totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="totalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getTotalAmount() {
        return this.totalAmount;
    }

    @JsonProperty(value="totalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalAmount(Amount totalAmount) {
        this.totalAmount = totalAmount;
    }

    public CheckoutBankTransferAction type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of the action.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CheckoutBankTransferAction url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="Specifies the URL to redirect to.")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckoutBankTransferAction checkoutBankTransferAction = (CheckoutBankTransferAction)o;
        return Objects.equals(this.beneficiary, checkoutBankTransferAction.beneficiary) && Objects.equals(this.bic, checkoutBankTransferAction.bic) && Objects.equals(this.downloadUrl, checkoutBankTransferAction.downloadUrl) && Objects.equals(this.iban, checkoutBankTransferAction.iban) && Objects.equals(this.paymentMethodType, checkoutBankTransferAction.paymentMethodType) && Objects.equals(this.reference, checkoutBankTransferAction.reference) && Objects.equals(this.shopperEmail, checkoutBankTransferAction.shopperEmail) && Objects.equals(this.totalAmount, checkoutBankTransferAction.totalAmount) && Objects.equals((Object)this.type, (Object)checkoutBankTransferAction.type) && Objects.equals(this.url, checkoutBankTransferAction.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.beneficiary, this.bic, this.downloadUrl, this.iban, this.paymentMethodType, this.reference, this.shopperEmail, this.totalAmount, this.type, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckoutBankTransferAction {\n");
        sb.append("    beneficiary: ").append(this.toIndentedString(this.beneficiary)).append("\n");
        sb.append("    bic: ").append(this.toIndentedString(this.bic)).append("\n");
        sb.append("    downloadUrl: ").append(this.toIndentedString(this.downloadUrl)).append("\n");
        sb.append("    iban: ").append(this.toIndentedString(this.iban)).append("\n");
        sb.append("    paymentMethodType: ").append(this.toIndentedString(this.paymentMethodType)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CheckoutBankTransferAction fromJson(String jsonString) throws JsonProcessingException {
        return (CheckoutBankTransferAction)JSON.getMapper().readValue(jsonString, CheckoutBankTransferAction.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        BANKTRANSFER("bankTransfer");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

