/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.recurring;

import com.adyen.model.recurring.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"cvc", "expiryMonth", "expiryYear", "holderName", "issueNumber", "number", "startMonth", "startYear"})
public class Card {
    public static final String JSON_PROPERTY_CVC = "cvc";
    private String cvc;
    public static final String JSON_PROPERTY_EXPIRY_MONTH = "expiryMonth";
    private String expiryMonth;
    public static final String JSON_PROPERTY_EXPIRY_YEAR = "expiryYear";
    private String expiryYear;
    public static final String JSON_PROPERTY_HOLDER_NAME = "holderName";
    private String holderName;
    public static final String JSON_PROPERTY_ISSUE_NUMBER = "issueNumber";
    private String issueNumber;
    public static final String JSON_PROPERTY_NUMBER = "number";
    private String number;
    public static final String JSON_PROPERTY_START_MONTH = "startMonth";
    private String startMonth;
    public static final String JSON_PROPERTY_START_YEAR = "startYear";
    private String startYear;

    public Card cvc(String cvc) {
        this.cvc = cvc;
        return this;
    }

    @ApiModelProperty(value="The [card verification code](https://docs.adyen.com/payments-fundamentals/payment-glossary#card-security-code-cvc-cvv-cid) (1-20 characters). Depending on the card brand, it is known also as: * CVV2/CVC2 \u2013 length: 3 digits * CID \u2013 length: 4 digits > If you are using [Client-Side Encryption](https://docs.adyen.com/classic-integration/cse-integration-ecommerce), the CVC code is present in the encrypted data. You must never post the card details to the server. > This field must be always present in a [one-click payment request](https://docs.adyen.com/classic-integration/recurring-payments). > When this value is returned in a response, it is always empty because it is not stored.")
    @JsonProperty(value="cvc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCvc() {
        return this.cvc;
    }

    @JsonProperty(value="cvc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCvc(String cvc) {
        this.cvc = cvc;
    }

    public Card expiryMonth(String expiryMonth) {
        this.expiryMonth = expiryMonth;
        return this;
    }

    @ApiModelProperty(value="The card expiry month. Format: 2 digits, zero-padded for single digits. For example: * 03 = March * 11 = November")
    @JsonProperty(value="expiryMonth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpiryMonth() {
        return this.expiryMonth;
    }

    @JsonProperty(value="expiryMonth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiryMonth(String expiryMonth) {
        this.expiryMonth = expiryMonth;
    }

    public Card expiryYear(String expiryYear) {
        this.expiryYear = expiryYear;
        return this;
    }

    @ApiModelProperty(value="The card expiry year. Format: 4 digits. For example: 2020")
    @JsonProperty(value="expiryYear")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpiryYear() {
        return this.expiryYear;
    }

    @JsonProperty(value="expiryYear")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiryYear(String expiryYear) {
        this.expiryYear = expiryYear;
    }

    public Card holderName(String holderName) {
        this.holderName = holderName;
        return this;
    }

    @ApiModelProperty(value="The name of the cardholder, as printed on the card.")
    @JsonProperty(value="holderName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHolderName() {
        return this.holderName;
    }

    @JsonProperty(value="holderName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public Card issueNumber(String issueNumber) {
        this.issueNumber = issueNumber;
        return this;
    }

    @ApiModelProperty(value="The issue number of the card (for some UK debit cards only).")
    @JsonProperty(value="issueNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssueNumber() {
        return this.issueNumber;
    }

    @JsonProperty(value="issueNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssueNumber(String issueNumber) {
        this.issueNumber = issueNumber;
    }

    public Card number(String number) {
        this.number = number;
        return this;
    }

    @ApiModelProperty(value="The card number (4-19 characters). Do not use any separators. When this value is returned in a response, only the last 4 digits of the card number are returned.")
    @JsonProperty(value="number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNumber() {
        return this.number;
    }

    @JsonProperty(value="number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumber(String number) {
        this.number = number;
    }

    public Card startMonth(String startMonth) {
        this.startMonth = startMonth;
        return this;
    }

    @ApiModelProperty(value="The month component of the start date (for some UK debit cards only).")
    @JsonProperty(value="startMonth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStartMonth() {
        return this.startMonth;
    }

    @JsonProperty(value="startMonth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartMonth(String startMonth) {
        this.startMonth = startMonth;
    }

    public Card startYear(String startYear) {
        this.startYear = startYear;
        return this;
    }

    @ApiModelProperty(value="The year component of the start date (for some UK debit cards only).")
    @JsonProperty(value="startYear")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStartYear() {
        return this.startYear;
    }

    @JsonProperty(value="startYear")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartYear(String startYear) {
        this.startYear = startYear;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Card card = (Card)o;
        return Objects.equals(this.cvc, card.cvc) && Objects.equals(this.expiryMonth, card.expiryMonth) && Objects.equals(this.expiryYear, card.expiryYear) && Objects.equals(this.holderName, card.holderName) && Objects.equals(this.issueNumber, card.issueNumber) && Objects.equals(this.number, card.number) && Objects.equals(this.startMonth, card.startMonth) && Objects.equals(this.startYear, card.startYear);
    }

    public int hashCode() {
        return Objects.hash(this.cvc, this.expiryMonth, this.expiryYear, this.holderName, this.issueNumber, this.number, this.startMonth, this.startYear);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Card {\n");
        sb.append("    cvc: ").append(this.toIndentedString(this.cvc)).append("\n");
        sb.append("    expiryMonth: ").append(this.toIndentedString(this.expiryMonth)).append("\n");
        sb.append("    expiryYear: ").append(this.toIndentedString(this.expiryYear)).append("\n");
        sb.append("    holderName: ").append(this.toIndentedString(this.holderName)).append("\n");
        sb.append("    issueNumber: ").append(this.toIndentedString(this.issueNumber)).append("\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("    startMonth: ").append(this.toIndentedString(this.startMonth)).append("\n");
        sb.append("    startYear: ").append(this.toIndentedString(this.startYear)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Card fromJson(String jsonString) throws JsonProcessingException {
        return (Card)JSON.getMapper().readValue(jsonString, Card.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

