/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.adyen.model.marketpayaccount.LegalArrangementRequest;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderCode", "legalArrangements"})
public class DeleteLegalArrangementRequest {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_LEGAL_ARRANGEMENTS = "legalArrangements";
    private List<LegalArrangementRequest> legalArrangements = new ArrayList<LegalArrangementRequest>();

    public DeleteLegalArrangementRequest accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The code of the account holder.")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public DeleteLegalArrangementRequest legalArrangements(List<LegalArrangementRequest> legalArrangements) {
        this.legalArrangements = legalArrangements;
        return this;
    }

    public DeleteLegalArrangementRequest addLegalArrangementsItem(LegalArrangementRequest legalArrangementsItem) {
        this.legalArrangements.add(legalArrangementsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of legal arrangements.")
    @JsonProperty(value="legalArrangements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LegalArrangementRequest> getLegalArrangements() {
        return this.legalArrangements;
    }

    @JsonProperty(value="legalArrangements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalArrangements(List<LegalArrangementRequest> legalArrangements) {
        this.legalArrangements = legalArrangements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteLegalArrangementRequest deleteLegalArrangementRequest = (DeleteLegalArrangementRequest)o;
        return Objects.equals(this.accountHolderCode, deleteLegalArrangementRequest.accountHolderCode) && Objects.equals(this.legalArrangements, deleteLegalArrangementRequest.legalArrangements);
    }

    public int hashCode() {
        return Objects.hash(this.accountHolderCode, this.legalArrangements);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeleteLegalArrangementRequest {\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    legalArrangements: ").append(this.toIndentedString(this.legalArrangements)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static DeleteLegalArrangementRequest fromJson(String jsonString) throws JsonProcessingException {
        return (DeleteLegalArrangementRequest)JSON.getMapper().readValue(jsonString, DeleteLegalArrangementRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

