/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"businessLineId", "companyId", "description", "id", "legalEntityId", "pricingPlan", "reference"})
public class CreateMerchantResponse {
    public static final String JSON_PROPERTY_BUSINESS_LINE_ID = "businessLineId";
    private String businessLineId;
    public static final String JSON_PROPERTY_COMPANY_ID = "companyId";
    private String companyId;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LEGAL_ENTITY_ID = "legalEntityId";
    private String legalEntityId;
    public static final String JSON_PROPERTY_PRICING_PLAN = "pricingPlan";
    private String pricingPlan;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;

    public CreateMerchantResponse businessLineId(String businessLineId) {
        this.businessLineId = businessLineId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the [business line](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/businessLines).")
    @JsonProperty(value="businessLineId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBusinessLineId() {
        return this.businessLineId;
    }

    @JsonProperty(value="businessLineId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBusinessLineId(String businessLineId) {
        this.businessLineId = businessLineId;
    }

    public CreateMerchantResponse companyId(String companyId) {
        this.companyId = companyId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the company account.")
    @JsonProperty(value="companyId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="companyId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public CreateMerchantResponse description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Your description for the merchant account, maximum 300 characters.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateMerchantResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the merchant account. If Adyen set up a template for the `reference`, then the `id` will have the same value as the `reference` that you sent in the request. Otherwise, the value is generated by Adyen.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public CreateMerchantResponse legalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the [legal entity](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/legalEntities).")
    @JsonProperty(value="legalEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalEntityId() {
        return this.legalEntityId;
    }

    @JsonProperty(value="legalEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
    }

    public CreateMerchantResponse pricingPlan(String pricingPlan) {
        this.pricingPlan = pricingPlan;
        return this;
    }

    @ApiModelProperty(value="Partner pricing plan for the merchant, applicable for merchants under AfP managed company accounts.")
    @JsonProperty(value="pricingPlan")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPricingPlan() {
        return this.pricingPlan;
    }

    @JsonProperty(value="pricingPlan")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPricingPlan(String pricingPlan) {
        this.pricingPlan = pricingPlan;
    }

    public CreateMerchantResponse reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the merchant account.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateMerchantResponse createMerchantResponse = (CreateMerchantResponse)o;
        return Objects.equals(this.businessLineId, createMerchantResponse.businessLineId) && Objects.equals(this.companyId, createMerchantResponse.companyId) && Objects.equals(this.description, createMerchantResponse.description) && Objects.equals(this.id, createMerchantResponse.id) && Objects.equals(this.legalEntityId, createMerchantResponse.legalEntityId) && Objects.equals(this.pricingPlan, createMerchantResponse.pricingPlan) && Objects.equals(this.reference, createMerchantResponse.reference);
    }

    public int hashCode() {
        return Objects.hash(this.businessLineId, this.companyId, this.description, this.id, this.legalEntityId, this.pricingPlan, this.reference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateMerchantResponse {\n");
        sb.append("    businessLineId: ").append(this.toIndentedString(this.businessLineId)).append("\n");
        sb.append("    companyId: ").append(this.toIndentedString(this.companyId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    legalEntityId: ").append(this.toIndentedString(this.legalEntityId)).append("\n");
        sb.append("    pricingPlan: ").append(this.toIndentedString(this.pricingPlan)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CreateMerchantResponse fromJson(String jsonString) throws JsonProcessingException {
        return (CreateMerchantResponse)JSON.getMapper().readValue(jsonString, CreateMerchantResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

