/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"actionType", "config", "confirmedAt", "id", "result", "scheduledAt", "status", "terminalId"})
public class ExternalTerminalAction {
    public static final String JSON_PROPERTY_ACTION_TYPE = "actionType";
    private String actionType;
    public static final String JSON_PROPERTY_CONFIG = "config";
    private String config;
    public static final String JSON_PROPERTY_CONFIRMED_AT = "confirmedAt";
    private OffsetDateTime confirmedAt;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_RESULT = "result";
    private String result;
    public static final String JSON_PROPERTY_SCHEDULED_AT = "scheduledAt";
    private OffsetDateTime scheduledAt;
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;
    public static final String JSON_PROPERTY_TERMINAL_ID = "terminalId";
    private String terminalId;

    public ExternalTerminalAction actionType(String actionType) {
        this.actionType = actionType;
        return this;
    }

    @ApiModelProperty(value="The type of terminal action: **InstallAndroidApp**, **UninstallAndroidApp**, **InstallAndroidCertificate**, or **UninstallAndroidCertificate**.")
    @JsonProperty(value="actionType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getActionType() {
        return this.actionType;
    }

    @JsonProperty(value="actionType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public ExternalTerminalAction config(String config) {
        this.config = config;
        return this;
    }

    @ApiModelProperty(value="Technical information about the terminal action.")
    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getConfig() {
        return this.config;
    }

    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfig(String config) {
        this.config = config;
    }

    public ExternalTerminalAction confirmedAt(OffsetDateTime confirmedAt) {
        this.confirmedAt = confirmedAt;
        return this;
    }

    @ApiModelProperty(value="The date and time when the action was carried out.")
    @JsonProperty(value="confirmedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getConfirmedAt() {
        return this.confirmedAt;
    }

    @JsonProperty(value="confirmedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfirmedAt(OffsetDateTime confirmedAt) {
        this.confirmedAt = confirmedAt;
    }

    public ExternalTerminalAction id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique ID of the terminal action.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public ExternalTerminalAction result(String result) {
        this.result = result;
        return this;
    }

    @ApiModelProperty(value="The result message for the action.")
    @JsonProperty(value="result")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResult() {
        return this.result;
    }

    @JsonProperty(value="result")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResult(String result) {
        this.result = result;
    }

    public ExternalTerminalAction scheduledAt(OffsetDateTime scheduledAt) {
        this.scheduledAt = scheduledAt;
        return this;
    }

    @ApiModelProperty(value="The date and time when the action was scheduled to happen.")
    @JsonProperty(value="scheduledAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getScheduledAt() {
        return this.scheduledAt;
    }

    @JsonProperty(value="scheduledAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScheduledAt(OffsetDateTime scheduledAt) {
        this.scheduledAt = scheduledAt;
    }

    public ExternalTerminalAction status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the terminal action: **pending**, **successful**, **failed**, **cancelled**, or **tryLater**.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(String status) {
        this.status = status;
    }

    public ExternalTerminalAction terminalId(String terminalId) {
        this.terminalId = terminalId;
        return this;
    }

    @ApiModelProperty(value="The unique ID of the terminal that the action applies to.")
    @JsonProperty(value="terminalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTerminalId() {
        return this.terminalId;
    }

    @JsonProperty(value="terminalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalTerminalAction externalTerminalAction = (ExternalTerminalAction)o;
        return Objects.equals(this.actionType, externalTerminalAction.actionType) && Objects.equals(this.config, externalTerminalAction.config) && Objects.equals(this.confirmedAt, externalTerminalAction.confirmedAt) && Objects.equals(this.id, externalTerminalAction.id) && Objects.equals(this.result, externalTerminalAction.result) && Objects.equals(this.scheduledAt, externalTerminalAction.scheduledAt) && Objects.equals(this.status, externalTerminalAction.status) && Objects.equals(this.terminalId, externalTerminalAction.terminalId);
    }

    public int hashCode() {
        return Objects.hash(this.actionType, this.config, this.confirmedAt, this.id, this.result, this.scheduledAt, this.status, this.terminalId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExternalTerminalAction {\n");
        sb.append("    actionType: ").append(this.toIndentedString(this.actionType)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    confirmedAt: ").append(this.toIndentedString(this.confirmedAt)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    result: ").append(this.toIndentedString(this.result)).append("\n");
        sb.append("    scheduledAt: ").append(this.toIndentedString(this.scheduledAt)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    terminalId: ").append(this.toIndentedString(this.terminalId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ExternalTerminalAction fromJson(String jsonString) throws JsonProcessingException {
        return (ExternalTerminalAction)JSON.getMapper().readValue(jsonString, ExternalTerminalAction.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

