/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"contactlessCurrency", "hideMinorUnitsInCurrencies"})
public class Payment {
    public static final String JSON_PROPERTY_CONTACTLESS_CURRENCY = "contactlessCurrency";
    private String contactlessCurrency;
    public static final String JSON_PROPERTY_HIDE_MINOR_UNITS_IN_CURRENCIES = "hideMinorUnitsInCurrencies";
    private List<String> hideMinorUnitsInCurrencies = null;

    public Payment contactlessCurrency(String contactlessCurrency) {
        this.contactlessCurrency = contactlessCurrency;
        return this;
    }

    @ApiModelProperty(value="The default currency for contactless payments on the payment terminal, as the three-letter [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code.")
    @JsonProperty(value="contactlessCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContactlessCurrency() {
        return this.contactlessCurrency;
    }

    @JsonProperty(value="contactlessCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContactlessCurrency(String contactlessCurrency) {
        this.contactlessCurrency = contactlessCurrency;
    }

    public Payment hideMinorUnitsInCurrencies(List<String> hideMinorUnitsInCurrencies) {
        this.hideMinorUnitsInCurrencies = hideMinorUnitsInCurrencies;
        return this;
    }

    public Payment addHideMinorUnitsInCurrenciesItem(String hideMinorUnitsInCurrenciesItem) {
        if (this.hideMinorUnitsInCurrencies == null) {
            this.hideMinorUnitsInCurrencies = new ArrayList<String>();
        }
        this.hideMinorUnitsInCurrencies.add(hideMinorUnitsInCurrenciesItem);
        return this;
    }

    @ApiModelProperty(value="Hides the minor units for the listed [ISO currency codes](https://en.wikipedia.org/wiki/ISO_4217).")
    @JsonProperty(value="hideMinorUnitsInCurrencies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getHideMinorUnitsInCurrencies() {
        return this.hideMinorUnitsInCurrencies;
    }

    @JsonProperty(value="hideMinorUnitsInCurrencies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHideMinorUnitsInCurrencies(List<String> hideMinorUnitsInCurrencies) {
        this.hideMinorUnitsInCurrencies = hideMinorUnitsInCurrencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payment payment = (Payment)o;
        return Objects.equals(this.contactlessCurrency, payment.contactlessCurrency) && Objects.equals(this.hideMinorUnitsInCurrencies, payment.hideMinorUnitsInCurrencies);
    }

    public int hashCode() {
        return Objects.hash(this.contactlessCurrency, this.hideMinorUnitsInCurrencies);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Payment {\n");
        sb.append("    contactlessCurrency: ").append(this.toIndentedString(this.contactlessCurrency)).append("\n");
        sb.append("    hideMinorUnitsInCurrencies: ").append(this.toIndentedString(this.hideMinorUnitsInCurrencies)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Payment fromJson(String jsonString) throws JsonProcessingException {
        return (Payment)JSON.getMapper().readValue(jsonString, Payment.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

