/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.recurring;

import com.adyen.model.recurring.Card;
import com.adyen.model.recurring.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"additionalData", "card", "merchantAccount", "reference", "selectedRecurringDetailReference", "shopperReference"})
public class ScheduleAccountUpdaterRequest {
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData = null;
    public static final String JSON_PROPERTY_CARD = "card";
    private Card card;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_SELECTED_RECURRING_DETAIL_REFERENCE = "selectedRecurringDetailReference";
    private String selectedRecurringDetailReference;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;

    public ScheduleAccountUpdaterRequest additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public ScheduleAccountUpdaterRequest putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @ApiModelProperty(value="This field contains additional data, which may be required for a particular request.")
    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public ScheduleAccountUpdaterRequest card(Card card) {
        this.card = card;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="card")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Card getCard() {
        return this.card;
    }

    @JsonProperty(value="card")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCard(Card card) {
        this.card = card;
    }

    public ScheduleAccountUpdaterRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="Account of the merchant.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public ScheduleAccountUpdaterRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(required=true, value="A reference that merchants can apply for the call.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public ScheduleAccountUpdaterRequest selectedRecurringDetailReference(String selectedRecurringDetailReference) {
        this.selectedRecurringDetailReference = selectedRecurringDetailReference;
        return this;
    }

    @ApiModelProperty(value="The selected detail recurring reference.  Optional if `card` is provided.")
    @JsonProperty(value="selectedRecurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSelectedRecurringDetailReference() {
        return this.selectedRecurringDetailReference;
    }

    @JsonProperty(value="selectedRecurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelectedRecurringDetailReference(String selectedRecurringDetailReference) {
        this.selectedRecurringDetailReference = selectedRecurringDetailReference;
    }

    public ScheduleAccountUpdaterRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(value="The reference of the shopper that owns the recurring contract.  Optional if `card` is provided.")
    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleAccountUpdaterRequest scheduleAccountUpdaterRequest = (ScheduleAccountUpdaterRequest)o;
        return Objects.equals(this.additionalData, scheduleAccountUpdaterRequest.additionalData) && Objects.equals(this.card, scheduleAccountUpdaterRequest.card) && Objects.equals(this.merchantAccount, scheduleAccountUpdaterRequest.merchantAccount) && Objects.equals(this.reference, scheduleAccountUpdaterRequest.reference) && Objects.equals(this.selectedRecurringDetailReference, scheduleAccountUpdaterRequest.selectedRecurringDetailReference) && Objects.equals(this.shopperReference, scheduleAccountUpdaterRequest.shopperReference);
    }

    public int hashCode() {
        return Objects.hash(this.additionalData, this.card, this.merchantAccount, this.reference, this.selectedRecurringDetailReference, this.shopperReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScheduleAccountUpdaterRequest {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    selectedRecurringDetailReference: ").append(this.toIndentedString(this.selectedRecurringDetailReference)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ScheduleAccountUpdaterRequest fromJson(String jsonString) throws JsonProcessingException {
        return (ScheduleAccountUpdaterRequest)JSON.getMapper().readValue(jsonString, ScheduleAccountUpdaterRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

