/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"businessLineId", "companyId", "description", "legalEntityId", "pricingPlan", "reference", "salesChannels"})
public class CreateMerchantRequest {
    public static final String JSON_PROPERTY_BUSINESS_LINE_ID = "businessLineId";
    private String businessLineId;
    public static final String JSON_PROPERTY_COMPANY_ID = "companyId";
    private String companyId;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_LEGAL_ENTITY_ID = "legalEntityId";
    private String legalEntityId;
    public static final String JSON_PROPERTY_PRICING_PLAN = "pricingPlan";
    private String pricingPlan;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_SALES_CHANNELS = "salesChannels";
    private List<String> salesChannels = null;

    public CreateMerchantRequest businessLineId(String businessLineId) {
        this.businessLineId = businessLineId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the [business line](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/businessLines). Required for an Adyen for Platforms Manage integration.")
    @JsonProperty(value="businessLineId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBusinessLineId() {
        return this.businessLineId;
    }

    @JsonProperty(value="businessLineId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBusinessLineId(String businessLineId) {
        this.businessLineId = businessLineId;
    }

    public CreateMerchantRequest companyId(String companyId) {
        this.companyId = companyId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the company account.")
    @JsonProperty(value="companyId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="companyId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public CreateMerchantRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Your description for the merchant account, maximum 300 characters.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateMerchantRequest legalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the [legal entity](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/legalEntities). Required for an Adyen for Platforms Manage integration.")
    @JsonProperty(value="legalEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalEntityId() {
        return this.legalEntityId;
    }

    @JsonProperty(value="legalEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
    }

    public CreateMerchantRequest pricingPlan(String pricingPlan) {
        this.pricingPlan = pricingPlan;
        return this;
    }

    @ApiModelProperty(value="Sets the pricing plan for the merchant account. Required for an Adyen for Platforms Manage integration. Your Adyen contact will provide the values that you can use.")
    @JsonProperty(value="pricingPlan")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPricingPlan() {
        return this.pricingPlan;
    }

    @JsonProperty(value="pricingPlan")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPricingPlan(String pricingPlan) {
        this.pricingPlan = pricingPlan;
    }

    public CreateMerchantRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the merchant account. To make this reference the unique identifier of the merchant account, your Adyen contact can set up a template on your company account. The template can have 6 to 255 characters with upper- and lower-case letters, underscores, and numbers. When your company account has a template, then the `reference` is required and must be unique within the company account.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public CreateMerchantRequest salesChannels(List<String> salesChannels) {
        this.salesChannels = salesChannels;
        return this;
    }

    public CreateMerchantRequest addSalesChannelsItem(String salesChannelsItem) {
        if (this.salesChannels == null) {
            this.salesChannels = new ArrayList<String>();
        }
        this.salesChannels.add(salesChannelsItem);
        return this;
    }

    @ApiModelProperty(value="List of sales channels that the merchant will process payments with")
    @JsonProperty(value="salesChannels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSalesChannels() {
        return this.salesChannels;
    }

    @JsonProperty(value="salesChannels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSalesChannels(List<String> salesChannels) {
        this.salesChannels = salesChannels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateMerchantRequest createMerchantRequest = (CreateMerchantRequest)o;
        return Objects.equals(this.businessLineId, createMerchantRequest.businessLineId) && Objects.equals(this.companyId, createMerchantRequest.companyId) && Objects.equals(this.description, createMerchantRequest.description) && Objects.equals(this.legalEntityId, createMerchantRequest.legalEntityId) && Objects.equals(this.pricingPlan, createMerchantRequest.pricingPlan) && Objects.equals(this.reference, createMerchantRequest.reference) && Objects.equals(this.salesChannels, createMerchantRequest.salesChannels);
    }

    public int hashCode() {
        return Objects.hash(this.businessLineId, this.companyId, this.description, this.legalEntityId, this.pricingPlan, this.reference, this.salesChannels);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateMerchantRequest {\n");
        sb.append("    businessLineId: ").append(this.toIndentedString(this.businessLineId)).append("\n");
        sb.append("    companyId: ").append(this.toIndentedString(this.companyId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    legalEntityId: ").append(this.toIndentedString(this.legalEntityId)).append("\n");
        sb.append("    pricingPlan: ").append(this.toIndentedString(this.pricingPlan)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    salesChannels: ").append(this.toIndentedString(this.salesChannels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CreateMerchantRequest fromJson(String jsonString) throws JsonProcessingException {
        return (CreateMerchantRequest)JSON.getMapper().readValue(jsonString, CreateMerchantRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

