/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"checkoutAttemptId", "orderID", "payeePreferred", "payerID", "payerSelected", "recurringDetailReference", "storedPaymentMethodId", "subtype", "type"})
public class PayPalDetails {
    public static final String JSON_PROPERTY_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
    private String checkoutAttemptId;
    public static final String JSON_PROPERTY_ORDER_I_D = "orderID";
    private String orderID;
    public static final String JSON_PROPERTY_PAYEE_PREFERRED = "payeePreferred";
    private String payeePreferred;
    public static final String JSON_PROPERTY_PAYER_I_D = "payerID";
    private String payerID;
    public static final String JSON_PROPERTY_PAYER_SELECTED = "payerSelected";
    private String payerSelected;
    public static final String JSON_PROPERTY_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
    @Deprecated
    private String recurringDetailReference;
    public static final String JSON_PROPERTY_STORED_PAYMENT_METHOD_ID = "storedPaymentMethodId";
    private String storedPaymentMethodId;
    public static final String JSON_PROPERTY_SUBTYPE = "subtype";
    private SubtypeEnum subtype;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public PayPalDetails checkoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
        return this;
    }

    @ApiModelProperty(value="The checkout attempt identifier.")
    @JsonProperty(value="checkoutAttemptId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCheckoutAttemptId() {
        return this.checkoutAttemptId;
    }

    @JsonProperty(value="checkoutAttemptId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCheckoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
    }

    public PayPalDetails orderID(String orderID) {
        this.orderID = orderID;
        return this;
    }

    @ApiModelProperty(value="The unique ID associated with the order.")
    @JsonProperty(value="orderID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrderID() {
        return this.orderID;
    }

    @JsonProperty(value="orderID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrderID(String orderID) {
        this.orderID = orderID;
    }

    public PayPalDetails payeePreferred(String payeePreferred) {
        this.payeePreferred = payeePreferred;
        return this;
    }

    @ApiModelProperty(value="IMMEDIATE_PAYMENT_REQUIRED or UNRESTRICTED")
    @JsonProperty(value="payeePreferred")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayeePreferred() {
        return this.payeePreferred;
    }

    @JsonProperty(value="payeePreferred")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayeePreferred(String payeePreferred) {
        this.payeePreferred = payeePreferred;
    }

    public PayPalDetails payerID(String payerID) {
        this.payerID = payerID;
        return this;
    }

    @ApiModelProperty(value="The unique ID associated with the payer.")
    @JsonProperty(value="payerID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayerID() {
        return this.payerID;
    }

    @JsonProperty(value="payerID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayerID(String payerID) {
        this.payerID = payerID;
    }

    public PayPalDetails payerSelected(String payerSelected) {
        this.payerSelected = payerSelected;
        return this;
    }

    @ApiModelProperty(value="PAYPAL or PAYPAL_CREDIT")
    @JsonProperty(value="payerSelected")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayerSelected() {
        return this.payerSelected;
    }

    @JsonProperty(value="payerSelected")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayerSelected(String payerSelected) {
        this.payerSelected = payerSelected;
    }

    @Deprecated
    public PayPalDetails recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    @Deprecated
    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public PayPalDetails storedPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
        return this;
    }

    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    @JsonProperty(value="storedPaymentMethodId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoredPaymentMethodId() {
        return this.storedPaymentMethodId;
    }

    @JsonProperty(value="storedPaymentMethodId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoredPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
    }

    public PayPalDetails subtype(SubtypeEnum subtype) {
        this.subtype = subtype;
        return this;
    }

    @ApiModelProperty(value="The type of flow to initiate.")
    @JsonProperty(value="subtype")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SubtypeEnum getSubtype() {
        return this.subtype;
    }

    @JsonProperty(value="subtype")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubtype(SubtypeEnum subtype) {
        this.subtype = subtype;
    }

    public PayPalDetails type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="**paypal**")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayPalDetails payPalDetails = (PayPalDetails)o;
        return Objects.equals(this.checkoutAttemptId, payPalDetails.checkoutAttemptId) && Objects.equals(this.orderID, payPalDetails.orderID) && Objects.equals(this.payeePreferred, payPalDetails.payeePreferred) && Objects.equals(this.payerID, payPalDetails.payerID) && Objects.equals(this.payerSelected, payPalDetails.payerSelected) && Objects.equals(this.recurringDetailReference, payPalDetails.recurringDetailReference) && Objects.equals(this.storedPaymentMethodId, payPalDetails.storedPaymentMethodId) && Objects.equals((Object)this.subtype, (Object)payPalDetails.subtype) && Objects.equals((Object)this.type, (Object)payPalDetails.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.checkoutAttemptId, this.orderID, this.payeePreferred, this.payerID, this.payerSelected, this.recurringDetailReference, this.storedPaymentMethodId, this.subtype, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayPalDetails {\n");
        sb.append("    checkoutAttemptId: ").append(this.toIndentedString(this.checkoutAttemptId)).append("\n");
        sb.append("    orderID: ").append(this.toIndentedString(this.orderID)).append("\n");
        sb.append("    payeePreferred: ").append(this.toIndentedString(this.payeePreferred)).append("\n");
        sb.append("    payerID: ").append(this.toIndentedString(this.payerID)).append("\n");
        sb.append("    payerSelected: ").append(this.toIndentedString(this.payerSelected)).append("\n");
        sb.append("    recurringDetailReference: ").append(this.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    storedPaymentMethodId: ").append(this.toIndentedString(this.storedPaymentMethodId)).append("\n");
        sb.append("    subtype: ").append(this.toIndentedString((Object)this.subtype)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PayPalDetails fromJson(String jsonString) throws JsonProcessingException {
        return (PayPalDetails)JSON.getMapper().readValue(jsonString, PayPalDetails.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        PAYPAL("paypal");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SubtypeEnum {
        REDIRECT("redirect"),
        SDK("sdk");

        private String value;

        private SubtypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SubtypeEnum fromValue(String value) {
            for (SubtypeEnum b : SubtypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

