/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.Amount;
import com.adyen.model.balanceplatform.JSON;
import com.adyen.model.balanceplatform.SweepCounterparty;
import com.adyen.model.balanceplatform.SweepSchedule;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"category", "counterparty", "currency", "description", "id", "priorities", "reason", "reference", "referenceForBeneficiary", "schedule", "status", "sweepAmount", "targetAmount", "triggerAmount", "type"})
public class SweepConfigurationV2 {
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private CategoryEnum category;
    public static final String JSON_PROPERTY_COUNTERPARTY = "counterparty";
    private SweepCounterparty counterparty;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_PRIORITIES = "priorities";
    private List<PrioritiesEnum> priorities = null;
    public static final String JSON_PROPERTY_REASON = "reason";
    private ReasonEnum reason;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_REFERENCE_FOR_BENEFICIARY = "referenceForBeneficiary";
    private String referenceForBeneficiary;
    public static final String JSON_PROPERTY_SCHEDULE = "schedule";
    private SweepSchedule schedule;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_SWEEP_AMOUNT = "sweepAmount";
    private Amount sweepAmount;
    public static final String JSON_PROPERTY_TARGET_AMOUNT = "targetAmount";
    private Amount targetAmount;
    public static final String JSON_PROPERTY_TRIGGER_AMOUNT = "triggerAmount";
    private Amount triggerAmount;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public SweepConfigurationV2 category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(value="The type of transfer that results from the sweep.  Possible values:   - **bank**: Sweep to a [transfer instrument](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/transferInstruments__resParam_id).  - **internal**: Transfer to another [balance account](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id) within your platform.  Required when setting `priorities`.")
    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CategoryEnum getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public SweepConfigurationV2 counterparty(SweepCounterparty counterparty) {
        this.counterparty = counterparty;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SweepCounterparty getCounterparty() {
        return this.counterparty;
    }

    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCounterparty(SweepCounterparty counterparty) {
        this.counterparty = counterparty;
    }

    public SweepConfigurationV2 currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="The three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes) in uppercase. For example, **EUR**.  The sweep currency must match any of the [balances currencies](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/get/balanceAccounts/{id}__resParam_balances).")
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public SweepConfigurationV2 description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The message that will be used in the sweep transfer's description body with a maximum length of 140 characters.  If the message is longer after replacing placeholders, the message will be cut off at 140 characters.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public SweepConfigurationV2 id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the sweep.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public SweepConfigurationV2 priorities(List<PrioritiesEnum> priorities) {
        this.priorities = priorities;
        return this;
    }

    public SweepConfigurationV2 addPrioritiesItem(PrioritiesEnum prioritiesItem) {
        if (this.priorities == null) {
            this.priorities = new ArrayList<PrioritiesEnum>();
        }
        this.priorities.add(prioritiesItem);
        return this;
    }

    @ApiModelProperty(value="The list of priorities for the bank transfer. This sets the speed at which the transfer is sent and the fees that you have to pay. You can provide multiple priorities. Adyen will try to pay out using the priority you list first. If that's not possible, it moves on to the next option in the order of your provided priorities.  Possible values:  * **regular**: For normal, low-value transactions.  * **fast**: Faster way to transfer funds but has higher fees. Recommended for high-priority, low-value transactions.  * **wire**: Fastest way to transfer funds but has the highest fees. Recommended for high-priority, high-value transactions.  * **instant**: Instant way to transfer funds in [SEPA countries](https://www.ecb.europa.eu/paym/integration/retail/sepa/html/index.en.html).  * **crossBorder**: High-value transfer to a recipient in a different country.  * **internal**: Transfer to an Adyen-issued business bank account (by bank account number/IBAN).  Set `category` to **bank**. For more details, see optional priorities setup for [marketplaces](https://docs.adyen.com/marketplaces/payout-to-users/scheduled-payouts#optional-priorities-setup) or [platforms](https://docs.adyen.com/platforms/payout-to-users/scheduled-payouts#optional-priorities-setup).")
    @JsonProperty(value="priorities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PrioritiesEnum> getPriorities() {
        return this.priorities;
    }

    @JsonProperty(value="priorities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPriorities(List<PrioritiesEnum> priorities) {
        this.priorities = priorities;
    }

    public SweepConfigurationV2 reason(ReasonEnum reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="The reason for disabling the sweep.")
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ReasonEnum getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReason(ReasonEnum reason) {
        this.reason = reason;
    }

    public SweepConfigurationV2 reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the sweep configuration.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public SweepConfigurationV2 referenceForBeneficiary(String referenceForBeneficiary) {
        this.referenceForBeneficiary = referenceForBeneficiary;
        return this;
    }

    @ApiModelProperty(value="The reference sent to or received from the counterparty. Only alphanumeric characters are allowed.")
    @JsonProperty(value="referenceForBeneficiary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReferenceForBeneficiary() {
        return this.referenceForBeneficiary;
    }

    @JsonProperty(value="referenceForBeneficiary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferenceForBeneficiary(String referenceForBeneficiary) {
        this.referenceForBeneficiary = referenceForBeneficiary;
    }

    public SweepConfigurationV2 schedule(SweepSchedule schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="schedule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SweepSchedule getSchedule() {
        return this.schedule;
    }

    @JsonProperty(value="schedule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchedule(SweepSchedule schedule) {
        this.schedule = schedule;
    }

    public SweepConfigurationV2 status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the sweep. If not provided, by default, this is set to **active**.  Possible values:    * **active**:  the sweep is enabled and funds will be pulled in or pushed out based on the defined configuration.    * **inactive**: the sweep is disabled and cannot be triggered.   ")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public SweepConfigurationV2 sweepAmount(Amount sweepAmount) {
        this.sweepAmount = sweepAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="sweepAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getSweepAmount() {
        return this.sweepAmount;
    }

    @JsonProperty(value="sweepAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSweepAmount(Amount sweepAmount) {
        this.sweepAmount = sweepAmount;
    }

    public SweepConfigurationV2 targetAmount(Amount targetAmount) {
        this.targetAmount = targetAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="targetAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getTargetAmount() {
        return this.targetAmount;
    }

    @JsonProperty(value="targetAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTargetAmount(Amount targetAmount) {
        this.targetAmount = targetAmount;
    }

    public SweepConfigurationV2 triggerAmount(Amount triggerAmount) {
        this.triggerAmount = triggerAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="triggerAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getTriggerAmount() {
        return this.triggerAmount;
    }

    @JsonProperty(value="triggerAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTriggerAmount(Amount triggerAmount) {
        this.triggerAmount = triggerAmount;
    }

    public SweepConfigurationV2 type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The direction of sweep, whether pushing out or pulling in funds to the balance account. If not provided, by default, this is set to **push**.  Possible values:   * **push**: _push out funds_ to a destination balance account or transfer instrument.   * **pull**: _pull in funds_ from a source merchant account, transfer instrument, or balance account.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SweepConfigurationV2 sweepConfigurationV2 = (SweepConfigurationV2)o;
        return Objects.equals((Object)this.category, (Object)sweepConfigurationV2.category) && Objects.equals(this.counterparty, sweepConfigurationV2.counterparty) && Objects.equals(this.currency, sweepConfigurationV2.currency) && Objects.equals(this.description, sweepConfigurationV2.description) && Objects.equals(this.id, sweepConfigurationV2.id) && Objects.equals(this.priorities, sweepConfigurationV2.priorities) && Objects.equals((Object)this.reason, (Object)sweepConfigurationV2.reason) && Objects.equals(this.reference, sweepConfigurationV2.reference) && Objects.equals(this.referenceForBeneficiary, sweepConfigurationV2.referenceForBeneficiary) && Objects.equals(this.schedule, sweepConfigurationV2.schedule) && Objects.equals((Object)this.status, (Object)sweepConfigurationV2.status) && Objects.equals(this.sweepAmount, sweepConfigurationV2.sweepAmount) && Objects.equals(this.targetAmount, sweepConfigurationV2.targetAmount) && Objects.equals(this.triggerAmount, sweepConfigurationV2.triggerAmount) && Objects.equals((Object)this.type, (Object)sweepConfigurationV2.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.category, this.counterparty, this.currency, this.description, this.id, this.priorities, this.reason, this.reference, this.referenceForBeneficiary, this.schedule, this.status, this.sweepAmount, this.targetAmount, this.triggerAmount, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SweepConfigurationV2 {\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    counterparty: ").append(this.toIndentedString(this.counterparty)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    priorities: ").append(this.toIndentedString(this.priorities)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    referenceForBeneficiary: ").append(this.toIndentedString(this.referenceForBeneficiary)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    sweepAmount: ").append(this.toIndentedString(this.sweepAmount)).append("\n");
        sb.append("    targetAmount: ").append(this.toIndentedString(this.targetAmount)).append("\n");
        sb.append("    triggerAmount: ").append(this.toIndentedString(this.triggerAmount)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static SweepConfigurationV2 fromJson(String jsonString) throws JsonProcessingException {
        return (SweepConfigurationV2)JSON.getMapper().readValue(jsonString, SweepConfigurationV2.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        PULL("pull"),
        PUSH("push");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        ACTIVE("active"),
        INACTIVE("inactive");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ReasonEnum {
        AMOUNTLIMITEXCEEDED("amountLimitExceeded"),
        APPROVED("approved"),
        BALANCEACCOUNTTEMPORARILYBLOCKEDBYTRANSACTIONRULE("balanceAccountTemporarilyBlockedByTransactionRule"),
        COUNTERPARTYACCOUNTBLOCKED("counterpartyAccountBlocked"),
        COUNTERPARTYACCOUNTCLOSED("counterpartyAccountClosed"),
        COUNTERPARTYACCOUNTNOTFOUND("counterpartyAccountNotFound"),
        COUNTERPARTYADDRESSREQUIRED("counterpartyAddressRequired"),
        COUNTERPARTYBANKTIMEDOUT("counterpartyBankTimedOut"),
        COUNTERPARTYBANKUNAVAILABLE("counterpartyBankUnavailable"),
        DECLINEDBYTRANSACTIONRULE("declinedByTransactionRule"),
        ERROR("error"),
        NOTENOUGHBALANCE("notEnoughBalance"),
        PENDINGAPPROVAL("pendingApproval"),
        REFUSEDBYCOUNTERPARTYBANK("refusedByCounterpartyBank"),
        ROUTENOTFOUND("routeNotFound"),
        SCAFAILED("scaFailed"),
        UNKNOWN("unknown");

        private String value;

        private ReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReasonEnum fromValue(String value) {
            for (ReasonEnum b : ReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PrioritiesEnum {
        CROSSBORDER("crossBorder"),
        FAST("fast"),
        INSTANT("instant"),
        INTERNAL("internal"),
        REGULAR("regular"),
        WIRE("wire");

        private String value;

        private PrioritiesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PrioritiesEnum fromValue(String value) {
            for (PrioritiesEnum b : PrioritiesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CategoryEnum {
        BANK("bank"),
        INTERNAL("internal"),
        PLATFORMPAYMENT("platformPayment");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

