/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"brand", "checkoutAttemptId", "cupsecureplus.smscode", "cvc", "encryptedCardNumber", "encryptedExpiryMonth", "encryptedExpiryYear", "encryptedSecurityCode", "expiryMonth", "expiryYear", "fundingSource", "holderName", "networkPaymentReference", "number", "recurringDetailReference", "shopperNotificationReference", "storedPaymentMethodId", "threeDS2SdkVersion", "type"})
public class CardDetails {
    public static final String JSON_PROPERTY_BRAND = "brand";
    private String brand;
    public static final String JSON_PROPERTY_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
    private String checkoutAttemptId;
    public static final String JSON_PROPERTY_CUPSECUREPLUS_SMSCODE = "cupsecureplus.smscode";
    @Deprecated
    private String cupsecureplusSmscode;
    public static final String JSON_PROPERTY_CVC = "cvc";
    private String cvc;
    public static final String JSON_PROPERTY_ENCRYPTED_CARD_NUMBER = "encryptedCardNumber";
    private String encryptedCardNumber;
    public static final String JSON_PROPERTY_ENCRYPTED_EXPIRY_MONTH = "encryptedExpiryMonth";
    private String encryptedExpiryMonth;
    public static final String JSON_PROPERTY_ENCRYPTED_EXPIRY_YEAR = "encryptedExpiryYear";
    private String encryptedExpiryYear;
    public static final String JSON_PROPERTY_ENCRYPTED_SECURITY_CODE = "encryptedSecurityCode";
    private String encryptedSecurityCode;
    public static final String JSON_PROPERTY_EXPIRY_MONTH = "expiryMonth";
    private String expiryMonth;
    public static final String JSON_PROPERTY_EXPIRY_YEAR = "expiryYear";
    private String expiryYear;
    public static final String JSON_PROPERTY_FUNDING_SOURCE = "fundingSource";
    private FundingSourceEnum fundingSource;
    public static final String JSON_PROPERTY_HOLDER_NAME = "holderName";
    private String holderName;
    public static final String JSON_PROPERTY_NETWORK_PAYMENT_REFERENCE = "networkPaymentReference";
    private String networkPaymentReference;
    public static final String JSON_PROPERTY_NUMBER = "number";
    private String number;
    public static final String JSON_PROPERTY_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
    @Deprecated
    private String recurringDetailReference;
    public static final String JSON_PROPERTY_SHOPPER_NOTIFICATION_REFERENCE = "shopperNotificationReference";
    private String shopperNotificationReference;
    public static final String JSON_PROPERTY_STORED_PAYMENT_METHOD_ID = "storedPaymentMethodId";
    private String storedPaymentMethodId;
    public static final String JSON_PROPERTY_THREE_D_S2_SDK_VERSION = "threeDS2SdkVersion";
    private String threeDS2SdkVersion;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public CardDetails brand(String brand) {
        this.brand = brand;
        return this;
    }

    @ApiModelProperty(value="Secondary brand of the card. For example: **plastix**, **hmclub**.")
    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBrand() {
        return this.brand;
    }

    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrand(String brand) {
        this.brand = brand;
    }

    public CardDetails checkoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
        return this;
    }

    @ApiModelProperty(value="The checkout attempt identifier.")
    @JsonProperty(value="checkoutAttemptId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCheckoutAttemptId() {
        return this.checkoutAttemptId;
    }

    @JsonProperty(value="checkoutAttemptId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCheckoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
    }

    @Deprecated
    public CardDetails cupsecureplusSmscode(String cupsecureplusSmscode) {
        this.cupsecureplusSmscode = cupsecureplusSmscode;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="")
    @JsonProperty(value="cupsecureplus.smscode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCupsecureplusSmscode() {
        return this.cupsecureplusSmscode;
    }

    @Deprecated
    @JsonProperty(value="cupsecureplus.smscode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCupsecureplusSmscode(String cupsecureplusSmscode) {
        this.cupsecureplusSmscode = cupsecureplusSmscode;
    }

    public CardDetails cvc(String cvc) {
        this.cvc = cvc;
        return this;
    }

    @ApiModelProperty(value="The card verification code. Only collect raw card data if you are [fully PCI compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).")
    @JsonProperty(value="cvc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCvc() {
        return this.cvc;
    }

    @JsonProperty(value="cvc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCvc(String cvc) {
        this.cvc = cvc;
    }

    public CardDetails encryptedCardNumber(String encryptedCardNumber) {
        this.encryptedCardNumber = encryptedCardNumber;
        return this;
    }

    @ApiModelProperty(value="The encrypted card number.")
    @JsonProperty(value="encryptedCardNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEncryptedCardNumber() {
        return this.encryptedCardNumber;
    }

    @JsonProperty(value="encryptedCardNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEncryptedCardNumber(String encryptedCardNumber) {
        this.encryptedCardNumber = encryptedCardNumber;
    }

    public CardDetails encryptedExpiryMonth(String encryptedExpiryMonth) {
        this.encryptedExpiryMonth = encryptedExpiryMonth;
        return this;
    }

    @ApiModelProperty(value="The encrypted card expiry month.")
    @JsonProperty(value="encryptedExpiryMonth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEncryptedExpiryMonth() {
        return this.encryptedExpiryMonth;
    }

    @JsonProperty(value="encryptedExpiryMonth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEncryptedExpiryMonth(String encryptedExpiryMonth) {
        this.encryptedExpiryMonth = encryptedExpiryMonth;
    }

    public CardDetails encryptedExpiryYear(String encryptedExpiryYear) {
        this.encryptedExpiryYear = encryptedExpiryYear;
        return this;
    }

    @ApiModelProperty(value="The encrypted card expiry year.")
    @JsonProperty(value="encryptedExpiryYear")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEncryptedExpiryYear() {
        return this.encryptedExpiryYear;
    }

    @JsonProperty(value="encryptedExpiryYear")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEncryptedExpiryYear(String encryptedExpiryYear) {
        this.encryptedExpiryYear = encryptedExpiryYear;
    }

    public CardDetails encryptedSecurityCode(String encryptedSecurityCode) {
        this.encryptedSecurityCode = encryptedSecurityCode;
        return this;
    }

    @ApiModelProperty(value="The encrypted card verification code.")
    @JsonProperty(value="encryptedSecurityCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEncryptedSecurityCode() {
        return this.encryptedSecurityCode;
    }

    @JsonProperty(value="encryptedSecurityCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEncryptedSecurityCode(String encryptedSecurityCode) {
        this.encryptedSecurityCode = encryptedSecurityCode;
    }

    public CardDetails expiryMonth(String expiryMonth) {
        this.expiryMonth = expiryMonth;
        return this;
    }

    @ApiModelProperty(value="The card expiry month. Only collect raw card data if you are [fully PCI compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).")
    @JsonProperty(value="expiryMonth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpiryMonth() {
        return this.expiryMonth;
    }

    @JsonProperty(value="expiryMonth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiryMonth(String expiryMonth) {
        this.expiryMonth = expiryMonth;
    }

    public CardDetails expiryYear(String expiryYear) {
        this.expiryYear = expiryYear;
        return this;
    }

    @ApiModelProperty(value="The card expiry year. Only collect raw card data if you are [fully PCI compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).")
    @JsonProperty(value="expiryYear")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpiryYear() {
        return this.expiryYear;
    }

    @JsonProperty(value="expiryYear")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiryYear(String expiryYear) {
        this.expiryYear = expiryYear;
    }

    public CardDetails fundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
        return this;
    }

    @ApiModelProperty(value="The funding source that should be used when multiple sources are available. For Brazilian combo cards, by default the funding source is credit. To use debit, set this value to **debit**.")
    @JsonProperty(value="fundingSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FundingSourceEnum getFundingSource() {
        return this.fundingSource;
    }

    @JsonProperty(value="fundingSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
    }

    public CardDetails holderName(String holderName) {
        this.holderName = holderName;
        return this;
    }

    @ApiModelProperty(value="The name of the card holder.")
    @JsonProperty(value="holderName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHolderName() {
        return this.holderName;
    }

    @JsonProperty(value="holderName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public CardDetails networkPaymentReference(String networkPaymentReference) {
        this.networkPaymentReference = networkPaymentReference;
        return this;
    }

    @ApiModelProperty(value="The network token reference. This is the [`networkTxReference`](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/payments__resParam_additionalData-ResponseAdditionalDataCommon-networkTxReference) from the response to the first payment.")
    @JsonProperty(value="networkPaymentReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNetworkPaymentReference() {
        return this.networkPaymentReference;
    }

    @JsonProperty(value="networkPaymentReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetworkPaymentReference(String networkPaymentReference) {
        this.networkPaymentReference = networkPaymentReference;
    }

    public CardDetails number(String number) {
        this.number = number;
        return this;
    }

    @ApiModelProperty(value="The card number. Only collect raw card data if you are [fully PCI compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).")
    @JsonProperty(value="number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNumber() {
        return this.number;
    }

    @JsonProperty(value="number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumber(String number) {
        this.number = number;
    }

    @Deprecated
    public CardDetails recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    @Deprecated
    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public CardDetails shopperNotificationReference(String shopperNotificationReference) {
        this.shopperNotificationReference = shopperNotificationReference;
        return this;
    }

    @ApiModelProperty(value="The `shopperNotificationReference` returned in the response when you requested to notify the shopper. Used only for recurring payments in India.")
    @JsonProperty(value="shopperNotificationReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperNotificationReference() {
        return this.shopperNotificationReference;
    }

    @JsonProperty(value="shopperNotificationReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperNotificationReference(String shopperNotificationReference) {
        this.shopperNotificationReference = shopperNotificationReference;
    }

    public CardDetails storedPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
        return this;
    }

    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    @JsonProperty(value="storedPaymentMethodId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoredPaymentMethodId() {
        return this.storedPaymentMethodId;
    }

    @JsonProperty(value="storedPaymentMethodId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoredPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
    }

    public CardDetails threeDS2SdkVersion(String threeDS2SdkVersion) {
        this.threeDS2SdkVersion = threeDS2SdkVersion;
        return this;
    }

    @ApiModelProperty(value="Required for mobile integrations. Version of the 3D Secure 2 mobile SDK.")
    @JsonProperty(value="threeDS2SdkVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDS2SdkVersion() {
        return this.threeDS2SdkVersion;
    }

    @JsonProperty(value="threeDS2SdkVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDS2SdkVersion(String threeDS2SdkVersion) {
        this.threeDS2SdkVersion = threeDS2SdkVersion;
    }

    public CardDetails type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Default payment method details. Common for scheme payment methods, and for simple payment method details.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardDetails cardDetails = (CardDetails)o;
        return Objects.equals(this.brand, cardDetails.brand) && Objects.equals(this.checkoutAttemptId, cardDetails.checkoutAttemptId) && Objects.equals(this.cupsecureplusSmscode, cardDetails.cupsecureplusSmscode) && Objects.equals(this.cvc, cardDetails.cvc) && Objects.equals(this.encryptedCardNumber, cardDetails.encryptedCardNumber) && Objects.equals(this.encryptedExpiryMonth, cardDetails.encryptedExpiryMonth) && Objects.equals(this.encryptedExpiryYear, cardDetails.encryptedExpiryYear) && Objects.equals(this.encryptedSecurityCode, cardDetails.encryptedSecurityCode) && Objects.equals(this.expiryMonth, cardDetails.expiryMonth) && Objects.equals(this.expiryYear, cardDetails.expiryYear) && Objects.equals((Object)this.fundingSource, (Object)cardDetails.fundingSource) && Objects.equals(this.holderName, cardDetails.holderName) && Objects.equals(this.networkPaymentReference, cardDetails.networkPaymentReference) && Objects.equals(this.number, cardDetails.number) && Objects.equals(this.recurringDetailReference, cardDetails.recurringDetailReference) && Objects.equals(this.shopperNotificationReference, cardDetails.shopperNotificationReference) && Objects.equals(this.storedPaymentMethodId, cardDetails.storedPaymentMethodId) && Objects.equals(this.threeDS2SdkVersion, cardDetails.threeDS2SdkVersion) && Objects.equals((Object)this.type, (Object)cardDetails.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.brand, this.checkoutAttemptId, this.cupsecureplusSmscode, this.cvc, this.encryptedCardNumber, this.encryptedExpiryMonth, this.encryptedExpiryYear, this.encryptedSecurityCode, this.expiryMonth, this.expiryYear, this.fundingSource, this.holderName, this.networkPaymentReference, this.number, this.recurringDetailReference, this.shopperNotificationReference, this.storedPaymentMethodId, this.threeDS2SdkVersion, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CardDetails {\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    checkoutAttemptId: ").append(this.toIndentedString(this.checkoutAttemptId)).append("\n");
        sb.append("    cupsecureplusSmscode: ").append(this.toIndentedString(this.cupsecureplusSmscode)).append("\n");
        sb.append("    cvc: ").append(this.toIndentedString(this.cvc)).append("\n");
        sb.append("    encryptedCardNumber: ").append(this.toIndentedString(this.encryptedCardNumber)).append("\n");
        sb.append("    encryptedExpiryMonth: ").append(this.toIndentedString(this.encryptedExpiryMonth)).append("\n");
        sb.append("    encryptedExpiryYear: ").append(this.toIndentedString(this.encryptedExpiryYear)).append("\n");
        sb.append("    encryptedSecurityCode: ").append(this.toIndentedString(this.encryptedSecurityCode)).append("\n");
        sb.append("    expiryMonth: ").append(this.toIndentedString(this.expiryMonth)).append("\n");
        sb.append("    expiryYear: ").append(this.toIndentedString(this.expiryYear)).append("\n");
        sb.append("    fundingSource: ").append(this.toIndentedString((Object)this.fundingSource)).append("\n");
        sb.append("    holderName: ").append(this.toIndentedString(this.holderName)).append("\n");
        sb.append("    networkPaymentReference: ").append(this.toIndentedString(this.networkPaymentReference)).append("\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("    recurringDetailReference: ").append(this.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    shopperNotificationReference: ").append(this.toIndentedString(this.shopperNotificationReference)).append("\n");
        sb.append("    storedPaymentMethodId: ").append(this.toIndentedString(this.storedPaymentMethodId)).append("\n");
        sb.append("    threeDS2SdkVersion: ").append(this.toIndentedString(this.threeDS2SdkVersion)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CardDetails fromJson(String jsonString) throws JsonProcessingException {
        return (CardDetails)JSON.getMapper().readValue(jsonString, CardDetails.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        BCMC("bcmc"),
        SCHEME("scheme"),
        NETWORKTOKEN("networkToken"),
        GIFTCARD("giftcard"),
        CARD("card");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FundingSourceEnum {
        CREDIT("credit"),
        DEBIT("debit");

        private String value;

        private FundingSourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FundingSourceEnum fromValue(String value) {
            for (FundingSourceEnum b : FundingSourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

