/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"salesDayClosingTime", "settlementDelayDays"})
public class PlatformPaymentConfiguration {
    public static final String JSON_PROPERTY_SALES_DAY_CLOSING_TIME = "salesDayClosingTime";
    private String salesDayClosingTime;
    public static final String JSON_PROPERTY_SETTLEMENT_DELAY_DAYS = "settlementDelayDays";
    private Integer settlementDelayDays;

    public PlatformPaymentConfiguration salesDayClosingTime(String salesDayClosingTime) {
        this.salesDayClosingTime = salesDayClosingTime;
        return this;
    }

    @ApiModelProperty(value="Specifies at what time a [sales day](https://docs.adyen.com/marketplaces-and-platforms/settle-funds/sales-day-settlement#sales-day) ends.  Possible values: Time in **\"HH:MM\"** format. **HH** ranges from **00** to **07**. **MM** must be **00**.  Default value: **\"00:00\"**.")
    @JsonProperty(value="salesDayClosingTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSalesDayClosingTime() {
        return this.salesDayClosingTime;
    }

    @JsonProperty(value="salesDayClosingTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSalesDayClosingTime(String salesDayClosingTime) {
        this.salesDayClosingTime = salesDayClosingTime;
    }

    public PlatformPaymentConfiguration settlementDelayDays(Integer settlementDelayDays) {
        this.settlementDelayDays = settlementDelayDays;
        return this;
    }

    @ApiModelProperty(value="Specifies after how many business days the funds in a [settlement batch](https://docs.adyen.com/marketplaces-and-platforms/settle-funds/sales-day-settlement#settlement-batch) are made available.  Possible values: **0** to **10**, or **null**. * Setting this value to an integer enables [Sales day settlement](https://docs.adyen.com/marketplaces-and-platforms/settle-funds/sales-day-settlement). * Setting this value to **null** enables [Pass-through settlement](https://docs.adyen.com/marketplaces-and-platforms/settle-funds/pass-through-settlement).  Default value: **null**.")
    @JsonProperty(value="settlementDelayDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSettlementDelayDays() {
        return this.settlementDelayDays;
    }

    @JsonProperty(value="settlementDelayDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSettlementDelayDays(Integer settlementDelayDays) {
        this.settlementDelayDays = settlementDelayDays;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlatformPaymentConfiguration platformPaymentConfiguration = (PlatformPaymentConfiguration)o;
        return Objects.equals(this.salesDayClosingTime, platformPaymentConfiguration.salesDayClosingTime) && Objects.equals(this.settlementDelayDays, platformPaymentConfiguration.settlementDelayDays);
    }

    public int hashCode() {
        return Objects.hash(this.salesDayClosingTime, this.settlementDelayDays);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PlatformPaymentConfiguration {\n");
        sb.append("    salesDayClosingTime: ").append(this.toIndentedString(this.salesDayClosingTime)).append("\n");
        sb.append("    settlementDelayDays: ").append(this.toIndentedString(this.settlementDelayDays)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PlatformPaymentConfiguration fromJson(String jsonString) throws JsonProcessingException {
        return (PlatformPaymentConfiguration)JSON.getMapper().readValue(jsonString, PlatformPaymentConfiguration.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

