/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"checkoutAttemptId", "recurringDetailReference", "storedPaymentMethodId", "type"})
public class StoredPaymentMethodDetails {
    public static final String JSON_PROPERTY_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
    private String checkoutAttemptId;
    public static final String JSON_PROPERTY_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
    private String recurringDetailReference;
    public static final String JSON_PROPERTY_STORED_PAYMENT_METHOD_ID = "storedPaymentMethodId";
    private String storedPaymentMethodId;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public StoredPaymentMethodDetails checkoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
        return this;
    }

    @ApiModelProperty(value="The checkout attempt identifier.")
    @JsonProperty(value="checkoutAttemptId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCheckoutAttemptId() {
        return this.checkoutAttemptId;
    }

    @JsonProperty(value="checkoutAttemptId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCheckoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
    }

    public StoredPaymentMethodDetails recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    @Deprecated
    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public StoredPaymentMethodDetails storedPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
        return this;
    }

    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    @JsonProperty(value="storedPaymentMethodId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoredPaymentMethodId() {
        return this.storedPaymentMethodId;
    }

    @JsonProperty(value="storedPaymentMethodId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoredPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
    }

    public StoredPaymentMethodDetails type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The payment method type.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredPaymentMethodDetails storedPaymentMethodDetails = (StoredPaymentMethodDetails)o;
        return Objects.equals(this.checkoutAttemptId, storedPaymentMethodDetails.checkoutAttemptId) && Objects.equals(this.recurringDetailReference, storedPaymentMethodDetails.recurringDetailReference) && Objects.equals(this.storedPaymentMethodId, storedPaymentMethodDetails.storedPaymentMethodId) && Objects.equals((Object)this.type, (Object)storedPaymentMethodDetails.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.checkoutAttemptId, this.recurringDetailReference, this.storedPaymentMethodId, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StoredPaymentMethodDetails {\n");
        sb.append("    checkoutAttemptId: ").append(this.toIndentedString(this.checkoutAttemptId)).append("\n");
        sb.append("    recurringDetailReference: ").append(this.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    storedPaymentMethodId: ").append(this.toIndentedString(this.storedPaymentMethodId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static StoredPaymentMethodDetails fromJson(String jsonString) throws JsonProcessingException {
        return (StoredPaymentMethodDetails)JSON.getMapper().readValue(jsonString, StoredPaymentMethodDetails.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        BCMC_MOBILE("bcmc_mobile"),
        BCMC_MOBILE_QR("bcmc_mobile_QR"),
        BCMC_MOBILE_APP("bcmc_mobile_app"),
        MOMO_WALLET("momo_wallet"),
        MOMO_WALLET_APP("momo_wallet_app"),
        TWINT("twint"),
        PAYMAYA_WALLET("paymaya_wallet"),
        GRABPAY_SG("grabpay_SG"),
        GRABPAY_MY("grabpay_MY"),
        GRABPAY_TH("grabpay_TH"),
        GRABPAY_ID("grabpay_ID"),
        GRABPAY_VN("grabpay_VN"),
        GRABPAY_PH("grabpay_PH"),
        OXXO("oxxo"),
        GCASH("gcash"),
        DANA("dana"),
        KAKAOPAY("kakaopay"),
        TRUEMONEY("truemoney");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

