/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.CapabilityProblem;
import com.adyen.model.legalentitymanagement.DocumentReference;
import com.adyen.model.legalentitymanagement.EntityReference;
import com.adyen.model.legalentitymanagement.Individual;
import com.adyen.model.legalentitymanagement.JSON;
import com.adyen.model.legalentitymanagement.LegalEntityAssociation;
import com.adyen.model.legalentitymanagement.LegalEntityCapability;
import com.adyen.model.legalentitymanagement.Organization;
import com.adyen.model.legalentitymanagement.SoleProprietorship;
import com.adyen.model.legalentitymanagement.TransferInstrumentReference;
import com.adyen.model.legalentitymanagement.Trust;
import com.adyen.model.legalentitymanagement.UnincorporatedPartnership;
import com.adyen.model.legalentitymanagement.VerificationDeadline;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"capabilities", "documentDetails", "documents", "entityAssociations", "id", "individual", "organization", "problems", "reference", "soleProprietorship", "transferInstruments", "trust", "type", "unincorporatedPartnership", "verificationDeadlines"})
public class LegalEntity {
    public static final String JSON_PROPERTY_CAPABILITIES = "capabilities";
    private Map<String, LegalEntityCapability> capabilities = null;
    public static final String JSON_PROPERTY_DOCUMENT_DETAILS = "documentDetails";
    private List<DocumentReference> documentDetails = null;
    public static final String JSON_PROPERTY_DOCUMENTS = "documents";
    private List<EntityReference> documents = null;
    public static final String JSON_PROPERTY_ENTITY_ASSOCIATIONS = "entityAssociations";
    private List<LegalEntityAssociation> entityAssociations = null;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_INDIVIDUAL = "individual";
    private Individual individual;
    public static final String JSON_PROPERTY_ORGANIZATION = "organization";
    private Organization organization;
    public static final String JSON_PROPERTY_PROBLEMS = "problems";
    private List<CapabilityProblem> problems = null;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_SOLE_PROPRIETORSHIP = "soleProprietorship";
    private SoleProprietorship soleProprietorship;
    public static final String JSON_PROPERTY_TRANSFER_INSTRUMENTS = "transferInstruments";
    private List<TransferInstrumentReference> transferInstruments = null;
    public static final String JSON_PROPERTY_TRUST = "trust";
    private Trust trust;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_UNINCORPORATED_PARTNERSHIP = "unincorporatedPartnership";
    private UnincorporatedPartnership unincorporatedPartnership;
    public static final String JSON_PROPERTY_VERIFICATION_DEADLINES = "verificationDeadlines";
    private List<VerificationDeadline> verificationDeadlines = null;

    public LegalEntity capabilities(Map<String, LegalEntityCapability> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public LegalEntity putCapabilitiesItem(String key, LegalEntityCapability capabilitiesItem) {
        if (this.capabilities == null) {
            this.capabilities = new HashMap<String, LegalEntityCapability>();
        }
        this.capabilities.put(key, capabilitiesItem);
        return this;
    }

    @ApiModelProperty(value="Contains key-value pairs that specify the actions that the legal entity can do in your platform.The key is a capability required for your integration. For example, **issueCard** for Issuing.The value is an object containing the settings for the capability.")
    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, LegalEntityCapability> getCapabilities() {
        return this.capabilities;
    }

    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCapabilities(Map<String, LegalEntityCapability> capabilities) {
        this.capabilities = capabilities;
    }

    public LegalEntity documentDetails(List<DocumentReference> documentDetails) {
        this.documentDetails = documentDetails;
        return this;
    }

    public LegalEntity addDocumentDetailsItem(DocumentReference documentDetailsItem) {
        if (this.documentDetails == null) {
            this.documentDetails = new ArrayList<DocumentReference>();
        }
        this.documentDetails.add(documentDetailsItem);
        return this;
    }

    @ApiModelProperty(value="List of documents uploaded for the legal entity.")
    @JsonProperty(value="documentDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DocumentReference> getDocumentDetails() {
        return this.documentDetails;
    }

    @JsonProperty(value="documentDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocumentDetails(List<DocumentReference> documentDetails) {
        this.documentDetails = documentDetails;
    }

    public LegalEntity documents(List<EntityReference> documents) {
        this.documents = documents;
        return this;
    }

    public LegalEntity addDocumentsItem(EntityReference documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList<EntityReference>();
        }
        this.documents.add(documentsItem);
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="List of documents uploaded for the legal entity.")
    @JsonProperty(value="documents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getDocuments() {
        return this.documents;
    }

    @Deprecated
    @JsonProperty(value="documents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocuments(List<EntityReference> documents) {
        this.documents = documents;
    }

    public LegalEntity entityAssociations(List<LegalEntityAssociation> entityAssociations) {
        this.entityAssociations = entityAssociations;
        return this;
    }

    public LegalEntity addEntityAssociationsItem(LegalEntityAssociation entityAssociationsItem) {
        if (this.entityAssociations == null) {
            this.entityAssociations = new ArrayList<LegalEntityAssociation>();
        }
        this.entityAssociations.add(entityAssociationsItem);
        return this;
    }

    @ApiModelProperty(value="List of legal entities associated with the current legal entity. For example, ultimate beneficial owners associated with an organization through ownership or control, or as signatories.")
    @JsonProperty(value="entityAssociations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LegalEntityAssociation> getEntityAssociations() {
        return this.entityAssociations;
    }

    @JsonProperty(value="entityAssociations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntityAssociations(List<LegalEntityAssociation> entityAssociations) {
        this.entityAssociations = entityAssociations;
    }

    public LegalEntity id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the legal entity.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public LegalEntity individual(Individual individual) {
        this.individual = individual;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="individual")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Individual getIndividual() {
        return this.individual;
    }

    @JsonProperty(value="individual")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIndividual(Individual individual) {
        this.individual = individual;
    }

    public LegalEntity organization(Organization organization) {
        this.organization = organization;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="organization")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Organization getOrganization() {
        return this.organization;
    }

    @JsonProperty(value="organization")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public LegalEntity problems(List<CapabilityProblem> problems) {
        this.problems = problems;
        return this;
    }

    public LegalEntity addProblemsItem(CapabilityProblem problemsItem) {
        if (this.problems == null) {
            this.problems = new ArrayList<CapabilityProblem>();
        }
        this.problems.add(problemsItem);
        return this;
    }

    @ApiModelProperty(value="List of verification errors related to capabilities for the legal entity.")
    @JsonProperty(value="problems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CapabilityProblem> getProblems() {
        return this.problems;
    }

    @JsonProperty(value="problems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProblems(List<CapabilityProblem> problems) {
        this.problems = problems;
    }

    public LegalEntity reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the legal entity, maximum 150 characters.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public LegalEntity soleProprietorship(SoleProprietorship soleProprietorship) {
        this.soleProprietorship = soleProprietorship;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="soleProprietorship")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SoleProprietorship getSoleProprietorship() {
        return this.soleProprietorship;
    }

    @JsonProperty(value="soleProprietorship")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSoleProprietorship(SoleProprietorship soleProprietorship) {
        this.soleProprietorship = soleProprietorship;
    }

    public LegalEntity transferInstruments(List<TransferInstrumentReference> transferInstruments) {
        this.transferInstruments = transferInstruments;
        return this;
    }

    public LegalEntity addTransferInstrumentsItem(TransferInstrumentReference transferInstrumentsItem) {
        if (this.transferInstruments == null) {
            this.transferInstruments = new ArrayList<TransferInstrumentReference>();
        }
        this.transferInstruments.add(transferInstrumentsItem);
        return this;
    }

    @ApiModelProperty(value="List of transfer instruments that the legal entity owns.")
    @JsonProperty(value="transferInstruments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TransferInstrumentReference> getTransferInstruments() {
        return this.transferInstruments;
    }

    @JsonProperty(value="transferInstruments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransferInstruments(List<TransferInstrumentReference> transferInstruments) {
        this.transferInstruments = transferInstruments;
    }

    public LegalEntity trust(Trust trust) {
        this.trust = trust;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="trust")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Trust getTrust() {
        return this.trust;
    }

    @JsonProperty(value="trust")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTrust(Trust trust) {
        this.trust = trust;
    }

    public LegalEntity type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of legal entity.  Possible values: **individual**, **organization**, **soleProprietorship**, or **trust**.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public LegalEntity unincorporatedPartnership(UnincorporatedPartnership unincorporatedPartnership) {
        this.unincorporatedPartnership = unincorporatedPartnership;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="unincorporatedPartnership")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UnincorporatedPartnership getUnincorporatedPartnership() {
        return this.unincorporatedPartnership;
    }

    @JsonProperty(value="unincorporatedPartnership")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUnincorporatedPartnership(UnincorporatedPartnership unincorporatedPartnership) {
        this.unincorporatedPartnership = unincorporatedPartnership;
    }

    public LegalEntity verificationDeadlines(List<VerificationDeadline> verificationDeadlines) {
        this.verificationDeadlines = verificationDeadlines;
        return this;
    }

    public LegalEntity addVerificationDeadlinesItem(VerificationDeadline verificationDeadlinesItem) {
        if (this.verificationDeadlines == null) {
            this.verificationDeadlines = new ArrayList<VerificationDeadline>();
        }
        this.verificationDeadlines.add(verificationDeadlinesItem);
        return this;
    }

    @ApiModelProperty(value="List of verification deadlines and the capabilities that will be disallowed if verification errors are not resolved.")
    @JsonProperty(value="verificationDeadlines")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<VerificationDeadline> getVerificationDeadlines() {
        return this.verificationDeadlines;
    }

    @JsonProperty(value="verificationDeadlines")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVerificationDeadlines(List<VerificationDeadline> verificationDeadlines) {
        this.verificationDeadlines = verificationDeadlines;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegalEntity legalEntity = (LegalEntity)o;
        return Objects.equals(this.capabilities, legalEntity.capabilities) && Objects.equals(this.documentDetails, legalEntity.documentDetails) && Objects.equals(this.documents, legalEntity.documents) && Objects.equals(this.entityAssociations, legalEntity.entityAssociations) && Objects.equals(this.id, legalEntity.id) && Objects.equals(this.individual, legalEntity.individual) && Objects.equals(this.organization, legalEntity.organization) && Objects.equals(this.problems, legalEntity.problems) && Objects.equals(this.reference, legalEntity.reference) && Objects.equals(this.soleProprietorship, legalEntity.soleProprietorship) && Objects.equals(this.transferInstruments, legalEntity.transferInstruments) && Objects.equals(this.trust, legalEntity.trust) && Objects.equals((Object)this.type, (Object)legalEntity.type) && Objects.equals(this.unincorporatedPartnership, legalEntity.unincorporatedPartnership) && Objects.equals(this.verificationDeadlines, legalEntity.verificationDeadlines);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.capabilities, this.documentDetails, this.documents, this.entityAssociations, this.id, this.individual, this.organization, this.problems, this.reference, this.soleProprietorship, this.transferInstruments, this.trust, this.type, this.unincorporatedPartnership, this.verificationDeadlines});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LegalEntity {\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    documentDetails: ").append(this.toIndentedString(this.documentDetails)).append("\n");
        sb.append("    documents: ").append(this.toIndentedString(this.documents)).append("\n");
        sb.append("    entityAssociations: ").append(this.toIndentedString(this.entityAssociations)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    individual: ").append(this.toIndentedString(this.individual)).append("\n");
        sb.append("    organization: ").append(this.toIndentedString(this.organization)).append("\n");
        sb.append("    problems: ").append(this.toIndentedString(this.problems)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    soleProprietorship: ").append(this.toIndentedString(this.soleProprietorship)).append("\n");
        sb.append("    transferInstruments: ").append(this.toIndentedString(this.transferInstruments)).append("\n");
        sb.append("    trust: ").append(this.toIndentedString(this.trust)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    unincorporatedPartnership: ").append(this.toIndentedString(this.unincorporatedPartnership)).append("\n");
        sb.append("    verificationDeadlines: ").append(this.toIndentedString(this.verificationDeadlines)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static LegalEntity fromJson(String jsonString) throws JsonProcessingException {
        return (LegalEntity)JSON.getMapper().readValue(jsonString, LegalEntity.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        INDIVIDUAL("individual"),
        ORGANIZATION("organization"),
        SOLEPROPRIETORSHIP("soleProprietorship"),
        TRUST("trust"),
        UNINCORPORATEDPARTNERSHIP("unincorporatedPartnership");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

