/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.CreateMerchantWebhookRequest;
import com.adyen.model.management.GenerateHmacKeyResponse;
import com.adyen.model.management.ListWebhooksResponse;
import com.adyen.model.management.TestWebhookRequest;
import com.adyen.model.management.TestWebhookResponse;
import com.adyen.model.management.UpdateMerchantWebhookRequest;
import com.adyen.model.management.Webhook;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class WebhooksMerchantLevelApi
extends Service {
    public static final String API_VERSION = "3";
    protected String baseURL;

    public WebhooksMerchantLevelApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://management-test.adyen.com/v3");
    }

    public WebhooksMerchantLevelApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public void removeWebhook(String merchantId, String webhookId) throws ApiException, IOException {
        this.removeWebhook(merchantId, webhookId, null);
    }

    public void removeWebhook(String merchantId, String webhookId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (webhookId == null) {
            throw new IllegalArgumentException("Please provide the webhookId path parameter");
        }
        pathParams.put("webhookId", webhookId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/webhooks/{webhookId}", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.DELETE, pathParams);
    }

    public ListWebhooksResponse listAllWebhooks(String merchantId) throws ApiException, IOException {
        return this.listAllWebhooks(merchantId, null, null, null);
    }

    public ListWebhooksResponse listAllWebhooks(String merchantId, Integer pageNumber, Integer pageSize, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (pageNumber != null) {
            queryParams.put("pageNumber", pageNumber.toString());
        }
        if (pageSize != null) {
            queryParams.put("pageSize", pageSize.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/webhooks", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return ListWebhooksResponse.fromJson(jsonResult);
    }

    public Webhook getWebhook(String merchantId, String webhookId) throws ApiException, IOException {
        return this.getWebhook(merchantId, webhookId, null);
    }

    public Webhook getWebhook(String merchantId, String webhookId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (webhookId == null) {
            throw new IllegalArgumentException("Please provide the webhookId path parameter");
        }
        pathParams.put("webhookId", webhookId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/webhooks/{webhookId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return Webhook.fromJson(jsonResult);
    }

    public Webhook updateWebhook(String merchantId, String webhookId, UpdateMerchantWebhookRequest updateMerchantWebhookRequest) throws ApiException, IOException {
        return this.updateWebhook(merchantId, webhookId, updateMerchantWebhookRequest, null);
    }

    public Webhook updateWebhook(String merchantId, String webhookId, UpdateMerchantWebhookRequest updateMerchantWebhookRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (webhookId == null) {
            throw new IllegalArgumentException("Please provide the webhookId path parameter");
        }
        pathParams.put("webhookId", webhookId);
        String requestBody = updateMerchantWebhookRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/webhooks/{webhookId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return Webhook.fromJson(jsonResult);
    }

    public Webhook setUpWebhook(String merchantId, CreateMerchantWebhookRequest createMerchantWebhookRequest) throws ApiException, IOException {
        return this.setUpWebhook(merchantId, createMerchantWebhookRequest, null);
    }

    public Webhook setUpWebhook(String merchantId, CreateMerchantWebhookRequest createMerchantWebhookRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        String requestBody = createMerchantWebhookRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/webhooks", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return Webhook.fromJson(jsonResult);
    }

    public GenerateHmacKeyResponse generateHmacKey(String merchantId, String webhookId) throws ApiException, IOException {
        return this.generateHmacKey(merchantId, webhookId, null);
    }

    public GenerateHmacKeyResponse generateHmacKey(String merchantId, String webhookId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (webhookId == null) {
            throw new IllegalArgumentException("Please provide the webhookId path parameter");
        }
        pathParams.put("webhookId", webhookId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/webhooks/{webhookId}/generateHmac", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return GenerateHmacKeyResponse.fromJson(jsonResult);
    }

    public TestWebhookResponse testWebhook(String merchantId, String webhookId, TestWebhookRequest testWebhookRequest) throws ApiException, IOException {
        return this.testWebhook(merchantId, webhookId, testWebhookRequest, null);
    }

    public TestWebhookResponse testWebhook(String merchantId, String webhookId, TestWebhookRequest testWebhookRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (webhookId == null) {
            throw new IllegalArgumentException("Please provide the webhookId path parameter");
        }
        pathParams.put("webhookId", webhookId);
        String requestBody = testWebhookRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/webhooks/{webhookId}/test", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return TestWebhookResponse.fromJson(jsonResult);
    }
}

