/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.checkout;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.checkout.BalanceCheckRequest;
import com.adyen.model.checkout.BalanceCheckResponse;
import com.adyen.model.checkout.CancelOrderRequest;
import com.adyen.model.checkout.CancelOrderResponse;
import com.adyen.model.checkout.CreateOrderRequest;
import com.adyen.model.checkout.CreateOrderResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;

public class OrdersApi
extends Service {
    public static final String API_VERSION = "71";
    protected String baseURL;

    public OrdersApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://checkout-test.adyen.com/v71");
    }

    public OrdersApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public CreateOrderResponse orders(CreateOrderRequest createOrderRequest) throws ApiException, IOException {
        return this.orders(createOrderRequest, null);
    }

    public CreateOrderResponse orders(CreateOrderRequest createOrderRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = createOrderRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/orders", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return CreateOrderResponse.fromJson(jsonResult);
    }

    public CancelOrderResponse cancelOrder(CancelOrderRequest cancelOrderRequest) throws ApiException, IOException {
        return this.cancelOrder(cancelOrderRequest, null);
    }

    public CancelOrderResponse cancelOrder(CancelOrderRequest cancelOrderRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = cancelOrderRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/orders/cancel", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return CancelOrderResponse.fromJson(jsonResult);
    }

    public BalanceCheckResponse getBalanceOfGiftCard(BalanceCheckRequest balanceCheckRequest) throws ApiException, IOException {
        return this.getBalanceOfGiftCard(balanceCheckRequest, null);
    }

    public BalanceCheckResponse getBalanceOfGiftCard(BalanceCheckRequest balanceCheckRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = balanceCheckRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/paymentMethods/balance", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return BalanceCheckResponse.fromJson(jsonResult);
    }
}

