/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"city", "country", "mcc", "name", "taxId"})
public class SubMerchant {
    public static final String JSON_PROPERTY_CITY = "city";
    private String city;
    public static final String JSON_PROPERTY_COUNTRY = "country";
    private String country;
    public static final String JSON_PROPERTY_MCC = "mcc";
    private String mcc;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TAX_ID = "taxId";
    private String taxId;

    public SubMerchant city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(value="The city of the sub-merchant's address. * Format: Alphanumeric * Maximum length: 13 characters")
    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCity() {
        return this.city;
    }

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCity(String city) {
        this.city = city;
    }

    public SubMerchant country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(value="The three-letter country code of the sub-merchant's address. For example, **BRA** for Brazil.  * Format: [ISO 3166-1 alpha-3](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) * Fixed length: 3 characters")
    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountry() {
        return this.country;
    }

    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountry(String country) {
        this.country = country;
    }

    public SubMerchant mcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    @ApiModelProperty(value="The sub-merchant's 4-digit Merchant Category Code (MCC).  * Format: Numeric * Fixed length: 4 digits")
    @JsonProperty(value="mcc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMcc() {
        return this.mcc;
    }

    @JsonProperty(value="mcc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    public SubMerchant name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the sub-merchant. Based on scheme specifications, this value will overwrite the shopper statement  that will appear in the card statement. * Format: Alphanumeric * Maximum length: 22 characters")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public SubMerchant taxId(String taxId) {
        this.taxId = taxId;
        return this;
    }

    @ApiModelProperty(value="The tax ID of the sub-merchant. * Format: Numeric * Fixed length: 11 digits for the CPF or 14 digits for the CNPJ")
    @JsonProperty(value="taxId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTaxId() {
        return this.taxId;
    }

    @JsonProperty(value="taxId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubMerchant subMerchant = (SubMerchant)o;
        return Objects.equals(this.city, subMerchant.city) && Objects.equals(this.country, subMerchant.country) && Objects.equals(this.mcc, subMerchant.mcc) && Objects.equals(this.name, subMerchant.name) && Objects.equals(this.taxId, subMerchant.taxId);
    }

    public int hashCode() {
        return Objects.hash(this.city, this.country, this.mcc, this.name, this.taxId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubMerchant {\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    mcc: ").append(this.toIndentedString(this.mcc)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    taxId: ").append(this.toIndentedString(this.taxId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static SubMerchant fromJson(String jsonString) throws JsonProcessingException {
        return (SubMerchant)JSON.getMapper().readValue(jsonString, SubMerchant.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

