/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"additionalSalesChannels", "language"})
public class GeneratePciDescriptionRequest {
    public static final String JSON_PROPERTY_ADDITIONAL_SALES_CHANNELS = "additionalSalesChannels";
    private List<AdditionalSalesChannelsEnum> additionalSalesChannels = null;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private String language;

    public GeneratePciDescriptionRequest additionalSalesChannels(List<AdditionalSalesChannelsEnum> additionalSalesChannels) {
        this.additionalSalesChannels = additionalSalesChannels;
        return this;
    }

    public GeneratePciDescriptionRequest addAdditionalSalesChannelsItem(AdditionalSalesChannelsEnum additionalSalesChannelsItem) {
        if (this.additionalSalesChannels == null) {
            this.additionalSalesChannels = new ArrayList<AdditionalSalesChannelsEnum>();
        }
        this.additionalSalesChannels.add(additionalSalesChannelsItem);
        return this;
    }

    @ApiModelProperty(value="An array of additional sales channels to generate PCI questionnaires. Include the relevant sales channels if you need your user to sign PCI questionnaires. Not required if you [create stores](https://docs.adyen.com/marketplaces-and-platforms/additional-for-platform-setup/create-stores/) and [add payment methods](https://docs.adyen.com/marketplaces-and-platforms/payment-methods/) before you generate the questionnaires.  Possible values: *  **eCommerce** *  **pos** *  **ecomMoto** *  **posMoto**  ")
    @JsonProperty(value="additionalSalesChannels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AdditionalSalesChannelsEnum> getAdditionalSalesChannels() {
        return this.additionalSalesChannels;
    }

    @JsonProperty(value="additionalSalesChannels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalSalesChannels(List<AdditionalSalesChannelsEnum> additionalSalesChannels) {
        this.additionalSalesChannels = additionalSalesChannels;
    }

    public GeneratePciDescriptionRequest language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(value="Sets the language of the PCI questionnaire. Its value is a two-character [ISO 639-1](https://en.wikipedia.org/wiki/ISO_639-1) language code, for example, **en**.")
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneratePciDescriptionRequest generatePciDescriptionRequest = (GeneratePciDescriptionRequest)o;
        return Objects.equals(this.additionalSalesChannels, generatePciDescriptionRequest.additionalSalesChannels) && Objects.equals(this.language, generatePciDescriptionRequest.language);
    }

    public int hashCode() {
        return Objects.hash(this.additionalSalesChannels, this.language);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeneratePciDescriptionRequest {\n");
        sb.append("    additionalSalesChannels: ").append(this.toIndentedString(this.additionalSalesChannels)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static GeneratePciDescriptionRequest fromJson(String jsonString) throws JsonProcessingException {
        return (GeneratePciDescriptionRequest)JSON.getMapper().readValue(jsonString, GeneratePciDescriptionRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum AdditionalSalesChannelsEnum {
        ECOMMERCE("eCommerce"),
        ECOMMOTO("ecomMoto"),
        POS("pos"),
        POSMOTO("posMoto");

        private String value;

        private AdditionalSalesChannelsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AdditionalSalesChannelsEnum fromValue(String value) {
            for (AdditionalSalesChannelsEnum b : AdditionalSalesChannelsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

