/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"phoneCountryCode", "phoneNumber", "phoneType"})
public class PhoneNumber {
    public static final String JSON_PROPERTY_PHONE_COUNTRY_CODE = "phoneCountryCode";
    private String phoneCountryCode;
    public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
    private String phoneNumber;
    public static final String JSON_PROPERTY_PHONE_TYPE = "phoneType";
    private PhoneTypeEnum phoneType;

    public PhoneNumber phoneCountryCode(String phoneCountryCode) {
        this.phoneCountryCode = phoneCountryCode;
        return this;
    }

    @ApiModelProperty(value="The two-character ISO-3166-1 alpha-2 country code of the phone number. For example, **US** or **NL**.")
    @JsonProperty(value="phoneCountryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPhoneCountryCode() {
        return this.phoneCountryCode;
    }

    @JsonProperty(value="phoneCountryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhoneCountryCode(String phoneCountryCode) {
        this.phoneCountryCode = phoneCountryCode;
    }

    public PhoneNumber phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(value="The phone number. The inclusion of the phone number country code is not necessary.")
    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public PhoneNumber phoneType(PhoneTypeEnum phoneType) {
        this.phoneType = phoneType;
        return this;
    }

    @ApiModelProperty(value="The type of the phone number. Possible values: **Landline**, **Mobile**, **SIP**, **Fax**.")
    @JsonProperty(value="phoneType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PhoneTypeEnum getPhoneType() {
        return this.phoneType;
    }

    @JsonProperty(value="phoneType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhoneType(PhoneTypeEnum phoneType) {
        this.phoneType = phoneType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhoneNumber phoneNumber = (PhoneNumber)o;
        return Objects.equals(this.phoneCountryCode, phoneNumber.phoneCountryCode) && Objects.equals(this.phoneNumber, phoneNumber.phoneNumber) && Objects.equals((Object)this.phoneType, (Object)phoneNumber.phoneType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.phoneCountryCode, this.phoneNumber, this.phoneType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PhoneNumber {\n");
        sb.append("    phoneCountryCode: ").append(this.toIndentedString(this.phoneCountryCode)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    phoneType: ").append(this.toIndentedString((Object)this.phoneType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PhoneNumber fromJson(String jsonString) throws JsonProcessingException {
        return (PhoneNumber)JSON.getMapper().readValue(jsonString, PhoneNumber.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum PhoneTypeEnum {
        FAX("Fax"),
        LANDLINE("Landline"),
        MOBILE("Mobile"),
        SIP("SIP");

        private String value;

        private PhoneTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PhoneTypeEnum fromValue(String value) {
            for (PhoneTypeEnum b : PhoneTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

