/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.Amount;
import com.adyen.model.payment.JSON;
import com.adyen.model.payment.PlatformChargebackLogic;
import com.adyen.model.payment.Split;
import com.adyen.model.payment.ThreeDSecureData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"additionalData", "merchantAccount", "modificationAmount", "mpiData", "originalMerchantReference", "platformChargebackLogic", "reference", "splits", "tenderReference", "uniqueTerminalId"})
public class TechnicalCancelRequest {
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData = null;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_MODIFICATION_AMOUNT = "modificationAmount";
    private Amount modificationAmount;
    public static final String JSON_PROPERTY_MPI_DATA = "mpiData";
    private ThreeDSecureData mpiData;
    public static final String JSON_PROPERTY_ORIGINAL_MERCHANT_REFERENCE = "originalMerchantReference";
    private String originalMerchantReference;
    public static final String JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC = "platformChargebackLogic";
    private PlatformChargebackLogic platformChargebackLogic;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_SPLITS = "splits";
    private List<Split> splits = null;
    public static final String JSON_PROPERTY_TENDER_REFERENCE = "tenderReference";
    private String tenderReference;
    public static final String JSON_PROPERTY_UNIQUE_TERMINAL_ID = "uniqueTerminalId";
    private String uniqueTerminalId;

    public TechnicalCancelRequest additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public TechnicalCancelRequest putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @ApiModelProperty(value="This field contains additional data, which may be required for a particular modification request.  The additionalData object consists of entries, each of which includes the key and value.")
    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public TechnicalCancelRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account that is used to process the payment.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public TechnicalCancelRequest modificationAmount(Amount modificationAmount) {
        this.modificationAmount = modificationAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="modificationAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getModificationAmount() {
        return this.modificationAmount;
    }

    @JsonProperty(value="modificationAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModificationAmount(Amount modificationAmount) {
        this.modificationAmount = modificationAmount;
    }

    public TechnicalCancelRequest mpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="mpiData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThreeDSecureData getMpiData() {
        return this.mpiData;
    }

    @JsonProperty(value="mpiData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
    }

    public TechnicalCancelRequest originalMerchantReference(String originalMerchantReference) {
        this.originalMerchantReference = originalMerchantReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The original merchant reference to cancel.")
    @JsonProperty(value="originalMerchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOriginalMerchantReference() {
        return this.originalMerchantReference;
    }

    @JsonProperty(value="originalMerchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOriginalMerchantReference(String originalMerchantReference) {
        this.originalMerchantReference = originalMerchantReference;
    }

    public TechnicalCancelRequest platformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
        this.platformChargebackLogic = platformChargebackLogic;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="platformChargebackLogic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PlatformChargebackLogic getPlatformChargebackLogic() {
        return this.platformChargebackLogic;
    }

    @JsonProperty(value="platformChargebackLogic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlatformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
        this.platformChargebackLogic = platformChargebackLogic;
    }

    public TechnicalCancelRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the payment modification. This reference is visible in Customer Area and in reports. Maximum length: 80 characters.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public TechnicalCancelRequest splits(List<Split> splits) {
        this.splits = splits;
        return this;
    }

    public TechnicalCancelRequest addSplitsItem(Split splitsItem) {
        if (this.splits == null) {
            this.splits = new ArrayList<Split>();
        }
        this.splits.add(splitsItem);
        return this;
    }

    @ApiModelProperty(value="An array of objects specifying how the amount should be split between accounts when using Adyen for Platforms. For details, refer to [Providing split information](https://docs.adyen.com/marketplaces-and-platforms/processing-payments#providing-split-information).")
    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Split> getSplits() {
        return this.splits;
    }

    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public TechnicalCancelRequest tenderReference(String tenderReference) {
        this.tenderReference = tenderReference;
        return this;
    }

    @ApiModelProperty(value="The transaction reference provided by the PED. For point-of-sale integrations only.")
    @JsonProperty(value="tenderReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTenderReference() {
        return this.tenderReference;
    }

    @JsonProperty(value="tenderReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTenderReference(String tenderReference) {
        this.tenderReference = tenderReference;
    }

    public TechnicalCancelRequest uniqueTerminalId(String uniqueTerminalId) {
        this.uniqueTerminalId = uniqueTerminalId;
        return this;
    }

    @ApiModelProperty(value="Unique terminal ID for the PED that originally processed the request. For point-of-sale integrations only.")
    @JsonProperty(value="uniqueTerminalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUniqueTerminalId() {
        return this.uniqueTerminalId;
    }

    @JsonProperty(value="uniqueTerminalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUniqueTerminalId(String uniqueTerminalId) {
        this.uniqueTerminalId = uniqueTerminalId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TechnicalCancelRequest technicalCancelRequest = (TechnicalCancelRequest)o;
        return Objects.equals(this.additionalData, technicalCancelRequest.additionalData) && Objects.equals(this.merchantAccount, technicalCancelRequest.merchantAccount) && Objects.equals(this.modificationAmount, technicalCancelRequest.modificationAmount) && Objects.equals(this.mpiData, technicalCancelRequest.mpiData) && Objects.equals(this.originalMerchantReference, technicalCancelRequest.originalMerchantReference) && Objects.equals(this.platformChargebackLogic, technicalCancelRequest.platformChargebackLogic) && Objects.equals(this.reference, technicalCancelRequest.reference) && Objects.equals(this.splits, technicalCancelRequest.splits) && Objects.equals(this.tenderReference, technicalCancelRequest.tenderReference) && Objects.equals(this.uniqueTerminalId, technicalCancelRequest.uniqueTerminalId);
    }

    public int hashCode() {
        return Objects.hash(this.additionalData, this.merchantAccount, this.modificationAmount, this.mpiData, this.originalMerchantReference, this.platformChargebackLogic, this.reference, this.splits, this.tenderReference, this.uniqueTerminalId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TechnicalCancelRequest {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    modificationAmount: ").append(this.toIndentedString(this.modificationAmount)).append("\n");
        sb.append("    mpiData: ").append(this.toIndentedString(this.mpiData)).append("\n");
        sb.append("    originalMerchantReference: ").append(this.toIndentedString(this.originalMerchantReference)).append("\n");
        sb.append("    platformChargebackLogic: ").append(this.toIndentedString(this.platformChargebackLogic)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    splits: ").append(this.toIndentedString(this.splits)).append("\n");
        sb.append("    tenderReference: ").append(this.toIndentedString(this.tenderReference)).append("\n");
        sb.append("    uniqueTerminalId: ").append(this.toIndentedString(this.uniqueTerminalId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TechnicalCancelRequest fromJson(String jsonString) throws JsonProcessingException {
        return (TechnicalCancelRequest)JSON.getMapper().readValue(jsonString, TechnicalCancelRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

